/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.SchemaParsedObject;
import oracle.bpm.project.catalog.parser.xsd.ExtendedNamespace;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.parser.xsd.SchemaParser;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.project.catalog.xmltype.OraMdsImportResolver;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.utils.XmlUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.XML_SCHEMA, isStructural=true)
public final class XsdTypeLoader
extends AbstractTypeLoader<Schema> {
    public XsdTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public ParsedObject<Schema> parseUri(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.parseUri must not be null");
        }
        SchemaParser parser = this.buildSchemaParser();
        Schema schema = parser.parse(uri);
        schema.verify();
        SchemaParsedObject schemaParsedObject = new SchemaParsedObject(uri, schema);
        if (schemaParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.parseUri must not return null");
        }
        return schemaParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<Schema> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadTypes must not be null");
        }
        Schema schema = parsedObject.getParsedData();
        Map<String, TypeDescription> map = this.buildTypes(parsedObject.getUri(), schema);
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.loadTypes must not return null");
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Map<String, TypeDescription> buildTypes(@NotNull URI uri, @NotNull Schema schema) throws TypeBuildException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not be null");
        }
        Hashtable<String, TypeDescription> result = new Hashtable<String, TypeDescription>();
        schema.declare();
        schema.buildType(null);
        ExtendedNamespace target = schema.getContext().getTarget();
        String module = XmlUtils.getExtModuleFromNamespace((String)target.getUri());
        URL location = this.uriToUrl(uri);
        Map<String, TypeDescription> complete = target.getDefinedElements();
        Map<String, TypeDescription> types = target.getAllDefinedTypes();
        this.addTypesWithValidNames(types, complete);
        Map<String, TypeDescription> attributes = target.getAllDefinedAttributes();
        this.addTypesWithValidNames(attributes, complete);
        Map<String, TypeDescription> attGroup = target.getAllDefinedAttributeGroups();
        this.addTypesWithValidNames(attGroup, complete);
        Map<String, TypeDescription> groups = target.getAllDefinedGroups();
        this.addTypesWithValidNames(groups, complete);
        String relativePath = Utils.resolvePath(location, this.getFileSystem());
        for (TypeDescription type : complete.values()) {
            result.put(module + "." + type.getText(), type);
            Utils.fixResourceLocation(location, relativePath, type);
        }
        Hashtable<String, TypeDescription> hashtable = result;
        if (hashtable == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildTypes must not return null");
        }
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private SchemaParser buildSchemaParser() {
        SchemaParser parser = new SchemaParser(this.getFileSystem(), this.typeFinder);
        parser.setXsdImportResolver(new OraMdsImportResolver());
        parser.setCatalog(this.getCatalog());
        SchemaParser schemaParser = parser;
        if (schemaParser == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.buildSchemaParser must not return null");
        }
        return schemaParser;
    }

    private void addTypesWithValidNames(@NotNull Map<String, TypeDescription> origin, @NotNull Map<String, TypeDescription> complete) {
        if (origin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.addTypesWithValidNames must not be null");
        }
        if (complete == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.addTypesWithValidNames must not be null");
        }
        for (String name : origin.keySet()) {
            TypeDescription type = origin.get(name);
            if (!type.isXmlObject() && !type.isEnum()) continue;
            String validName = this.getValidName(complete, name);
            if (!validName.equals(name)) {
                type.asObject().setName(TypeUtils.shortName((String)validName));
            }
            complete.put(validName, type);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String getValidName(@NotNull Map<String, TypeDescription> elements, @NotNull String name) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not be null");
        }
        if (this.containsKey(elements.keySet(), name)) {
            String nameType;
            name = nameType = name + "Type";
            int i = 2;
            while (this.containsKey(elements.keySet(), name)) {
                name = nameType + i;
                ++i;
            }
        }
        String string = name;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.getValidName must not return null");
        }
        return string;
    }

    private boolean containsKey(@NotNull Set<String> names, @NotNull String name) {
        if (names == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.containsKey must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/XsdTypeLoader.containsKey must not be null");
        }
        boolean result = false;
        for (String typeName : names) {
            if (!Identifier.classname(typeName).equals(Identifier.classname(name))) continue;
            result = true;
            break;
        }
        return result;
    }
}

