/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.net.URI;
import java.util.Set;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.LoaderUtils;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaParsedObject
extends ParsedObject<Schema> {
    private Set<Dependency> dependencies;

    public SchemaParsedObject(@NotNull URI uri, @Nullable Schema parsedData) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/SchemaParsedObject.<init> must not be null");
        }
        super(uri, parsedData);
        this.dependencies = this.parseDependencies();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = this.dependencies;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/SchemaParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Set<Dependency> parseDependencies() throws TypeParseException {
        Schema schema = (Schema)this.getParsedData();
        Set<Dependency> set = LoaderUtils.findSchemaDependencies(this.getUri(), schema);
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/SchemaParsedObject.parseDependencies must not return null");
        }
        return set;
    }
}

