/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.Str;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.parser.xsd.Import;
import oracle.bpm.project.catalog.parser.xsd.Include;
import oracle.bpm.project.catalog.parser.xsd.Schema;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import org.jetbrains.annotations.NotNull;

public class LoaderUtils {
    public static Set<Dependency> findSchemaDependencies(@NotNull URI baseUri, @NotNull Schema schema) throws TypeParseException {
        if (baseUri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/LoaderUtils.findSchemaDependencies must not be null");
        }
        if (schema == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/LoaderUtils.findSchemaDependencies must not be null");
        }
        TreeSet<Dependency> uris = new TreeSet<Dependency>();
        List<Import> imports = schema.getAllElementsByClass(Import.class);
        for (Import anImport : imports) {
            String s = anImport.getSchemaLocation();
            if (Str.isEmpty(s)) continue;
            try {
                URI uri = URLHelper.createFrom((URI)baseUri, (String)s);
                uris.add(new Dependency(uri, ResourceType.XML_SCHEMA));
            }
            catch (IOException e) {
                throw new TypeParseException(baseUri, e);
            }
            catch (URISyntaxException e) {
                throw new TypeParseException(baseUri, e);
            }
        }
        List<Include> includes = schema.getAllElementsByClass(Include.class);
        for (Include include : includes) {
            String s = include.getSchemaLocation();
            if (Str.isEmpty(s)) continue;
            try {
                URI uri = URLHelper.createFrom((URI)baseUri, (String)s);
                uris.add(new Dependency(uri, ResourceType.XML_SCHEMA));
            }
            catch (IOException e) {
                throw new TypeParseException(baseUri, e);
            }
            catch (URISyntaxException e) {
                throw new TypeParseException(baseUri, e);
            }
        }
        return uris;
    }
}

