/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.bpm.extensionpoint.metadata.TypeLoaderMetadata;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XmlElementType;
import oracle.bpm.project.catalog.loaders.AbstractTypeLoader;
import oracle.bpm.project.catalog.loaders.EventParseException;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.loaders.impl.EventParsedObject;
import oracle.bpm.project.catalog.parser.events.jaxb.DefinitionsType;
import oracle.bpm.project.catalog.parser.events.jaxb.EventDefinitionType;
import oracle.bpm.project.catalog.recognizer.ResourceType;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.xml.JaxbHelper;
import org.jetbrains.annotations.NotNull;

@TypeLoaderMetadata(resourceType=ResourceType.EVENT, isStructural=false, rootModules={"Events"})
public class EventTypeLoader
extends AbstractTypeLoader<DefinitionsType> {
    private static JAXBContext jaxbContext;

    public EventTypeLoader(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem, @NotNull TypeIndex typeFinder) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.<init> must not be null");
        }
        if (typeFinder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.<init> must not be null");
        }
        super(catalog, fileSystem, typeFinder);
    }

    public static JAXBContext getJaxbContext() {
        if (jaxbContext == null) {
            jaxbContext = JaxbHelper.newContext("oracle.bpm.project.catalog.parser.events.jaxb");
        }
        return jaxbContext;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ParsedObject<DefinitionsType> parseUri(@NotNull URI uri) throws TypeParseException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.parseUri must not be null");
        }
        InputStream inputStream = null;
        EventParsedObject parsedObject = null;
        try {
            inputStream = URLHelper.createURL((String)uri.toString()).openStream();
            Unmarshaller unmarshaller = EventTypeLoader.getJaxbContext().createUnmarshaller();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(inputStream);
            DefinitionsType definitionsType = (DefinitionsType)element.getValue();
            parsedObject = new EventParsedObject(uri, definitionsType);
        }
        catch (MalformedURLException e) {
            try {
                throw new EventParseException(uri, (IOException)e);
                catch (JAXBException e2) {
                    throw new EventParseException(uri, e2);
                }
                catch (IOException e3) {
                    throw new EventParseException(uri, e3);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close(inputStream);
        EventParsedObject eventParsedObject = parsedObject;
        if (eventParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.parseUri must not return null");
        }
        return eventParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> loadTypes(@NotNull ParsedObject<DefinitionsType> parsedObject) throws TypeBuildException {
        if (parsedObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.loadTypes must not be null");
        }
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        DefinitionsType definitionsType = parsedObject.getParsedData();
        List<EventDefinitionType> definitionTypes = definitionsType.getEventDefinition();
        String module = this.buildModuleName(definitionsType.getTargetNamespace());
        String namespace = definitionsType.getTargetNamespace();
        for (EventDefinitionType eventType : definitionTypes) {
            TypeDescription type = this.createEventType(eventType, namespace);
            result.put(module + "." + type.getName(), type);
        }
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.loadTypes must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private String buildModuleName(@NotNull String targetNamespace) {
        if (targetNamespace == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.buildModuleName must not be null");
        }
        int i = targetNamespace.lastIndexOf(47);
        String moduleName = targetNamespace.substring(i + 1);
        String string = "Events." + moduleName;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.buildModuleName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private TypeDescription createEventType(@NotNull EventDefinitionType eventType, @NotNull String namespace) {
        if (eventType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.createEventType must not be null");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.createEventType must not be null");
        }
        String nativeName = eventType.getName();
        ObjectTypeDescription result = new ObjectTypeDescription(Identifier.classname(nativeName));
        result.setNativeName(nativeName);
        result.setProperty("namespace", namespace);
        result.setComponentType(ComponentType.EVENT_DEFINITION.getText());
        result.addModifier(0x100000000L);
        EventDefinitionType.Content content = eventType.getContent();
        QName qName = content.getElement();
        String uniqueId = UUIDFactory.createXmlId((XmlElementType)XmlElementType.ELEMENT, (String)qName.getNamespaceURI(), (String)qName.getLocalPart()).getId();
        AttributeTypeDescription attribute = new AttributeTypeDescription("payload", (TypeRef)new DynamicRef(ComponentType.XML.getText(), uniqueId, this.getCatalog()));
        result.addMember((MethodTypeDescription)attribute);
        ObjectTypeDescription objectTypeDescription = result;
        if (objectTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/impl/EventTypeLoader.createEventType must not return null");
        }
        return objectTypeDescription;
    }
}

