/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.io.fs.protocol.URLHelper;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.TypeError;
import oracle.bpm.project.catalog.loaders.TypeBuildException;
import oracle.bpm.project.catalog.type.ErrorTypeFactory;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeBuildException
extends TypeBuildException {
    private final URI uri;
    static final long serialCheck = 1585150021010301100L;
    static final long serialVersionUID = -2420966143952728311L;

    protected ResourceTypeBuildException(@NotNull URI uri, @NotNull TypeError typeError) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.<init> must not be null");
        }
        if (typeError == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.<init> must not be null");
        }
        super(typeError);
        this.uri = uri;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Map<String, TypeDescription> buildTypeErrors() {
        HashMap<String, TypeDescription> result = new HashMap<String, TypeDescription>();
        ObjectTypeDescription typeDescription = ErrorTypeFactory.createErrorResourceType(this.uri, (URI)null, this);
        result.put(typeDescription.getName(), (TypeDescription)typeDescription);
        HashMap<String, TypeDescription> hashMap = result;
        if (hashMap == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.buildTypeErrors must not return null");
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected static String relativePathFromUrl(@NotNull URL url) {
        String result;
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.relativePathFromUrl must not be null");
        }
        try {
            result = ResourceTypeBuildException.relativePathFromUri(url.toURI());
        }
        catch (URISyntaxException e) {
            result = url.toString();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.relativePathFromUrl must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected static String relativePathFromUri(@NotNull URI uri) {
        String result;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.relativePathFromUri must not be null");
        }
        try {
            result = URLHelper.getResourceLocation((URI)uri);
        }
        catch (IOException e) {
            result = uri.toString();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ResourceTypeBuildException.relativePathFromUri must not return null");
        }
        return string;
    }
}

