/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.loaders;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.loaders.Dependency;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.TypeParseException;
import oracle.bpm.project.catalog.type.ErrorTypeFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ErrorParsedObject<T>
extends ParsedObject<T> {
    private TypeDescription errorType;

    ErrorParsedObject(@NotNull URI uri, @Nullable URI dependant, @NotNull TypeParseException exception) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ErrorParsedObject.<init> must not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ErrorParsedObject.<init> must not be null");
        }
        super(uri, null);
        this.errorType = ErrorTypeFactory.createErrorResourceType(uri, dependant, exception);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> ErrorParsedObject<T> create(@NotNull URI uri, @Nullable URI dependant, @NotNull TypeParseException exception) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ErrorParsedObject.create must not be null");
        }
        if (exception == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/loaders/ErrorParsedObject.create must not be null");
        }
        ErrorParsedObject<T> errorParsedObject = new ErrorParsedObject<T>(uri, dependant, exception);
        if (errorParsedObject == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ErrorParsedObject.create must not return null");
        }
        return errorParsedObject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Dependency> getDependencies() {
        Set<Dependency> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ErrorParsedObject.getDependencies must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TypeDescription getErrorType() {
        TypeDescription typeDescription = this.errorType;
        if (typeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/loaders/ErrorParsedObject.getErrorType must not return null");
        }
        return typeDescription;
    }
}

