/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite.jaxb;

import java.io.IOException;
import java.util.Map;
import oracle.bpm.lang.Str;
import oracle.bpm.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XmlWriterContentHandler
implements ContentHandler {
    private Map<String, String> prefixMappings;
    private boolean writePrefixMappings = true;
    private XmlWriter writer;

    public XmlWriterContentHandler(XmlWriter writer, Map<String, String> prefixMappings) {
        this.writer = writer;
        this.prefixMappings = prefixMappings;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.writer.startDocument();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.prefixMappings.containsKey(uri)) {
            throw new SAXException("unexpected namespace " + uri);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String tagName = this.makePrefixName(uri, localName);
        try {
            this.writer.startElement(tagName);
            if (this.writePrefixMappings) {
                this.writePrefixMappings = false;
                for (Map.Entry<String, String> entry : this.prefixMappings.entrySet()) {
                    String prefix = entry.getValue();
                    this.writer.printAttribute(prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, entry.getKey());
                }
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                this.writer.printAttribute(this.makePrefixName(atts.getURI(i), atts.getLocalName(i)), atts.getValue(i));
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.writer.endElement();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.printChars(String.valueOf(ch, start, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.printChars(String.valueOf(ch, start, length));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        throw new UnsupportedOperationException("processingInstruction while marshalling");
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        throw new UnsupportedOperationException("skippedEntity while marshalling");
    }

    private String makePrefixName(String uri, String localName) throws SAXException {
        if (Str.isEmpty(uri)) {
            return localName;
        }
        String prefix = this.prefixMappings.get(uri);
        if (prefix == null) {
            throw new SAXException("Unexpected namespace: " + uri);
        }
        return prefix.length() == 0 ? localName : prefix + ":" + localName;
    }
}

