/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.sets.IdentityHashSet;
import oracle.bpm.io.IndentedWriter;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.ServiceObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionLanguage;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.catalog.composite.ScaController;
import oracle.bpm.project.catalog.composite.ScaEventInfo;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.catalog.composite.ScaWsdlInfo;
import oracle.bpm.project.catalog.composite.util.FlowNodeFilter;
import oracle.bpm.project.catalog.msg.ProjectCatalogMsg;
import oracle.bpm.project.interfaces.ProcessOperationWrapper;
import oracle.bpm.project.interfaces.ProcessOperationWrapperImpl;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.catalog.SignalObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.CallActivity;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.model.processes.ParticipantReference;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessCommunicationEnabled;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeUpdater {
    @NotNull
    private final ScaController controller;
    @NotNull
    private final Interceptor interceptor;
    @NotNull
    private final Process process;
    @NotNull
    private final String processId;
    private final String processServiceName;
    private static final String BPEL_CONFIG_ONE_WAY_DELIVERY_POLICY = "bpel.config.oneWayDeliveryPolicy";
    private static final String BPEL_CONFIG_TRANSACTION = "bpel.config.transaction";
    private static final String TASK_SERVICE_WSDL = "oramds:/soa/shared/workflow/TaskServiceInterface.wsdl";
    private static final String TASK_SERVICE_NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";
    private static final String TASK_SERVICE_PORT = "TaskService";
    private static final String TASK_SERVICE_SERVICE = "TaskService";
    private static final String TASK_SERVICE_CALLBACK_PORT = "TaskServiceCallback";
    private static final Class<?> SCAC_CONTROLLER_PROXY_CLASS = Proxy.getProxyClass(ScaController.class.getClassLoader(), ScaController.class);

    public CompositeUpdater(@NotNull Process process, @NotNull ScaController controller) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.<init> must not be null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.<init> must not be null");
        }
        this.process = process;
        this.interceptor = new Interceptor(controller);
        this.controller = CompositeUpdater.newScaController(this.interceptor);
        this.processId = process.getId();
        this.processServiceName = this.processId + ".service";
    }

    public void updateComposite() {
        try {
            if (!this.process.isCallableSubprocess()) {
                this.checkBpmnComponent();
                GarbageCollector gc = this.setupGarbageCollector();
                this.checkExposedServices(gc);
                boolean hasManualStart = this.processActivities(gc);
                this.updateBpmnComponentProperties(hasManualStart);
                this.processEvents(gc);
                if (!this.isBpelBased()) {
                    gc.sweep();
                }
            } else {
                for (Process caller : this.findCallers()) {
                    new CompositeUpdater(caller, this.controller).updateComposite();
                }
            }
            this.controller.commitChanges();
        }
        catch (Throwable t) {
            this.handleUnexpectedError(t);
        }
    }

    public String getBpelPath() {
        return this.process.getAnnotationValue("BPEL.IMPLEMENTATION", false);
    }

    public void delete() {
        if (!this.process.isCallableSubprocess()) {
            this.controller.deleteComponent(this.processId);
            this.controller.deleteServiceEntrypoint(this.processServiceName);
            this.controller.commitChanges();
        }
    }

    Sequence<Process> findCallers() {
        assert (this.process.isCallableSubprocess());
        return CollectionUtils.asSequence(this.process.getProject().getProcesses()).select(new Predicate<Process>(){

            @Override
            public boolean check(@Nullable Process value) {
                return value != null && !value.isCallableSubprocess() && !ModelUtils.getAllActivities(value).select(CompositeUpdater.callersOf(CompositeUpdater.this.process)).isEmpty();
            }
        });
    }

    private static Predicate<Activity> callersOf(final @NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.callersOf must not be null");
        }
        return new Predicate<Activity>(){

            @Override
            public boolean check(@Nullable Activity value) {
                return value != null && value.isCallActivity() && value.asAnyNode(CallActivity.class).getCalledElement() == process;
            }
        };
    }

    private static ScaController newScaController(@NotNull InvocationHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.newScaController must not be null");
        }
        try {
            Constructor<?> constructor = SCAC_CONTROLLER_PROXY_CLASS.getConstructor(InvocationHandler.class);
            return (ScaController)constructor.newInstance(handler);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void handleUnexpectedError(Throwable t) {
        StringWriter sw = new StringWriter();
        StringBuffer buffer = sw.getBuffer();
        IndentedWriter iw = new IndentedWriter(sw);
        PrintWriter pw = new PrintWriter(iw);
        iw.indent();
        t.printStackTrace(pw);
        pw.flush();
        String exception = buffer.toString();
        buffer.setLength(0);
        for (MethodCall methodCall : this.interceptor.operations) {
            pw.println(methodCall);
        }
        pw.flush();
        String trace = buffer.toString();
        Log.logSevere(ProjectCatalogMsg.ERROR_UPDATING_COMPOSITE(this.processId, exception, trace));
    }

    private GarbageCollector setupGarbageCollector() {
        GarbageCollector gc = new GarbageCollector();
        gc.resetReferences(this.controller.getComponentReferences(this.processId));
        gc.resetServices(this.controller.getComponentServices(this.processId));
        gc.resetEventPublish(this.controller.getEventPublishes(this.processId));
        gc.resetEventSubscription(this.controller.getEventSubscriptions(this.processId));
        return gc;
    }

    private void removeReferences(Set<String> unusedReferences) {
        for (String unusedReference : unusedReferences) {
            this.controller.deleteReference(this.processId, unusedReference);
        }
    }

    private void removeServices(Set<String> unusedServices) {
        for (String unusedService : unusedServices) {
            this.controller.deleteService(this.processId, unusedService);
        }
    }

    private void removeEventPublishes(@NotNull Set<ScaEventInfo> unusedEvents) {
        if (unusedEvents == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.removeEventPublishes must not be null");
        }
        for (ScaEventInfo publish : unusedEvents) {
            this.controller.deleteEventPublish(this.processId, publish);
        }
    }

    private void removeEventSubscriptions(@NotNull Set<ScaEventInfo> unusedEvents) {
        if (unusedEvents == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.removeEventSubscriptions must not be null");
        }
        for (ScaEventInfo subscription : unusedEvents) {
            this.controller.deleteEventSubscription(this.processId, subscription);
        }
    }

    private void updateBpmnComponentProperties(boolean hasManualStart) {
        if (hasManualStart) {
            this.controller.addCompositeProperty(this.processId, new ScaPropertyInfo(BPEL_CONFIG_ONE_WAY_DELIVERY_POLICY, "sync"));
            this.controller.addCompositeProperty(this.processId, new ScaPropertyInfo(BPEL_CONFIG_TRANSACTION, "required"));
        } else {
            this.controller.deleteCompositeProperty(this.processId, BPEL_CONFIG_ONE_WAY_DELIVERY_POLICY);
            this.controller.deleteCompositeProperty(this.processId, BPEL_CONFIG_TRANSACTION);
        }
    }

    private boolean isBpelBased() {
        return !Str.isEmpty(this.getBpelPath());
    }

    private void processEvents(@NotNull GarbageCollector gc) {
        if (gc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processEvents must not be null");
        }
        block4: for (Event event : this.getAllInterestingEvents()) {
            switch (event.getEventTriggerType()) {
                case MESSAGE: {
                    String referenceId = this.processMessageEvent(event);
                    gc.markReference(referenceId);
                    continue block4;
                }
                case SIGNAL: {
                    this.processSignalEvent(event, gc);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("unexpected event type: " + event.getEventTriggerType()));
        }
    }

    private void processSignalEvent(@NotNull Event event, @NotNull GarbageCollector gc) {
        QName qName;
        SignalEventDefinition eventDefinition;
        SignalObject signal;
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processSignalEvent must not be null");
        }
        if (gc == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processSignalEvent must not be null");
        }
        EventDefinition definition = event.getEventDefinition();
        if (definition != null && (signal = (eventDefinition = definition.as(SignalEventDefinition.class)).getSignal()) != null && (qName = signal.getEventQName()) != null) {
            String eventName = qName.getLocalPart();
            String eventNamespace = qName.getNamespaceURI();
            VFile edlFile = signal.getEdlFile();
            String edlPath = VFileUtils.makeRelativePath((VFile)edlFile.getFileSystem().getRoot(), (VFile)edlFile);
            if (event.isThrowEvent()) {
                ScaEventInfo publish = ScaEventInfo.createEventInfo(eventNamespace, eventName).edlFile(edlPath);
                this.controller.addEventPublish(this.processId, publish);
                gc.markEventPublish(publish);
            } else if (event.isCatchEvent()) {
                ScaEventInfo subscription = ScaEventInfo.createEventInfo(eventNamespace, eventName).edlFile(edlPath);
                Expression expression = eventDefinition.getExpression();
                if (expression != null && expression.getLanguage() == ExpressionLanguage.XPATH) {
                    subscription = subscription.filter(expression.getExpressionValue(), expression.getNamespaces());
                }
                this.controller.addEventSubscription(this.processId, subscription);
                gc.markEventSubscription(subscription);
            } else assert (false) : "unknown event type: " + event;
        }
    }

    private boolean processActivities(@NotNull GarbageCollector gc) {
        if (gc == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processActivities must not be null");
        }
        boolean hasManualStart = false;
        for (Activity activity : this.getAllActivities()) {
            if (activity.isUserTask()) {
                UserTask userTask = activity.asActivity(UserTask.class);
                assert (userTask != null);
                hasManualStart |= userTask.isManualStart();
                gc.markReference(this.processUserTask(userTask));
                continue;
            }
            if (activity.isBusinessRuleTask()) {
                BusinessRuleTask businessRuleTask = activity.asActivity(BusinessRuleTask.class);
                assert (businessRuleTask != null);
                gc.markReference(this.processBusinessRuleTask(businessRuleTask));
                continue;
            }
            if (!activity.isServiceTask() && !activity.isSendTask() && !activity.isReceiveTask()) continue;
            if (this.isProcessCommunicationEnabled(activity)) {
                gc.markReference(this.processProcessCommunicationEnabled((ProcessCommunicationEnabled)((Object)activity)));
                continue;
            }
            gc.markReference(this.processParticipantEnabled((ParticipantEnabled)((Object)activity)));
        }
        return hasManualStart;
    }

    private boolean isProcessCommunicationEnabled(Activity activity) {
        return activity != null && activity.isProcessCommunicationMember() && ((ProcessCommunicationEnabled)((Object)activity)).getAssociatedProcess() != null;
    }

    private String processProcessCommunicationEnabled(@NotNull ProcessCommunicationEnabled activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processProcessCommunicationEnabled must not be null");
        }
        Process associatedProcess = activity.getAssociatedProcess();
        ConversationEnabled associatedNode = activity.getAssociatedNode();
        String referenceId = associatedProcess != null && associatedNode != null ? this.addProcessReference(associatedProcess, associatedNode) : null;
        return referenceId;
    }

    private void checkExposedServices(GarbageCollector gc) {
        Sequence<ProcessOperationWrapper> externalServices = this.getImplementedServices();
        for (ProcessOperationWrapper operationWrapper : externalServices) {
            assert (!operationWrapper.isServiceDefiner()) : "The operation '" + operationWrapper.getName() + "' is 'User Defined' but was selected as external";
            ParticipantReference participantReference = operationWrapper.getConversationEnabled().getParticipantRef();
            if (participantReference == null) continue;
            String serviceName = participantReference.getId();
            if (serviceName != null) {
                String exposedService = operationWrapper.getServiceObject().getTarget();
                this.updateService(this.makeProcessWsdlInfo(this.process, operationWrapper), serviceName, exposedService);
                gc.markService(serviceName);
                continue;
            }
            Log.logDebug("Cannot get service name for: " + operationWrapper);
        }
        Sequence<ProcessOperationWrapper> definedServices = this.getDefinedServices();
        if (definedServices.isEmpty()) {
            this.controller.deleteService(this.processId, this.processServiceName);
            this.controller.deleteServiceEntrypoint(this.processServiceName);
        } else {
            boolean hasCallBackPort = this.hasCallBackPort();
            String targetNamespace = this.process.getNamespace();
            QName portType = new QName(targetNamespace, this.processId + "PortType");
            String callBackPortTypeName = this.processId + "PortType" + "CallBack";
            QName replyPortType = hasCallBackPort ? new QName(targetNamespace, callBackPortTypeName) : null;
            String location = this.fixLocation(this.processId + ".wsdl");
            ScaWsdlInfo scaWsdlInfo = new ScaWsdlInfo(location, portType, replyPortType);
            this.updateService(scaWsdlInfo, this.processServiceName, this.processServiceName);
            gc.markService(this.processServiceName);
        }
    }

    private void updateService(@NotNull ScaWsdlInfo scaWsdlInfo, @NotNull String serviceName, @NotNull String exposedServiceName) {
        boolean addWire;
        if (scaWsdlInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.updateService must not be null");
        }
        if (serviceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.updateService must not be null");
        }
        if (exposedServiceName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.updateService must not be null");
        }
        if (this.controller.isNameUniqueWithinComponent(this.processId, serviceName)) {
            this.controller.addService(this.processId, serviceName, scaWsdlInfo);
        } else {
            ScaWsdlInfo current = this.controller.getWsdlInfoForName(this.processId, serviceName);
            assert (current != null);
            if (!current.equals(scaWsdlInfo)) {
                this.controller.updateService(this.processId, serviceName, serviceName, scaWsdlInfo);
            }
            this.controller.deleteServiceEntrypoint(serviceName);
        }
        if (Utils.isServiceInterfaceDefined(this.process) && this.processServiceName.equals(serviceName)) {
            this.controller.addComponentTypeProperty(this.processId, serviceName, new ScaPropertyInfo("bpm.generated.exposed.serviceName", exposedServiceName));
        }
        if (this.controller.isNameUniqueWithinComposite(exposedServiceName)) {
            this.controller.addServiceEntrypoint(exposedServiceName, scaWsdlInfo);
            addWire = true;
        } else if (this.controller.getServiceEntrypoints().contains(exposedServiceName)) {
            this.controller.updateServiceEntrypoint(exposedServiceName, exposedServiceName, scaWsdlInfo);
            addWire = true;
        } else {
            addWire = false;
        }
        if (addWire) {
            this.controller.addWire(exposedServiceName, null, this.processId, serviceName);
        }
    }

    private boolean isDefiner(@Nullable ConversationEnabled conversationNode) {
        return conversationNode != null && conversationNode.getParticipant() == null;
    }

    private boolean hasCallBackPort() {
        IdentityHashSet referencedInitiators = new IdentityHashSet();
        this.process.getChildrenByType(FlowNode.class).select(PredicateUtils.or(ModelUtils.ACTIVITY_FILTER, ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL).select(ModelUtils.CONTINUE_CONVERSATION_FILTER).map(FlowNodeFilter.NODE_CONVERSATION_ENABLED_MAPPER).select(PredicateUtils.notNull()).addAllTo(referencedInitiators);
        if (!referencedInitiators.isEmpty()) {
            Sequence<ProcessOperationWrapper> services = this.getDefinedServices();
            for (ProcessOperationWrapper initiatorEvent : services) {
                if (initiatorEvent.isSync() || !referencedInitiators.contains(initiatorEvent.getConversationEnabled())) continue;
                return true;
            }
        }
        return false;
    }

    private Sequence<ProcessOperationWrapper> getImplementedServices() {
        return this.getAllServices().select(PredicateUtils.not(FlowNodeFilter.SERVICE_DEFINER_FILTER));
    }

    private Sequence<ProcessOperationWrapper> getAllServices() {
        return this.process.getChildrenByType(FlowNode.class).select(PredicateUtils.or(ModelUtils.ACTIVITY_FILTER, ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL).select(ModelUtils.INITIATOR_CONVERSATION_FILTER).map(FlowNodeFilter.NODE_OPERATION_MAPPER).select(FlowNodeFilter.SERVICE_FILTER);
    }

    private Sequence<ProcessOperationWrapper> getDefinedServices() {
        return this.getAllServices().select(FlowNodeFilter.SERVICE_DEFINER_FILTER);
    }

    private void checkBpmnComponent() {
        if (this.controller.isNameUniqueWithinComposite(this.processId)) {
            if (this.isBpelBased()) {
                this.controller.createComponent(this.processId, "bpel", this.getBpelPath());
            } else {
                this.controller.createComponent(this.processId, "bpmn", this.getModelPath());
            }
        }
    }

    private ScaWsdlInfo makeProcessWsdlInfo(@NotNull Process processModel, @NotNull ProcessOperationWrapper processOperation) {
        String location;
        QName portType;
        if (processModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.makeProcessWsdlInfo must not be null");
        }
        if (processOperation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.makeProcessWsdlInfo must not be null");
        }
        QName replyPortType = null;
        if (processOperation.isServiceDefiner()) {
            String targetNamespace = processModel.getNamespace();
            portType = new QName(targetNamespace, processModel.getId() + "PortType");
            if (!processOperation.isSync()) {
                String localPart = processModel.getId() + "PortType" + "CallBack";
                replyPortType = new QName(targetNamespace, localPart);
            }
            location = this.fixLocation(processModel.getId() + ".wsdl");
        } else {
            ServiceObject serviceObject = processOperation.getServiceObject();
            portType = serviceObject.getServiceQName();
            replyPortType = serviceObject.getCallbackServiceQName();
            location = this.fixLocation(serviceObject.getServiceLocation());
        }
        return new ScaWsdlInfo(location, portType, replyPortType);
    }

    private Sequence<Event> getAllInterestingEvents() {
        return this.process.getChildrenByType(FlowNode.class).select(PredicateUtils.or(ModelUtils.ACTIVITY_FILTER, ModelUtils.EVENT_FILTER)).flatten(ModelUtils.SUB_PROCESS_TRAVERSAL).select(PredicateUtils.or(ModelUtils.MESSAGE_FILTER, ModelUtils.SIGNAL_FILTER)).selectInstanceOf(Event.class);
    }

    private Sequence<Activity> getAllActivities() {
        return ModelUtils.getAllActivities(this.process);
    }

    private String getModelPath() {
        String definitionPath;
        try {
            VFile processFile = this.process.getProject().getWriter().getFile(this.process);
            definitionPath = VFileUtils.makeRelativePath((VFile)processFile.getFileSystem().getRoot(), (VFile)processFile);
        }
        catch (ProjectException e) {
            assert (Log.logDebug(e));
            definitionPath = "processes/" + this.process.getId() + ".bpmn";
        }
        return definitionPath;
    }

    private String processBusinessRuleTask(@NotNull BusinessRuleTask businessRuleTask) {
        if (businessRuleTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processBusinessRuleTask must not be null");
        }
        String referenceId = null;
        BusinessRule businessRule = businessRuleTask.getBusinessRule();
        CatalogMember function = businessRuleTask.getFunction();
        if (businessRule != null && function != null) {
            MethodTypeDescription method;
            referenceId = businessRule.getText() + "." + function.getName() + ".reference";
            MethodTypeDescription methodTypeDescription = method = function.getDelegate() != null ? function.getDelegate().asMethod() : null;
            if (method != null) {
                String namespace = (String)method.getTransientProperty("namespace");
                String targetComponent = (String)method.getTransientProperty("target");
                String targetPort = (String)method.getTransientProperty("target.port");
                if (namespace != null && targetComponent != null && targetPort != null) {
                    if (this.controller.isNameUniqueWithinComponent(this.processId, referenceId)) {
                        QName portType = new QName(namespace, "IDecisionService");
                        String location = this.fixLocation(targetPort + ".wsdl");
                        ScaWsdlInfo info = new ScaWsdlInfo(location, portType, null);
                        this.controller.addReference(this.processId, referenceId, info);
                    }
                    this.addWire(this.processId, referenceId, targetComponent, targetPort);
                }
            }
        }
        return referenceId;
    }

    private void addWire(@NotNull String id, String referenceId, @NotNull String targetComponent, String targetPort) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addWire must not be null");
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addWire must not be null");
        }
        List<String> targets = this.controller.getComponentReferenceTarget(id, referenceId);
        if (targets.isEmpty()) {
            if (Log.isDebugging() && this.controller.isNameUniqueWithinComponent(targetComponent, targetPort)) {
                Log.logDebug("CompositeUpdater: Target not found adding wire: " + targetComponent + "/" + targetPort);
            } else {
                this.controller.addWire(id, referenceId, targetComponent, targetPort);
            }
        }
    }

    private String processUserTask(@NotNull UserTask userTask) {
        if (userTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processUserTask must not be null");
        }
        String referenceId = null;
        HumanTask humanTask = userTask.getHumanTask();
        if (humanTask != null) {
            String taskComponent;
            referenceId = humanTask.getText() + ".reference";
            if (this.controller.isNameUniqueWithinComponent(this.processId, referenceId)) {
                ScaWsdlInfo info = this.createTaskServiceWsdlInfo();
                this.controller.addReference(this.processId, referenceId, info);
            }
            if ((taskComponent = this.findHumanTaskComponent(humanTask)) != null) {
                List<String> taskServices = this.controller.getComponentServices(taskComponent);
                if (!taskServices.contains("TaskService")) {
                    ScaWsdlInfo info = this.createTaskServiceWsdlInfo();
                    this.controller.addService(taskComponent, "TaskService", info);
                }
                this.addWire(this.processId, referenceId, taskComponent, "TaskService");
            }
        }
        return referenceId;
    }

    private ScaWsdlInfo createTaskServiceWsdlInfo() {
        QName portType = new QName(TASK_SERVICE_NAMESPACE, "TaskService");
        QName replyPortType = new QName(TASK_SERVICE_NAMESPACE, TASK_SERVICE_CALLBACK_PORT);
        return new ScaWsdlInfo(TASK_SERVICE_WSDL, portType, replyPortType);
    }

    @Nullable
    private String findHumanTaskComponent(@NotNull HumanTask humanTask) {
        if (humanTask == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.findHumanTaskComponent must not be null");
        }
        Map<String, String> workflows = this.controller.getImplementationSources("workflow");
        String location = (String)humanTask.getDelegate().asObject().getTransientProperty("resource_location");
        String taskComponent = null;
        if (location != null) {
            LinkedList taskFile = VFileUtils.canonicalDecomposition((String)location);
            for (Map.Entry<String, String> entry : workflows.entrySet()) {
                LinkedList src = VFileUtils.canonicalDecomposition((String)entry.getValue());
                if (!src.equals(taskFile)) continue;
                taskComponent = entry.getKey();
                break;
            }
        }
        return taskComponent;
    }

    private String processMessageEvent(@NotNull Event event) {
        String referenceId;
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processMessageEvent must not be null");
        }
        if (event.isConversationMember()) {
            ProcessOperationWrapperImpl wrapper = new ProcessOperationWrapperImpl(event);
            if (wrapper.isReference() && wrapper.isInitiator()) {
                ConversationEnabled conversationEnabled = wrapper.getConversationEnabled();
                if (conversationEnabled.getParticipant() != null) {
                    referenceId = this.processParticipantEnabled(conversationEnabled);
                } else if (conversationEnabled.getAssociatedProcess() != null) {
                    Process associatedProcess = conversationEnabled.getAssociatedProcess();
                    ConversationEnabled associatedNode = conversationEnabled.getAssociatedNode();
                    referenceId = associatedNode != null && associatedProcess != null && !associatedProcess.isCallableSubprocess() ? this.addProcessReference(associatedProcess, associatedNode) : null;
                } else {
                    assert (Log.logDebug("Cannot get a ScaComponent for :  " + event.getName()));
                    referenceId = null;
                }
            } else {
                referenceId = null;
            }
        } else {
            referenceId = null;
        }
        return referenceId;
    }

    private String addProcessReference(@NotNull Process process, @NotNull ConversationEnabled node) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addProcessReference must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addProcessReference must not be null");
        }
        ProcessOperationWrapperImpl operationWrapper = new ProcessOperationWrapperImpl(node);
        ScaWsdlInfo info = this.makeProcessWsdlInfo(process, operationWrapper);
        String referenceId = process.getId() + ".reference";
        String serviceId = process.getId() + ".service";
        if (this.controller.isNameUniqueWithinComponent(this.processId, referenceId)) {
            this.controller.addReference(this.processId, referenceId, info);
        }
        this.addWire(this.processId, referenceId, process.getId(), serviceId);
        return referenceId;
    }

    private String processParticipantEnabled(@NotNull ParticipantEnabled activity) {
        String referenceId;
        if (activity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.processParticipantEnabled must not be null");
        }
        CatalogObject catalogObject = activity.getParticipant();
        if (catalogObject != null && catalogObject.isService()) {
            ObjectTypeDescription otd = catalogObject.getObjectType();
            ServiceObject serviceObject = otd.asServiceObject();
            referenceId = activity.getParticipantRef().getId();
            if (referenceId != null) {
                this.addServiceReference(referenceId, serviceObject);
            }
        } else {
            referenceId = null;
        }
        return referenceId;
    }

    private void addServiceReference(@NotNull String referenceId, @NotNull ServiceObject serviceObject) {
        if (referenceId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addServiceReference must not be null");
        }
        if (serviceObject == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater.addServiceReference must not be null");
        }
        String target = serviceObject.getTarget();
        String targetPort = serviceObject.getTargetPort();
        if (this.controller.isNameUniqueWithinComponent(this.processId, referenceId)) {
            String location = this.fixLocation(serviceObject.getServiceLocation());
            QName portType = serviceObject.getServiceQName();
            QName replyPortType = serviceObject.getCallbackServiceQName();
            ScaWsdlInfo info = new ScaWsdlInfo(location, portType, replyPortType);
            this.controller.addReference(this.processId, referenceId, info);
        }
        this.addWire(this.processId, referenceId, target, targetPort);
    }

    private String fixLocation(@Nullable String location) {
        if (location == null) {
            return null;
        }
        if (location.indexOf(58) > 1) {
            return location;
        }
        return VFileUtils.makeRelativePath((String)"/", (String)location);
    }

    private class GarbageCollector {
        private final Set<ScaEventInfo> unusedEventPublishes = new HashSet<ScaEventInfo>();
        private final Set<ScaEventInfo> unusedEventSubscriptions = new HashSet<ScaEventInfo>();
        private final Set<String> unusedReferences = new HashSet<String>();
        private final Set<String> unusedServices = new HashSet<String>();

        private GarbageCollector() {
        }

        public void markReference(String reference) {
            this.unusedReferences.remove(reference);
        }

        public void resetReferences(Collection<String> componentReferences) {
            this.unusedReferences.clear();
            this.unusedReferences.addAll(componentReferences);
        }

        public void markService(String service) {
            this.unusedServices.remove(service);
        }

        public void resetServices(Collection<String> componentServices) {
            this.unusedServices.clear();
            this.unusedServices.addAll(componentServices);
        }

        public void markEventPublish(ScaEventInfo reference) {
            this.unusedEventPublishes.remove(reference);
        }

        public void markEventSubscription(ScaEventInfo reference) {
            this.unusedEventSubscriptions.remove(reference);
        }

        public void resetEventPublish(Iterable<ScaEventInfo> publishes) {
            this.unusedEventPublishes.clear();
            for (ScaEventInfo publish : publishes) {
                this.unusedEventPublishes.add(publish);
            }
        }

        public void resetEventSubscription(Iterable<ScaEventInfo> subscriptions) {
            this.unusedEventSubscriptions.clear();
            for (ScaEventInfo subscription : subscriptions) {
                this.unusedEventSubscriptions.add(subscription);
            }
        }

        public void sweep() {
            CompositeUpdater.this.removeReferences(this.unusedReferences);
            CompositeUpdater.this.removeServices(this.unusedServices);
            CompositeUpdater.this.removeEventPublishes(this.unusedEventPublishes);
            CompositeUpdater.this.removeEventSubscriptions(this.unusedEventSubscriptions);
        }
    }

    private static final class MethodCall {
        public final Object[] arguments;
        public final Throwable exception;
        @NotNull
        public final Method method;
        public final Object result;

        private MethodCall(@NotNull Method method, Object[] arguments, Object result, Throwable exception) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater$MethodCall.<init> must not be null");
            }
            this.arguments = arguments;
            this.method = method;
            this.result = result;
            this.exception = exception;
            if (result != null && exception != null) {
                throw new IllegalArgumentException("Cannot have a result and an exception");
            }
        }

        public String toString() {
            return this.method.getName() + "(" + CollectionUtils.toSeparatedString(this.arguments == null ? CollectionUtils.emptyIterable() : Arrays.asList(this.arguments), ",") + ")" + (this.method.getReturnType() == Void.TYPE ? "" : " : " + this.result);
        }

        static MethodCall createResult(@NotNull Method method, Object[] arguments, Object result) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater$MethodCall.createResult must not be null");
            }
            return new MethodCall(method, arguments, result, null);
        }

        static MethodCall createException(@NotNull Method method, Object[] arguments, Throwable exception) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater$MethodCall.createException must not be null");
            }
            return new MethodCall(method, arguments, null, exception);
        }
    }

    private static class Interceptor
    implements InvocationHandler {
        public final List<MethodCall> operations;
        @NotNull
        private final Object delegate;

        Interceptor(@NotNull Object delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeUpdater$Interceptor.<init> must not be null");
            }
            this.operations = new ArrayList<MethodCall>();
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            try {
                result = method.invoke(this.delegate, args);
                this.operations.add(MethodCall.createResult(method, args, result));
            }
            catch (InvocationTargetException e) {
                this.operations.add(MethodCall.createException(method, args, e.getCause()));
                throw e.getCause();
            }
            return result;
        }
    }
}

