/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.CompositeObject;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.model.CompositeServiceType;
import org.jetbrains.annotations.NotNull;

public class CompositeComponent
implements CompositeObject {
    private CompositeServiceType compositeServiceType;
    private String name;
    private List<CompositeInterface> references;
    private List<CompositeInterface> services;
    private String srcLocation;
    private Map<String, ScaPropertyInfo> properties;

    public CompositeComponent(String name, CompositeServiceType compositeServiceType, String srcLocation, Map<String, ScaPropertyInfo> properties) {
        this.name = name;
        this.services = new ArrayList<CompositeInterface>();
        this.references = new ArrayList<CompositeInterface>();
        this.compositeServiceType = compositeServiceType;
        this.srcLocation = srcLocation;
        this.properties = properties;
    }

    public void addService(@NotNull CompositeInterface service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeComponent.addService must not be null");
        }
        this.services.add(service);
    }

    public void addReference(@NotNull CompositeInterface compositeInterface) {
        if (compositeInterface == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeComponent.addReference must not be null");
        }
        this.references.add(compositeInterface);
    }

    @Override
    public CompositeServiceType getComponentType() {
        return this.compositeServiceType;
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public Map<String, ScaPropertyInfo> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<CompositeInterface> getServices() {
        List<CompositeInterface> list = this.services;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeComponent.getServices must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<CompositeInterface> getReferences() {
        List<CompositeInterface> list = this.references;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeComponent.getReferences must not return null");
        }
        return list;
    }

    public String toString() {
        return this.name;
    }

    public String getSrcLocation() {
        return this.srcLocation;
    }
}

