/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.composite;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.composite.CatalogInterfaceType;
import oracle.bpm.project.catalog.composite.CompositeAccessorException;
import oracle.bpm.project.catalog.composite.CompositeInfo;
import oracle.bpm.project.catalog.composite.CompositeInterface;
import oracle.bpm.project.catalog.composite.ScaPropertyInfo;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.project.model.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositeAccessor {
    @NotNull
    private Project project;

    public CompositeAccessor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.<init> must not be null");
        }
        this.project = project;
    }

    @NotNull
    public abstract CompositeInfo parseComposite() throws CompositeAccessorException;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected final Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessor.getProject must not return null");
        }
        return project;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected VFileSystem getVFileSystemProject() {
        VFileSystem vFileSystem = this.project.getLoader().getProjectFileSystem().getDataFileSystem();
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/composite/CompositeAccessor.getVFileSystemProject must not return null");
        }
        return vFileSystem;
    }

    @Nullable
    protected CompositeInterface createInterface(@NotNull CompositeObjectContainer compositeObjectContainer, @NotNull String target, @Nullable String targetPort, @NotNull CatalogInterfaceType interfaceType, @Nullable Map<String, ScaPropertyInfo> properties) {
        if (compositeObjectContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/project/catalog/composite/CompositeAccessor.createInterface must not be null");
        }
        String name = compositeObjectContainer.getName();
        URL location = compositeObjectContainer.getWsdl();
        if (location == null) {
            assert (Log.logDebug("Warning: Location is null for composite '" + name + "'. Might be due to a sync problem"));
            return null;
        }
        QName servicePorttype = compositeObjectContainer.getInterfaceQName();
        QName callbackPorttype = compositeObjectContainer.getCallbankInterfaceQName();
        return new CompositeInterface(name, location, servicePorttype, callbackPorttype, target, targetPort, compositeObjectContainer.getInterfaceType(), interfaceType, properties);
    }

    protected final <S, T> Iterable<T> nonNullIterable(Collection<S> references, Function<S, T> mapper) {
        Iterable result = references != null ? CollectionUtils.asSequence(references).map(mapper).select(PredicateUtils.notNull()) : CollectionUtils.emptyIterable();
        return result;
    }

    protected static interface CompositeObjectContainer {
        public String getName();

        public QName getInterfaceQName();

        public QName getCallbankInterfaceQName();

        public URL getWsdl();

        @NotNull
        public CompositeServiceType getInterfaceType();
    }
}

