/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.NamespacedTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.ComponentBundleListener;
import oracle.bpm.type.catalog.MutableComponentBundle;
import org.jetbrains.annotations.NotNull;

public class SystemFaultsComponentBundle
implements ComponentBundle {
    private Map<String, TypeDescription> typesByName;
    private static final String BUSINESS_PROCESS_SCHEMA = "http://schemas.xmlsoap.org/ws/2003/03/business-process/";
    private static final String BPEL_EXTENSION_SCHEMA = "http://schemas.oracle.com/bpel/extension";

    public String getUniqueId() {
        return "soa.system.faults";
    }

    public String getDisplayName() {
        return "System Faults";
    }

    public List<String> loadTypeNames() throws TypeCatalogException {
        this.checkLoaded();
        return new ArrayList<String>(this.typesByName.keySet());
    }

    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        return this.typesByName.get(TypeUtils.buildFullName((String)typeName, (String)parentName));
    }

    public TypeInfo loadHeader(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        return new TypeInfo(this.loadType(typeName, parentName, catalog).asObject());
    }

    public long getLastModifiedTime(String typeName) {
        return 0L;
    }

    public boolean hasChangedFrom(long date) {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public void addBundleListener(ComponentBundleListener listener) {
    }

    public void removeBundleListener(ComponentBundleListener listener) {
    }

    public void reloadType(TypeRef ref) throws TypeCatalogException {
    }

    public boolean isMutable() {
        return false;
    }

    public MutableComponentBundle asMutable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("oracle.bpm.project.catalog.bundles.SystemFaultsComponentBundle.asMutable");
    }

    public File getBasePath() {
        return null;
    }

    public void dispose() {
    }

    private void checkLoaded() {
        if (this.typesByName == null) {
            this.typesByName = new HashMap<String, TypeDescription>();
            this.addBpelFault("bindingFault");
            this.addBpelFault("remoteFault");
            this.addBpelFault("invalidVariables");
            this.addBpelFault("rollback");
            this.addBpelFault("timeout");
            this.addBpelFault("assertFailure");
            this.addProcessFault("selectionFailure");
            this.addProcessFault("conflictingReceive");
            this.addProcessFault("conflictingRequest");
            this.addProcessFault("mismatchedAssignmentFailure");
            this.addProcessFault("forcedTermination");
            this.addProcessFault("correlationViolation");
            this.addProcessFault("uninitializedVariable");
            this.addProcessFault("repeatedCompensation");
            this.addProcessFault("invalidReply");
        }
    }

    private void addBpelFault(@NotNull String localPart) {
        if (localPart == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/SystemFaultsComponentBundle.addBpelFault must not be null");
        }
        NamespacedTypeDescription otd = this.createFaultType(BPEL_EXTENSION_SCHEMA, localPart);
        otd.setProperty("fault.message.qname", new QName(BPEL_EXTENSION_SCHEMA, "RuntimeFaultMessage").toString());
        this.addStringAttribute((ObjectTypeDescription)otd, "code");
        this.addStringAttribute((ObjectTypeDescription)otd, "summary");
        this.addStringAttribute((ObjectTypeDescription)otd, "detail");
        this.addType("Bpel", (ObjectTypeDescription)otd);
    }

    private void addType(String subModule, ObjectTypeDescription otd) {
        this.typesByName.put("SystemFaults." + subModule + "." + otd.getName(), (TypeDescription)otd);
    }

    private NamespacedTypeDescription createFaultType(String namespace, String localPart) {
        NamespacedTypeDescription otd = new NamespacedTypeDescription(localPart, namespace, null){};
        otd.setComponentType(ComponentType.SYSTEM_FAULTS.getText());
        otd.setId(new QName(namespace, localPart).toString());
        otd.addModifier(262144L);
        return otd;
    }

    private void addStringAttribute(ObjectTypeDescription otd, String name) {
        otd.addMember((MethodTypeDescription)new AttributeTypeDescription(name, (TypeRef)TypeFactory.getString()));
    }

    private void addAnyAttribute(ObjectTypeDescription otd, String name) {
        otd.addMember((MethodTypeDescription)new AttributeTypeDescription(name, (TypeRef)TypeFactory.getAny()));
    }

    private void addProcessFault(@NotNull String localPart) {
        if (localPart == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/SystemFaultsComponentBundle.addProcessFault must not be null");
        }
        NamespacedTypeDescription otd = this.createFaultType(BUSINESS_PROCESS_SCHEMA, localPart);
        this.addAnyAttribute((ObjectTypeDescription)otd, "errorInfo");
        this.addType("Soap", (ObjectTypeDescription)otd);
    }
}

