/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.catalog.bundles;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.ResourceService;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.catalog.bundles.ComponentBundleTypeIndex;
import oracle.bpm.project.catalog.config.ProjectCatalogConfig;
import oracle.bpm.project.catalog.config.TypeToLoad;
import oracle.bpm.project.catalog.loaders.ParsedObject;
import oracle.bpm.project.catalog.loaders.impl.XsdTypeLoader;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.IntrospectionRules;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeIndex;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.AbstractComponentBundle;
import org.jetbrains.annotations.NotNull;

public class CommonTypesComponentBundle
extends AbstractComponentBundle {
    private ComponentCatalog catalog;
    private VFileSystem fileSystem;
    private IntrospectionRules introspectionRules;
    private ComponentBundleTypeIndex typeIndex;
    private static final String COMMON_TYPES_RULES_FILE_PATH = "oracle/bpm/project/catalog/config/common-types.rules";
    private static final String BUNDLE_ID = "common.types";

    public CommonTypesComponentBundle(@NotNull ComponentCatalog catalog, @NotNull VFileSystem fileSystem) {
        if (catalog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/project/catalog/bundles/CommonTypesComponentBundle.<init> must not be null");
        }
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/project/catalog/bundles/CommonTypesComponentBundle.<init> must not be null");
        }
        this.catalog = catalog;
        this.fileSystem = fileSystem;
        this.setUniqueId(BUNDLE_ID);
    }

    public List<String> loadTypeNames() throws TypeCatalogException {
        return new ArrayList<String>(this.getTypesByName().keySet());
    }

    public TypeDescription loadType(String typeName, String parentName, ComponentCatalog catalog) throws TypeCatalogException {
        return this.getTypesByName().get(this.buildFullName(typeName, parentName));
    }

    public ComponentCatalog getCatalog() {
        return this.catalog;
    }

    public boolean hasChangedFrom(long date) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Map<String, TypeDescription> getTypesByName() {
        if (this.typeIndex == null) {
            this.typeIndex = new ComponentBundleTypeIndex(this.catalog);
            this.loadTypesByName();
        }
        Map<String, TypeDescription> map = this.typeIndex.getTypesByName();
        if (map == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/project/catalog/bundles/CommonTypesComponentBundle.getTypesByName must not return null");
        }
        return map;
    }

    private void loadTypesByName() {
        XsdTypeLoader loader = new XsdTypeLoader(this.catalog, this.fileSystem, (TypeIndex)this.typeIndex);
        Set<TypeToLoad> toLoadSet = ProjectCatalogConfig.getInstance().getTypesToLoad();
        for (TypeToLoad typeToLoad : toLoadSet) {
            String location = typeToLoad.getLocation();
            URI uri = URI.create(location);
            ParsedObject parsedObject = loader.parse(uri, null);
            Map<String, TypeDescription> parsedTypes = loader.buildTypes(parsedObject);
            if (parsedTypes.isEmpty()) continue;
            IntrospectionRules rules = this.getIntrospectionRules();
            for (Map.Entry<String, TypeDescription> entry : parsedTypes.entrySet()) {
                String qualifiedName = entry.getKey();
                TypeDescription type = rules.apply(qualifiedName, entry.getValue());
                if (type == null) continue;
                qualifiedName = TypeUtils.moduleName((String)qualifiedName, (String)qualifiedName) + "." + type.getName();
                this.typeIndex.indexTypeAdded(qualifiedName, type);
            }
        }
    }

    private IntrospectionRules getIntrospectionRules() {
        InputStreamReader stream = null;
        if (this.introspectionRules == null) {
            try {
                ResourceService resources = Platform.getResourceService();
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                URL rules = resources.resolveResource(COMMON_TYPES_RULES_FILE_PATH, loader);
                stream = new InputStreamReader(rules.openStream(), "ASCII");
                this.introspectionRules = IntrospectionRules.parse((Reader)stream);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("common-types.rules not found");
                }
                catch (Throwable throwable) {
                    StreamUtils.close(stream);
                    throw throwable;
                }
            }
            StreamUtils.close(stream);
        }
        return this.introspectionRules;
    }

    private String buildFullName(String typeName, String parentName) {
        String objectTypeName = !Str.isEmpty(parentName) ? parentName + "." + TypeUtils.shortName((String)typeName) : typeName;
        return objectTypeName;
    }
}

