/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util.dump;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.bpm.log.Log;
import oracle.bpm.util.dump.Dumper;

class UnixDumper
extends Dumper {
    UnixDumper() {
    }

    @Override
    public boolean doThreadDump() {
        if (!this.appropriateIntervalBetweenDumps()) {
            return false;
        }
        if (System.getProperty("java.vendor").startsWith("IBM")) {
            this.raiseSignal();
        } else {
            this.performKillCommand();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performKillCommand() {
        block8: {
            try {
                Process p = Runtime.getRuntime().exec(" pid.sh ");
                p.waitFor();
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = is.readLine();
                if (line == null) break block8;
                int eol = line.indexOf("\n");
                if (eol > 0) {
                    line = line.substring(0, eol);
                }
                line = line.trim();
                int pid = Integer.parseInt(line);
                p = Runtime.getRuntime().exec(" kill -3 " + pid);
                p.waitFor();
                UnixDumper unixDumper = this;
                synchronized (unixDumper) {
                    this.wait(5000L);
                }
            }
            catch (IOException e) {
                Log.logWarning(e);
            }
            catch (InterruptedException e) {
                Log.logWarning(e);
            }
            catch (RuntimeException e) {
                Log.logWarning(e);
            }
        }
    }

    private void raiseSignal() {
        try {
            Class<?> c = Class.forName("sun.misc.Signal");
            Method m = c.getDeclaredMethod("raise0", Integer.TYPE);
            m.setAccessible(true);
            m.invoke(null, 3);
        }
        catch (ClassNotFoundException e) {
            Log.logWarning(e);
        }
        catch (NoSuchMethodException e) {
            Log.logWarning(e);
        }
        catch (SecurityException e) {
            Log.logWarning(e);
        }
        catch (IllegalAccessException e) {
            Log.logWarning(e);
        }
        catch (IllegalArgumentException e) {
            Log.logWarning(e);
        }
        catch (InvocationTargetException e) {
            Log.logWarning(e);
        }
    }
}

