/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util.dump;

import oracle.bpm.util.dump.UnixDumper;
import oracle.bpm.util.dump.WindowsDumper;

public abstract class Dumper {
    private boolean ignoreDumpInterval;
    private static long lastDump_d = -1L;
    public static final long TIME_THRESHOLD = 300000L;
    public static final String DUMP_FAILURE = "DUMP CANNOT BE PERFORMED YET";
    public static final String DUMP_OK = "DUMP DONE";

    public abstract boolean doThreadDump();

    public static Dumper create() {
        String os = System.getProperty("os.name");
        if (os.toUpperCase().startsWith("WINDOWS")) {
            return new WindowsDumper();
        }
        return new UnixDumper();
    }

    public void setIgnoreDumpInterval(boolean ignoreDumpInterval) {
        this.ignoreDumpInterval = ignoreDumpInterval;
    }

    protected boolean appropriateIntervalBetweenDumps() {
        if (this.ignoreDumpInterval) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastDump_d < 300000L) {
            return false;
        }
        lastDump_d = currentTime;
        return true;
    }
}

