/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.log.Log;
import oracle.bpm.util.StringTokenizer;

public class ResourceUtils {
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding", "ASCII");

    public static File getBaseDirFromClass(Class cl) {
        File classDir = ResourceUtils.getDirFromClass(cl);
        String name = cl.getName();
        int i = name.lastIndexOf(46);
        StringTokenizer st = new StringTokenizer(name.substring(0, i), ".");
        while (st.hasMoreTokens()) {
            st.nextToken();
            classDir = classDir.getParentFile();
        }
        return classDir;
    }

    public static String[] getClassNamesFromJar(URL jar) throws IOException {
        ArrayList<String> names;
        block3: {
            names = new ArrayList<String>();
            try {
                ZipFile jarFile = new ZipFile(new File(jar.getFile()));
                for (ZipEntry zipEntry : CollectionUtils.each(jarFile.entries())) {
                    String name;
                    if (zipEntry.isDirectory() || !(name = zipEntry.getName()).endsWith(".class")) continue;
                    name = name.substring(0, name.length() - 6);
                    name = name.replace('/', '.');
                    name = name.replace('\\', '.');
                    names.add(name);
                }
            }
            catch (IOException e) {
                if (!Log.isDebugging()) break block3;
                Log.logDebug(e.toString());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public static URL getClassURL(Class c) {
        return c.getResource(c.getName().substring(1 + c.getName().lastIndexOf(".")) + ".class");
    }

    public static File getDirFromClass(Class cl) {
        URL classURL = ResourceUtils.getClassURL(cl);
        String path = classURL.getPath();
        File pathFile = new File(path);
        return pathFile.getParentFile();
    }

    public static String[] getListFromClass(Class cl, final String ext) {
        return ResourceUtils.getDirFromClass(cl).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ext);
            }
        });
    }

    public static Reader getReaderFromClass(Class cl, String file) throws IOException {
        return new InputStreamReader(cl.getResourceAsStream(file));
    }

    public static void main(String[] args) {
        String[] fields;
        for (String field : fields = ResourceUtils.getListFromClass(ResourceUtils.class, ".class")) {
            System.out.println(field);
        }
    }

    public static File getBaseDir(Class clazz) {
        try {
            String className = clazz.getName();
            String classFileName = className.substring(className.lastIndexOf(46) + 1) + ".class";
            URL url = clazz.getResource(classFileName);
            String tmp = URLDecoder.decode(url.toString(), DEFAULT_ENCODING);
            if (tmp.startsWith("jar:") || tmp.startsWith("zip:")) {
                tmp = tmp.substring(4, tmp.lastIndexOf("!/"));
            } else if (tmp.startsWith("wsjar:")) {
                tmp = tmp.substring(6, tmp.lastIndexOf("!/"));
            }
            if (tmp.startsWith("file:")) {
                int strip = 5;
                if (tmp.indexOf(58, strip) != -1) {
                    boolean slash;
                    boolean bl = slash = tmp.charAt(strip) == '/';
                    if (slash) {
                        ++strip;
                    }
                }
                tmp = tmp.substring(strip).replace('/', File.separatorChar);
            }
            return new File(tmp).getParentFile().getCanonicalFile();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

