/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.collections.comparators.LocaleComparator;
import oracle.bpm.lang.Platform;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.Properties;

public final class Locales {
    private static List<Locale> supportedLanguages;
    public static final Locale BASE_LOCALE;

    private Locales() {
    }

    public static boolean isAsian(Locale locale) {
        boolean result = false;
        String language = locale.getLanguage();
        if (language.equals(Locale.CHINESE.getLanguage())) {
            result = true;
        } else if (language.equals(Locale.JAPANESE.getLanguage())) {
            result = true;
        } else if (language.equals(Locale.KOREAN.getLanguage())) {
            result = true;
        }
        return result;
    }

    public static Locale valueOf(String locale) {
        String[] tokens = locale != null ? locale.split("_") : new String[]{};
        String language = Locale.getDefault().getLanguage();
        String country = "";
        String variant = "";
        int length = tokens.length;
        if (length > 0) {
            language = tokens[0];
            if (length > 1) {
                country = tokens[1];
                if (length > 2) {
                    variant = tokens[2];
                }
            }
        }
        return new Locale(language, country, variant);
    }

    @Deprecated
    public static Collection<Locale> getSupportedLanguages() {
        if (supportedLanguages == null) {
            supportedLanguages = new ArrayList<Locale>();
            for (LocaleSupport l : Locales.getSupportedLocales()) {
                supportedLanguages.add(l.asJavaLocale());
            }
        }
        return supportedLanguages;
    }

    public static List<LocaleSupport> getSupportedLocales() {
        return Platform.getLocaleService().getSupportedLocales();
    }

    public static List<LocaleSupport> getSupportedIdeLocales() {
        return Platform.getLocaleService().getSupportedIdeLocales();
    }

    public static Locale getSystemDefault() {
        Properties properties = FuegoDirectories.userProperties();
        if (properties == null) {
            return Locale.getDefault();
        }
        String language = properties.getProperty("user.language");
        if (language == null) {
            return Locale.getDefault();
        }
        String country = properties.getProperty("user.country", "");
        String variant = properties.getProperty("user.variant", "");
        return new Locale(language, country, variant);
    }

    public static Collection<Locale> listLocalesForLanguage(String language) {
        return LanguageData.getLocalesByLanguage(language);
    }

    public static String getSampleText(Locale locale) {
        String result = Locale.JAPANESE.equals(locale) ? "\u6c17\u5ea6\u3092\u6620\u30e9\u30f3\u30ad\u30f3\u30b0\u3092\u884c\u30b5\u30fc\u30a8\u30f3\u30b8\u30f3\u65e5\u672c\u8a9e\u7248" : (Locale.KOREAN.equals(locale) ? "\uc6f9\ubb38\uc11c,\ubbf8\uc9c0,\ub274\uc2a4\uadf8\ub8f9,\ub514\ub809\ud1a0\ub9ac\uac80\uc0c9,\ud55c" : (Locale.TRADITIONAL_CHINESE.equals(locale) ? "\u7167\u7db2\u7ad9\u7684\u69cb\u7279\u8272\u4f86\u5efa\u7acb\u67b6\u69cb\uff0c\u7db2\u6392" : (Locale.CHINESE.equals(locale) ? "\u4f9b\u7f51\u9875\u56fe\u7247\u65b0\u95fb\u7b49\u7d22\uff0c\u8fd8\u6709\u8bba\u5206\u7c7b\u76ee\u5f55\u548c\u7ffb" : "Latin")));
        return result;
    }

    public static void setDefaultLocale(Locale locale) {
        CommonPreferences cp = CommonPreferences.getInstance();
        cp.setLanguage(locale.getLanguage());
        cp.setCountry(locale.getCountry());
        cp.setVariant(locale.getVariant());
        cp.store();
        Platform.getLocaleService().changeDefaultLocale(locale);
    }

    public static Locale getDefaultLocale() {
        Locale result;
        CommonPreferences cp = CommonPreferences.getInstance();
        String language = cp.getLanguage();
        if (language.length() != 0) {
            result = new Locale(language, cp.getCountry(), cp.getVariant());
        } else {
            result = Locales.getSystemDefault();
            if (Platform.getLocaleService().getSupportForLocale(result) == null) {
                result = BASE_LOCALE;
            }
            cp.setDefaultLocale(result);
        }
        return result;
    }

    static {
        BASE_LOCALE = Locale.ENGLISH;
    }

    private static class LanguageData {
        private static final Map<String, SortedSet<Locale>> localesByLanguage = new HashMap<String, SortedSet<Locale>>();

        private LanguageData() {
        }

        static void addSupportedLocale(Locale locale) {
            String language = locale.getLanguage();
            SortedSet<Locale> locales = localesByLanguage.get(language);
            if (locales == null) {
                locales = new TreeSet<Locale>(LocaleComparator.INSTANCE);
            }
            locales.add(locale);
            localesByLanguage.put(language, locales);
        }

        static Collection<Locale> getLocalesByLanguage(String language) {
            Collection list = localesByLanguage.get(language);
            return list == null ? Collections.emptyList() : list;
        }

        static {
            LanguageData.addSupportedLocale(Locale.ENGLISH);
            for (Locale locale : Locale.getAvailableLocales()) {
                LanguageData.addSupportedLocale(locale);
            }
        }
    }
}

