/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Identifier {
    @NonNls
    private static final String[] cilReservedList = new String[]{"arg", "rem", "not", "and", "or", "is", "in", "null", "true", "false", "this", "super", "do", "end", "if", "display", "input", "then", "else", "elseif", "for", "each", "where", "while", "on", "exit", "when", "using", "return", "returning", "ordered", "use", "relay", "switch", "case"};
    @NonNls
    private static final String[] javaReservedList = new String[]{"abstract", "default", "if", "private", "throw", "boolean", "do", "implements", "protected", "throws", "break", "double", "import", "public", "transient", "byte", "else", "instanceof", "this", "super", "return", "try", "case", "extends", "int", "short", "void", "catch", "final", "interface", "static", "volatile", "char", "finally", "long", "while", "class", "float", "native", "switch", "const", "for", "new", "synchronized", "continue", "goto", "package"};

    public static boolean isValid(String id) {
        int length;
        int n = length = id != null ? id.length() : 0;
        if (length == 0 || !Identifier.isValidStart(id.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            int ch = id.codePointAt(i);
            if (Identifier.isValidPart(ch)) continue;
            return false;
        }
        return !Identifier.belongsToCIL(id);
    }

    public static boolean isValidMethodName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/util/Identifier.isValidMethodName must not be null");
        }
        char[] chars = name.toCharArray();
        if (chars.length > 0 && Character.isJavaIdentifierStart(chars[0])) {
            for (int i = 1; i < chars.length; ++i) {
                char c = chars[i];
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidClassName(@Nullable String id) {
        if (id == null || id.length() == 0 || !Character.isUpperCase(id.charAt(0)) || !Identifier.isValidStart(id.charAt(0))) {
            return false;
        }
        int length = id.length();
        for (int i = 1; i < length; ++i) {
            if (Identifier.isValidPart(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPart(int ch) {
        return Character.isJavaIdentifierPart(ch) && ch != 36;
    }

    public static boolean isValidStart(int ch) {
        return Character.isJavaIdentifierStart(ch) && ch != 36;
    }

    public static boolean isLetterOrNumber(char ch) {
        return !Character.isLetterOrDigit(ch) && Character.getType(ch) != 10;
    }

    public static String argument(String id) {
        return Identifier.validLowerCase(id);
    }

    public static String attribute(String id) {
        return Identifier.validLowerCase(id);
    }

    public static String attribute(String id, boolean allowUnderscore) {
        return Identifier.validLowerCase(id, allowUnderscore);
    }

    public static boolean belongsToCIL(String id) {
        return id != null && Arrays.binarySearch(cilReservedList, id) >= 0;
    }

    public static boolean belongsToJava(String id) {
        return id != null && Arrays.binarySearch(javaReservedList, id) >= 0;
    }

    public static String capitalize(String id) {
        char ch;
        if (id != null && id.length() > 0 && Character.isLowerCase(ch = id.charAt(0))) {
            id = String.valueOf(Character.toUpperCase(ch)).concat(id.substring(1));
        }
        return id;
    }

    public static String classname(String id) {
        return Identifier.classname(id, true);
    }

    public static String classname(String id, boolean allowUnderscore) {
        return Identifier.capitalize(Identifier.valid(id, allowUnderscore));
    }

    public static String classnameFromUrl(String urlText) {
        String classname = null;
        try {
            URL url = new URL(urlText);
            String file = url.getFile();
            if (file != null) {
                int dot;
                int index = file.lastIndexOf(47);
                if (index != -1) {
                    file = file.substring(index + 1);
                }
                if ((dot = file.lastIndexOf(46)) != -1) {
                    file = file.substring(0, dot);
                }
                classname = Identifier.classname(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return classname;
    }

    public static String constant(String id) {
        return id != null ? Identifier.valid(id, true) : null;
    }

    public static String idFromConstantId(String id, boolean capitalize) {
        String result = Identifier.valid(id, true);
        return capitalize ? Identifier.capitalize(result) : result;
    }

    public static String method(String id) {
        return Identifier.validLowerCase(id);
    }

    public static String method(String id, boolean allowsUnderscore) {
        return Identifier.validLowerCase(id, allowsUnderscore);
    }

    public static String uncapitalize(String id) {
        if (id != null) {
            int upperCase = 0;
            for (int i = 0; i < id.length() && !Character.isLowerCase(id.charAt(i)); ++i) {
                ++upperCase;
            }
            if (upperCase > 0) {
                if (upperCase != 1 && upperCase != id.length()) {
                    --upperCase;
                }
                id = id.substring(0, upperCase).toLowerCase().concat(id.substring(upperCase));
            }
        }
        return id;
    }

    public static String valid(String id) {
        return Identifier.valid(id, false);
    }

    public static String valid(String id, boolean allowUnderscore) {
        if (id != null) {
            id = Identifier.validChars(id, allowUnderscore);
            while (id.length() > 0 && !Identifier.isValidStart(id.charAt(0))) {
                id = id.substring(1);
            }
        }
        return id;
    }

    public static String validChars(String id) {
        return Identifier.validChars(id, false);
    }

    public static String validChars(String id, boolean allowUnderscore) {
        if (id != null) {
            int length = id.length();
            for (int i = 0; i < length; ++i) {
                char ch = id.charAt(i);
                if (Identifier.isValidPart(ch) && (allowUnderscore || ch != '_')) continue;
                String left = id.substring(0, i);
                String right = id.substring(i + 1, length);
                id = left.concat(Identifier.capitalize(right));
                --length;
                --i;
            }
        }
        return id;
    }

    public static String validLowerCase(String id) {
        id = Identifier.uncapitalize(Identifier.valid(id));
        return id;
    }

    private static String validLowerCase(String id, boolean allowsUnderscore) {
        id = Identifier.uncapitalize(Identifier.valid(id, allowsUnderscore));
        return id;
    }

    static {
        Arrays.sort(cilReservedList);
        Arrays.sort(javaReservedList);
    }
}

