/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import oracle.bpm.lang.Platform;
import oracle.bpm.util.Properties;
import oracle.bpm.util.ResourceUtils;
import org.jetbrains.annotations.NonNls;

public class FuegoDirectories {
    @NonNls
    private static final String EXT_DIR = "ext";
    @NonNls
    private static final String CONF_DIR = "conf";
    @NonNls
    private static final String BIN_DIR = "bin";
    @NonNls
    private static final String LIB_DIR = "lib";
    @NonNls
    private static final String WEBAPPS_DIR = "webapps";
    private static Properties userProperties;
    private static File home;
    private static String installation;
    private static String webAppsInstallation;
    private static File temp;
    private static File userHome;

    public static File home() {
        if (home == null) {
            String engineHome = System.getProperty("engine.home");
            File homeDir = engineHome != null ? new File(engineHome, ".fuego") : new File(FuegoDirectories.userHome(), ".fuego");
            if (!homeDir.exists()) {
                homeDir.mkdirs();
            }
            home = homeDir;
        }
        return home.getAbsoluteFile();
    }

    public static File homeRelativeFile(String fileName) {
        return new File(FuegoDirectories.home(), fileName);
    }

    public static String webAppsInstallation() {
        if (webAppsInstallation == null) {
            webAppsInstallation = FuegoDirectories.installation() + File.separator + WEBAPPS_DIR + File.separator;
        }
        return webAppsInstallation;
    }

    public static String installation() {
        if (installation == null) {
            installation = FuegoDirectories.installationDir().getPath();
        }
        return installation;
    }

    public static File installationDir() {
        File result;
        URL platformDir = Platform.getResourceService().getPlatformInstallation();
        if (platformDir != null && "file".equals(platformDir.getProtocol())) {
            result = new File(platformDir.getPath());
        } else {
            try {
                result = new File(ResourceUtils.getBaseDir(FuegoDirectories.class).getCanonicalFile(), "..").getCanonicalFile();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        assert (result.exists()) : "Installation dir does not exists: " + result;
        return result;
    }

    public static File installationRelativeFile(String fileName) {
        return new File(FuegoDirectories.installationDir(), fileName);
    }

    public static String temp() {
        if (temp == null) {
            File tmpDir = new File(FuegoDirectories.home(), "tmp");
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            temp = tmpDir;
        }
        return temp.getAbsolutePath();
    }

    public static File tempRelativeFile(String fileName) {
        return new File(FuegoDirectories.temp(), fileName);
    }

    public static File userHome() {
        if (userHome == null && !(userHome = new File(System.getProperty("user.home"))).exists()) {
            userHome.mkdirs();
        }
        return userHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties userProperties() {
        if (userProperties != null) {
            userProperties = new Properties();
            try {
                FileInputStream in = new FileInputStream(FuegoDirectories.homeRelativeFile(".properties"));
                try {
                    userProperties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userProperties;
    }

    public static File configDir() {
        return FuegoDirectories.installationRelativeFile(CONF_DIR);
    }

    public static File binDir() {
        return FuegoDirectories.installationRelativeFile(BIN_DIR);
    }

    public static File libDir() {
        return FuegoDirectories.installationRelativeFile(LIB_DIR);
    }

    public static File extDir() {
        return FuegoDirectories.installationRelativeFile(EXT_DIR);
    }

    static {
        installation = null;
        webAppsInstallation = null;
    }
}

