/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.util.NumberFormat;
import org.jetbrains.annotations.NonNls;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private Currency currency;
    private String currencySymbol;
    private char decimalSeparator;
    private char digit;
    private char exponential;
    private String exponentSeparator;
    private char groupingSeparator;
    private String infinity;
    @NonNls
    private String intlCurrencySymbol;
    private Locale locale;
    private char minusSign;
    private char monetarySeparator;
    private String NaN;
    private char padEscape;
    private char patternSeparator;
    private char percent;
    private char perMill;
    private char plusSign;
    private int serialVersionOnStream = 3;
    private char zeroDigit;
    @NonNls
    private static final String NUMBER_ELEMENTS = "NumberElements";
    static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 3;
    private static final Map<Locale, Object[]> cachedLocaleData = new HashMap<Locale, Object[]>();
    static final long serialCheck = -7992522870924181638L;

    public DecimalFormatSymbols() {
        this.initialize(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale) {
        this.initialize(locale);
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            throw new NullPointerException();
        }
        this.currency = currency;
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDigit(char digit) {
        this.digit = digit;
    }

    public char getDigit() {
        return this.digit;
    }

    public void setExponentSeparator(String exp) {
        this.exponentSeparator = exp;
    }

    public String getExponentSeparator() {
        return this.exponentSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setInfinity(String infinity) {
        this.infinity = infinity;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInternationalCurrencySymbol(String currency) {
        this.intlCurrencySymbol = currency;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public void setMonetaryDecimalSeparator(char sep) {
        this.monetarySeparator = sep;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public void setNaN(String NaN) {
        this.NaN = NaN;
    }

    public String getNaN() {
        return this.NaN;
    }

    public void setPadEscape(char c) {
        this.padEscape = c;
    }

    public char getPadEscape() {
        return this.padEscape;
    }

    public void setPatternSeparator(char patternSeparator) {
        this.patternSeparator = patternSeparator;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public void setPerMill(char perMill) {
        this.perMill = perMill;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public void setPercent(char percent) {
        this.percent = percent;
    }

    public char getPercent() {
        return this.percent;
    }

    public void setPlusSign(char plus) {
        this.plusSign = plus;
    }

    public char getPlusSign() {
        return this.plusSign;
    }

    public void setZeroDigit(char zeroDigit) {
        this.zeroDigit = zeroDigit;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DecimalFormatSymbols that = (DecimalFormatSymbols)obj;
        return this.zeroDigit == that.zeroDigit && this.groupingSeparator == that.groupingSeparator && this.decimalSeparator == that.decimalSeparator && this.percent == that.percent && this.perMill == that.perMill && this.digit == that.digit && this.minusSign == that.minusSign && this.patternSeparator == that.patternSeparator && this.infinity.equals(that.infinity) && this.NaN.equals(that.NaN) && this.currencySymbol.equals(that.currencySymbol) && this.intlCurrencySymbol.equals(that.intlCurrencySymbol) && this.padEscape == that.padEscape && this.plusSign == that.plusSign && this.exponentSeparator.equals(that.exponentSeparator) && this.monetarySeparator == that.monetarySeparator;
    }

    public int hashCode() {
        return (this.zeroDigit * 37 + this.groupingSeparator) * 37 + this.decimalSeparator;
    }

    private void initialize(Locale locale) {
        this.locale = locale;
        boolean needCacheUpdate = false;
        Object[] data = cachedLocaleData.get(locale);
        if (data == null) {
            data = new Object[]{NumberFormat.getNumberFormatData(locale).getStringArray(NUMBER_ELEMENTS), null, null};
            needCacheUpdate = true;
        }
        String[] ne = (String[])data[0];
        this.decimalSeparator = this.getChar0(ne, 0);
        this.groupingSeparator = this.getChar0(ne, 1);
        this.patternSeparator = this.getChar0(ne, 2);
        this.percent = this.getChar0(ne, 3);
        this.zeroDigit = this.getChar0(ne, 4);
        this.digit = this.getChar0(ne, 5);
        this.minusSign = this.getChar0(ne, 6);
        this.exponentSeparator = ne[7];
        this.exponential = this.getChar0(ne, 7);
        this.perMill = this.getChar0(ne, 8);
        this.infinity = ne[9];
        this.NaN = ne[10];
        this.plusSign = (char)43;
        this.padEscape = (char)42;
        if (this.currency != null) {
            needCacheUpdate = this.initCurrency(data, locale, needCacheUpdate);
        } else {
            this.intlCurrencySymbol = "XXX";
            try {
                this.currency = Currency.getInstance(this.intlCurrencySymbol);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.currencySymbol = "\u00a4";
        }
        this.monetarySeparator = this.decimalSeparator;
        if (needCacheUpdate) {
            cachedLocaleData.put(locale, data);
        }
    }

    private boolean initCurrency(Object[] data, Locale locale, boolean needCacheUpdate) {
        this.intlCurrencySymbol = this.currency.getCurrencyCode();
        if (data[1] != null && data[1] == this.intlCurrencySymbol) {
            this.currencySymbol = (String)data[2];
        } else {
            this.currencySymbol = this.currency.getSymbol(locale);
            data[1] = this.intlCurrencySymbol;
            data[2] = this.currencySymbol;
            needCacheUpdate = true;
        }
        return needCacheUpdate;
    }

    private char getChar0(String[] ne, int n) {
        return ne[n].charAt(0);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.padEscape = (char)42;
            this.plusSign = (char)43;
            this.exponentSeparator = String.valueOf(this.exponential);
        }
        if (this.serialVersionOnStream < 3) {
            this.locale = Locale.getDefault();
        }
        this.serialVersionOnStream = 3;
    }
}

