/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.FuegoDirectories;
import oracle.bpm.util.StringTokenizer;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NonNls;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CommonPreferences
implements Serializable {
    private boolean automaticallyCheckForUpdates;
    private boolean confirmSQLExecution_d = false;
    private String country_d = "";
    private File currentFile;
    private int currentTip;
    private String defaultBrowser;
    private Integer defaultDetail_d = 1;
    private int defaultLogCount_d = 1000;
    @NonNls
    private String defaultSeverity_d = "fatal,severe,warning";
    private boolean doNotDelayCompilation_d = false;
    private boolean exportPublicationXML_d = false;
    private String httpProxyHost = "";
    private String httpProxyPort = "";
    private String language_d = "";
    private String lastExportedType = "";
    private String lastFile_d;
    private String lastJCLUsedDir = "";
    private StringList lastOpenedFiles_d = null;
    private String lastOpenedProject_d;
    private StringList lastOpenedProjects_d = StringList.create();
    private String lastUsedDir = "";
    private String lastUsedExportPath;
    private StringList lastUsedFiles_d = StringList.create();
    private String lastUsedImportProjectFile;
    private File preferencesFile;
    private String servicePackServerUrl;
    private boolean showCheckForUpdates = true;
    private boolean showTipsOnStartUp;
    private String theme_d = "";
    private boolean useProxyConfiguration = false;
    private String variant_d = "";
    @NonNls
    private static final String DEFAULT_FILE_NAME = "commonPreferences";
    public static final int WPDL = 0;
    public static final int SERIAL = 1;
    static final long serialVersionUID = 3L;
    private static CommonPreferences commonPreferences_sd;
    static final long serialCheck = -8959327955362115092L;
    public static final String PROXY_HOST_SYSTEM_PROPERTY = "http.proxyHost";
    public static final String PROXY_PORT_SYSTEM_PROPERTY = "http.proxyPort";

    public CommonPreferences() {
        this.lastOpenedFiles_d = StringList.create();
        this.currentFile = FuegoDirectories.userHome();
        this.servicePackServerUrl = CoreMsg.SP_DOWNLOAD_URL.getString();
    }

    public static CommonPreferences getInstance() {
        if (commonPreferences_sd != null) {
            return commonPreferences_sd;
        }
        return CommonPreferences.load();
    }

    public static boolean isLoaded() {
        return commonPreferences_sd != null;
    }

    public static CommonPreferences load() {
        return CommonPreferences.load(DEFAULT_FILE_NAME);
    }

    public static CommonPreferences load(String preferencesFileName) {
        commonPreferences_sd = new CommonPreferences();
        File preferencesFile = FuegoDirectories.homeRelativeFile(preferencesFileName);
        commonPreferences_sd.setPreferencesFile(preferencesFile);
        try {
            new CommonPreferencesLoader(preferencesFile, commonPreferences_sd);
            CommonPreferences.setJVMPreferences();
        }
        catch (Exception e) {
            return new CommonPreferences();
        }
        return commonPreferences_sd;
    }

    public boolean getUseProxyConfiguration() {
        return this.useProxyConfiguration;
    }

    public void setUseProxyConfiguration(boolean useProxyConfiguration) {
        this.useProxyConfiguration = useProxyConfiguration;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setAutomaticallyCheckForUpdates(boolean val) {
        this.automaticallyCheckForUpdates = val;
    }

    public boolean getAutomaticallyCheckForUpdates() {
        return this.automaticallyCheckForUpdates;
    }

    public void setConfirmSQLExecution(boolean confirmSQLExecution) {
        this.confirmSQLExecution_d = confirmSQLExecution;
    }

    public boolean getConfirmSQLExecution() {
        return this.confirmSQLExecution_d;
    }

    public void setCurrentFile(File s) {
        this.currentFile = s;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setDefaultLocale(Locale locale) {
        this.setLanguage(locale.getLanguage());
        this.setCountry(locale.getCountry());
        this.setVariant(locale.getVariant());
    }

    public void setDefaultLogCount(int count) {
        this.defaultLogCount_d = count;
    }

    public int getDefaultLogCount() {
        return this.defaultLogCount_d;
    }

    public void setDefaultLogDetail(Integer detail) {
        this.defaultDetail_d = detail;
    }

    public Integer getDefaultLogDetail() {
        return this.defaultDetail_d;
    }

    public void setDefaultLogSeverity(String severity) {
        this.defaultSeverity_d = severity;
    }

    public String getDefaultLogSeverity() {
        return this.defaultSeverity_d;
    }

    public void setDefaultTheme(String theme) {
        this.theme_d = theme;
    }

    public String getDefaultTheme() {
        return this.theme_d;
    }

    public void setDoNotDelayCompilation(boolean doNotDelayCompilation) {
        this.doNotDelayCompilation_d = doNotDelayCompilation;
    }

    public boolean getDoNotDelayCompilation() {
        return this.doNotDelayCompilation_d;
    }

    public void setExportPublicationXML(boolean exportPublicationXML) {
        this.exportPublicationXML_d = exportPublicationXML;
    }

    public boolean getExportPublicationXML() {
        return this.exportPublicationXML_d;
    }

    public void setCurrentTip(int current) {
        this.currentTip = current;
    }

    public int getCurrentTip() {
        return this.currentTip;
    }

    public void setDefaultBrowser(String defaultBrowser) {
        this.defaultBrowser = defaultBrowser;
    }

    public String getDefaultBrowser() {
        return this.defaultBrowser;
    }

    public void setLastExportedType(String s) {
        this.lastExportedType = s;
    }

    public String getLastExportedType() {
        return this.lastExportedType;
    }

    public void setLastJCLUsedDir(String dir) {
        this.lastJCLUsedDir = dir;
    }

    public String getLastJCLUsedDir() {
        return this.lastJCLUsedDir;
    }

    public void setLastOpenedFiles(StringList l) {
        this.lastOpenedFiles_d = l;
    }

    public StringList getLastOpenedFiles() {
        return this.lastOpenedFiles_d;
    }

    public void setLastOpenedProject(String fileName) {
        this.lastOpenedProject_d = fileName;
    }

    public String getLastOpenedProject() {
        return this.lastOpenedProject_d;
    }

    public StringList getLastOpenedProjects() {
        return this.lastOpenedProjects_d;
    }

    public void setLastUsedDir(String absolutePath) {
        this.lastUsedDir = absolutePath;
    }

    public String getLastUsedDir() {
        return this.lastUsedDir;
    }

    public void setLastUsedExportPath(String path) {
        this.lastUsedExportPath = path;
    }

    public String getLastUsedExportPath() {
        return this.lastUsedExportPath;
    }

    public void setLastUsedFile(String f) {
        this.lastFile_d = f;
    }

    public String getLastUsedFile() {
        return this.lastFile_d;
    }

    public void setLastUsedFiles(StringList l) {
        this.lastUsedFiles_d = l;
    }

    public List getLastUsedFiles() {
        return this.lastUsedFiles_d;
    }

    public void setLastUsedImportProjectFile(String path) {
        this.lastUsedImportProjectFile = path;
    }

    public String getLastUsedImportProjectFile() {
        return this.lastUsedImportProjectFile;
    }

    public void setServicePackServerUrl(String servicePackServerUrl) {
        this.servicePackServerUrl = servicePackServerUrl;
    }

    public String getServicePackServerUrl() {
        return this.servicePackServerUrl;
    }

    public void setShowCheckForUpdates(boolean val) {
        this.showCheckForUpdates = val;
    }

    public boolean getShowCheckForUpdates() {
        return this.showCheckForUpdates;
    }

    public void setShowTipsOnStartUp(boolean val) {
        this.showTipsOnStartUp = val;
    }

    public boolean getShowTipsOnStartup() {
        return this.showTipsOnStartUp;
    }

    public File getPreferencesFile() {
        return this.preferencesFile != null ? this.preferencesFile : FuegoDirectories.homeRelativeFile(DEFAULT_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getPreferencesFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
            this.writerXML(writer);
            writer.flush();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void updateMRUList(String path) {
        String absolutePath = path;
        StringList l = this.getLastOpenedFiles();
        if (!l.contains(absolutePath = absolutePath.replace('\\', '/'))) {
            if (l.size() >= 5) {
                l.remove(4);
            }
            l.add(0, absolutePath.replace('\\', '/'));
        } else {
            int i = l.indexOf(absolutePath);
            if (i >= 0) {
                l.remove(absolutePath);
                l.add(0, absolutePath);
            }
        }
    }

    public void writerXML(Writer writer) throws IOException {
        XmlWriter xml = new XmlWriter(writer, "UTF-8");
        xml.startDocument();
        xml.startElement("CommonPreferences");
        xml.startElement("file");
        xml.printAttribute("lastUsedFile", this.getLastUsedFile());
        xml.printAttribute("lastUsedDir", this.getLastUsedDir());
        xml.printAttribute("lastJCLUsedDir", this.getLastJCLUsedDir());
        xml.printAttribute("lastOpenedProject", this.getLastOpenedProject());
        xml.printAttribute("lastExportedType", this.getLastExportedType());
        xml.printAttribute("lastUsedExportPath", this.getLastUsedExportPath());
        xml.printAttribute("lastUsedImportProjectFile", this.getLastUsedImportProjectFile());
        xml.printAttribute("lastOpenedFiles", this.getLastOpenedFiles().toSeparatedString(";"));
        xml.printAttribute("lastOpenedProjects", this.getLastOpenedProjects().toSeparatedString(";"));
        xml.printAttribute("path", this.getCurrentFile().getPath());
        xml.printAttribute("confirmSQLExecution", this.getConfirmSQLExecution());
        xml.printAttribute("doNotDelayCompilation", this.getDoNotDelayCompilation());
        xml.printAttribute("exportPublicationXML", this.getExportPublicationXML());
        xml.endElement();
        xml.startElement("applications");
        xml.printAttribute("language", this.language_d);
        xml.printAttribute("country", this.country_d);
        xml.printAttribute("variant", this.variant_d);
        xml.printAttribute("theme", this.getDefaultTheme());
        xml.printAttribute("logSeverity", this.getDefaultLogSeverity());
        xml.printAttribute("logDetail", String.valueOf(this.getDefaultLogDetail()));
        xml.printAttribute("logCount", this.getDefaultLogCount());
        xml.printAttribute("defaultBrowser", this.getDefaultBrowser());
        xml.printAttribute("currentTip", this.getCurrentTip());
        xml.printAttribute("showTipsOnStartUp", this.getShowTipsOnStartup());
        xml.printAttribute("useProxyConfiguration", this.getUseProxyConfiguration());
        xml.printAttribute("httpProxyHost", this.getHttpProxyHost());
        xml.printAttribute("httpProxyPort", this.getHttpProxyPort());
        xml.printAttribute("automaticallyCheckForUpdates", this.getAutomaticallyCheckForUpdates());
        xml.setIgnoreEmpty(false);
        xml.printAttribute("showCheckForUpdates", this.getShowCheckForUpdates());
        xml.setIgnoreEmpty(true);
        xml.printAttribute("servicePackServerUrl", this.getServicePackServerUrl());
        xml.endElement();
        xml.endElement();
    }

    String getLanguage() {
        return this.language_d;
    }

    String getCountry() {
        return this.country_d;
    }

    String getVariant() {
        return this.variant_d;
    }

    void setCountry(String country) {
        this.country_d = country;
    }

    void setLanguage(String language) {
        this.language_d = language;
    }

    void setVariant(String variant) {
        this.variant_d = variant;
    }

    private static void setJVMPreferences() {
        CommonPreferences preferences = CommonPreferences.getInstance();
        if (preferences.getUseProxyConfiguration()) {
            System.setProperty(PROXY_HOST_SYSTEM_PROPERTY, preferences.getHttpProxyHost());
            System.setProperty(PROXY_PORT_SYSTEM_PROPERTY, preferences.getHttpProxyPort());
        }
    }

    private void setPreferencesFile(File path) {
        this.preferencesFile = path;
    }

    public static class CommonPreferencesLoader
    extends DefaultHandler {
        private File file_d;
        private CommonPreferences preferences_d;
        private List warningList_d = new ArrayList();

        public CommonPreferencesLoader(File f, CommonPreferences pref) throws Exception {
            this.file_d = f;
            this.preferences_d = pref;
            if (f.exists()) {
                this.load();
            }
        }

        public List getWarningList() {
            return this.warningList_d;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String local, String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String local, @NonNls String name, Attributes amap) throws SAXException {
            try {
                if ("file".equals(name)) {
                    this.manageFileInfo(amap);
                    return;
                }
                if ("applications".equals(name)) {
                    this.manageApplicationsInfo(amap);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void load() throws Exception {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(true);
            SAXParser sp = spf.newSAXParser();
            XMLReader parser = sp.getXMLReader();
            parser.setContentHandler(this);
            parser.parse(new InputSource(new FileInputStream(this.file_d)));
        }

        private void manageApplicationsInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                boolean aBoolean;
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("language".equals(attname)) {
                    this.preferences_d.setLanguage(value);
                    continue;
                }
                if ("country".equals(attname)) {
                    this.preferences_d.setCountry(value);
                    continue;
                }
                if ("variant".equals(attname)) {
                    this.preferences_d.setVariant(value);
                    continue;
                }
                if ("theme".equals(attname)) {
                    this.preferences_d.setDefaultTheme(value);
                    continue;
                }
                if ("logSeverity".equals(attname)) {
                    this.preferences_d.setDefaultLogSeverity(value);
                    continue;
                }
                if ("logDetail".equals(attname)) {
                    this.preferences_d.setDefaultLogDetail(Integer.valueOf(value));
                    continue;
                }
                if ("logCount".equals(attname)) {
                    this.preferences_d.setDefaultLogCount(Integer.parseInt(value));
                    continue;
                }
                if ("defaultBrowser".equals(attname)) {
                    this.preferences_d.setDefaultBrowser(value);
                    continue;
                }
                if ("currentTip".equals(attname)) {
                    this.preferences_d.setCurrentTip(Integer.parseInt(value));
                    continue;
                }
                if ("showTipsOnStartUp".equals(attname)) {
                    aBoolean = Boolean.valueOf(value);
                    this.preferences_d.setShowTipsOnStartUp(aBoolean);
                    continue;
                }
                if ("automaticallyCheckForUpdates".equals(attname)) {
                    aBoolean = Boolean.valueOf(value);
                    this.preferences_d.setAutomaticallyCheckForUpdates(aBoolean);
                    continue;
                }
                if ("showCheckForUpdates".equals(attname)) {
                    aBoolean = Boolean.valueOf(value);
                    this.preferences_d.setShowCheckForUpdates(aBoolean);
                    continue;
                }
                if ("servicePackServerUrl".equals(attname)) {
                    this.preferences_d.setServicePackServerUrl(value);
                    continue;
                }
                if ("useProxyConfiguration".equals(attname)) {
                    aBoolean = Boolean.valueOf(value);
                    this.preferences_d.setUseProxyConfiguration(aBoolean);
                    continue;
                }
                if ("httpProxyHost".equals(attname)) {
                    this.preferences_d.setHttpProxyHost(value);
                    continue;
                }
                if ("httpProxyPort".equals(attname)) {
                    this.preferences_d.setHttpProxyPort(value);
                    continue;
                }
                CoreMsg.PREFERENCE_NOT_VALID(attname).logDebug();
            }
        }

        private void manageFileInfo(Attributes amap) {
            for (int i = 0; i < amap.getLength(); ++i) {
                String s;
                StringTokenizer st;
                String attname = amap.getQName(i);
                String value = amap.getValue(i);
                if ("path".equals(attname)) {
                    this.preferences_d.setCurrentFile(new File(value));
                    continue;
                }
                if ("lastUsedFile".equals(attname)) {
                    this.preferences_d.setLastUsedFile(value);
                    continue;
                }
                if ("lastJCLUsedDir".equals(attname)) {
                    this.preferences_d.setLastJCLUsedDir(value);
                    continue;
                }
                if ("lastUsedDir".equals(attname)) {
                    this.preferences_d.setLastUsedDir(value);
                    continue;
                }
                if ("lastExportedType".equals(attname)) {
                    this.preferences_d.setLastExportedType(value);
                    continue;
                }
                if ("lastUsedExportPath".equals(attname)) {
                    this.preferences_d.setLastUsedExportPath(value);
                    continue;
                }
                if ("lastUsedImportProjectFile".equals(attname)) {
                    this.preferences_d.setLastUsedImportProjectFile(value);
                    continue;
                }
                if ("lastOpenedProject".equals(attname)) {
                    this.preferences_d.setLastOpenedProject(value);
                    continue;
                }
                if ("lastOpenedFiles".equals(attname)) {
                    st = new StringTokenizer(value, ";");
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        this.preferences_d.getLastOpenedFiles().add(s);
                    }
                    continue;
                }
                if ("lastOpenedProjects".equals(attname)) {
                    st = new StringTokenizer(value, ";");
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        this.preferences_d.getLastOpenedProjects().add(s);
                    }
                    continue;
                }
                if ("confirmSQLExecution".equals(attname)) {
                    this.preferences_d.setConfirmSQLExecution(Boolean.valueOf(value));
                    continue;
                }
                if ("doNotDelayCompilation".equals(attname)) {
                    this.preferences_d.setDoNotDelayCompilation(Boolean.valueOf(value));
                    continue;
                }
                if ("exportPublicationXML".equals(attname)) {
                    this.preferences_d.setExportPublicationXML(Boolean.valueOf(value));
                    continue;
                }
                Log.logWarning(CoreMsg.PREFERENCE_NOT_VALID(attname));
            }
        }
    }
}

