/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.util.ArrayIterator;
import oracle.bpm.util.CollectionConcurrentModificationException;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.DefaultValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    @NonNls
    static final String FILTERED_IT_FACTORY = "Miterator(Ljava.lang.String;[Ljava.lang.Object;)Ljava.util.Iterator;";

    private ArrayUtils() {
    }

    public static <T> void setElement(List<T> array, long index, T value) {
        ArrayUtils.listSetElement(array, (int)index, value);
    }

    public static Object setElement(Class elementType, Object array, int index, Object value) {
        return ArrayUtils.primitiveSetElement(array, index, value, elementType, true);
    }

    public static Object setElement(Class elementType, Object array, int index, Object value, boolean autoinit) {
        return ArrayUtils.primitiveSetElement(array, index, value, elementType, autoinit);
    }

    public static Object addElement(Class elementType, Object array, Object value) {
        return ArrayUtils.primitiveAddElement(array, value, elementType);
    }

    public static Class arrayOf(Class elementType) {
        return Array.newInstance(elementType, 0).getClass();
    }

    public static <T> List<T> asList(T[] elements) {
        return elements == null ? null : (elements.length == 0 ? new ArrayList() : new ArrayList<T>(Arrays.asList(elements)));
    }

    public static <T> LinkedHashMap<T, T> asMap(T[] objs) {
        if (objs == null) {
            return null;
        }
        LinkedHashMap map = new LinkedHashMap(objs.length / 2);
        ArrayUtils.fillMap(map, objs);
        return map;
    }

    public static TreeMap<Object, Object> asTreeMap(Object[] objs) {
        if (objs == null) {
            return null;
        }
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        ArrayUtils.fillMap(map, objs);
        return map;
    }

    public static Iterator collectionIterator(@Nullable Object collection) {
        Iterator<Object> result = null;
        if (collection instanceof Iterator) {
            result = (Iterator)collection;
        } else if (collection instanceof Iterable) {
            result = ((Iterable)collection).iterator();
        } else if (collection instanceof Map) {
            result = ((Map)collection).values().iterator();
        }
        return result == null ? EMPTY_ITERATOR : result;
    }

    public static int collectionSize(@Nullable Object collection) {
        int result = 0;
        if (collection != null) {
            if (collection instanceof Collection) {
                result = ((Collection)collection).size();
            } else if (collection instanceof Object[]) {
                result = ((Object[])collection).length;
            } else if (collection.getClass().isArray()) {
                result = Array.getLength(collection);
            }
        }
        return result;
    }

    public static boolean contains(List list, Object element) {
        if (list != null) {
            for (Object o : list) {
                if (!Any.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Set set, Object element) {
        return ArrayUtils.containsElement(set, element);
    }

    public static boolean contains(Map map, Object element) {
        return ArrayUtils.containsElement(map, element);
    }

    public static boolean contains(Object array, Object element) {
        return ArrayUtils.containsElement(array, element);
    }

    public static boolean containsElement(Object collection, Object element) {
        boolean result;
        block2: {
            block6: {
                block5: {
                    block4: {
                        block3: {
                            result = false;
                            if (collection == null) break block2;
                            if (!(collection instanceof Set)) break block3;
                            result = ((Set)collection).contains(element);
                            break block2;
                        }
                        if (!(collection instanceof Map)) break block4;
                        result = ((Map)collection).containsKey(element);
                        break block2;
                    }
                    if (!(collection instanceof List)) break block5;
                    result = ArrayUtils.contains((List)collection, element);
                    break block2;
                }
                if (!(collection instanceof Object[])) break block6;
                Object[] elements = (Object[])collection;
                for (int i = 0; !result && i < elements.length; ++i) {
                    result = Any.equals(elements[i], element);
                }
                break block2;
            }
            if (!collection.getClass().isArray()) break block2;
            int length = Array.getLength(collection);
            for (int i = 0; !result && i < length; ++i) {
                result = Any.equals(Array.get(collection, i), element);
            }
        }
        return result;
    }

    public static <T> Object convertElements(Object oldArray, Class<T> elementType) {
        ArrayList<T> result = null;
        if (oldArray != null) {
            Method converter = Conversion.getMethod(Object.class, elementType);
            if (converter == null) {
                result = oldArray;
            } else if (oldArray instanceof List) {
                List from = oldArray;
                ArrayList<T> array = new ArrayList<T>(from.size());
                for (Object value : from) {
                    array.add(Conversion.convertTo(value, elementType, converter));
                }
                result = array;
            } else {
                int length = Array.getLength(oldArray);
                result = Array.newInstance(elementType, length);
                for (int i = 0; i < length; ++i) {
                    Object value = Array.get(oldArray, i);
                    Array.set(result, i, Conversion.convertTo(value, elementType, converter));
                }
            }
        }
        return result;
    }

    public static Iterator elementIterator(List list) {
        return list != null ? list.iterator() : EMPTY_ITERATOR;
    }

    public static Iterator elementIterator(Set set) {
        return set != null ? set.iterator() : EMPTY_ITERATOR;
    }

    public static Iterator elementIterator(Map map) {
        return map != null ? map.values().iterator() : EMPTY_ITERATOR;
    }

    public static Iterator elementIterator(Iterator iterator) {
        return iterator != null ? iterator : EMPTY_ITERATOR;
    }

    public static Iterator elementIterator(Object array) {
        return ArrayUtils.collectionIterator(array);
    }

    public static Iterator keySetIterator(@Nullable Object collection) {
        Iterator result = null;
        if (collection instanceof Map) {
            result = ((Map)collection).keySet().iterator();
        }
        return result == null ? EMPTY_ITERATOR : result;
    }

    public static Iterator indexIterator(@Nullable Map map) {
        Iterator iterator = map != null ? map.keySet().iterator() : EMPTY_ITERATOR;
        return new ArrayUtilsIterator(iterator);
    }

    public static Object[] invert(Object[] array) {
        if (array != null) {
            int j = array.length - 1;
            for (int i = 0; i < j; ++i, --j) {
                Object o = array[i];
                array[i] = array[j];
                array[j] = o;
            }
        }
        return array;
    }

    public static int length(Collection col) {
        return ArrayUtils.collectionSize(col);
    }

    public static int length(Object[] col) {
        return ArrayUtils.collectionSize(col);
    }

    public static int length(long[] array) {
        return array != null ? array.length : 0;
    }

    public static int length(double[] array) {
        return array != null ? array.length : 0;
    }

    public static int length(Object array) {
        return ArrayUtils.collectionSize(array);
    }

    public static <T> T listGetElement(List<T> list, int index, Class<T> elementType) throws Exception {
        T element;
        if (list.size() == index) {
            element = ArrayUtils.newElement(list, elementType);
            list.add(element);
        } else {
            element = list.get(index);
            if (element == null) {
                element = elementType.newInstance();
                list.set(index, element);
            }
        }
        return element;
    }

    public static <T> void listSetElement(List<T> array, int index, T value) {
        int size = array.size();
        if (index < size) {
            array.set(index, value);
        } else if (index == size) {
            array.add(value);
        } else {
            throw new IndexOutOfBoundsException("Index out of bounds. Index: " + index + ", Array size: " + size + ')');
        }
    }

    public static <K, V> V mapGetElement(Map<K, V> map, K index, Class<V> elemClass) {
        V element = map.get(index);
        if (element == null) {
            element = DefaultValue.forClass(elemClass);
            map.put(index, element);
        }
        return element;
    }

    public static Object primitiveAddElement(Object array, Object value, Class elementType) {
        return ArrayUtils.primitiveSetElement(array, array == null ? 0 : Array.getLength(array), value, elementType, true);
    }

    public static Object primitiveGetElement(Object object, int index, String member) throws NoSuchFieldException, IllegalAccessException {
        Field field = object.getClass().getField(member);
        Object array = field.get(object);
        Class<?> elemType = field.getType().getComponentType();
        if (array == null) {
            array = Array.newInstance(elemType, 1);
            field.set(object, array);
        } else if (Array.getLength(array) == index) {
            Object defaultValue = DefaultValue.forClass(elemType, true);
            array = ArrayUtils.addElement(elemType, array, defaultValue);
            field.set(object, array);
        }
        Object element = Array.get(array, index);
        if (element == null) {
            element = DefaultValue.forClass(elemType, true);
            Array.set(array, index, element);
        }
        return element;
    }

    public static Object primitiveSetElement(Object array, int index, Object value, Class elementType, boolean autoinit) {
        if (autoinit) {
            if (array == null) {
                array = Array.newInstance(elementType, index + 1);
                assert (array != null) : "Can't create array of : " + elementType.getName();
            } else {
                int length = Array.getLength(array);
                if (length <= index) {
                    Object newArray = Array.newInstance(elementType, index + 1);
                    System.arraycopy(array, 0, newArray, 0, length);
                    array = newArray;
                }
            }
        }
        try {
            Array.set(array, index, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " [array.class: " + JavaClass.classInfo(array) + ", element.class: " + JavaClass.classInfo(value) + ']');
        }
        return array;
    }

    public static <K, V> V reference(Map<K, V> map, Class<V> elemClass, K index) {
        return ArrayUtils.mapGetElement(map, index, elemClass);
    }

    public static <T> T reference(List<T> list, Class<T> elementType, long index) throws Exception {
        return ArrayUtils.listGetElement(list, (int)index, elementType);
    }

    public static Object reference(Object object, String member, long index) throws NoSuchFieldException, IllegalAccessException {
        return ArrayUtils.primitiveGetElement(object, (int)index, member);
    }

    public static <T> Object toArray(Object collection, Class<T> elementType) {
        Object array;
        if (collection == null) {
            array = null;
        } else {
            if (collection instanceof Object[]) {
                collection = Arrays.asList((Object[])collection);
            }
            if (collection instanceof Collection) {
                Collection list = collection;
                array = Array.newInstance(elementType, list.size());
                if (array instanceof Object[]) {
                    ArrayUtils.fill(list, (Object[])array, elementType);
                } else {
                    ArrayUtils.fill(list, array, elementType);
                }
            } else {
                array = null;
            }
        }
        return array;
    }

    public static HashMap toHashMap(Object o) {
        if (o == null || o instanceof HashMap) {
            return (HashMap)o;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ArrayUtils.fill(result, o);
        return result;
    }

    public static Iterator toIterator(Object value) {
        Iterator result;
        if (value == null) {
            result = EMPTY_ITERATOR;
        } else if (value instanceof Iterable) {
            result = ((Iterable)value).iterator();
        } else if (value instanceof Iterator) {
            result = (Iterator)value;
        } else if (value instanceof Map) {
            result = ((Map)value).values().iterator();
        } else if (value.getClass().isArray()) {
            result = ArrayIterator.create(value);
        } else if (value instanceof byte[]) {
            result = ArrayUtils.toIterator(Binary.deserialize((byte[])value));
        } else {
            throw new IllegalConversionException(value, "Iterator");
        }
        return result;
    }

    public static LinkedHashMap toLinkedHashMap(Object o) {
        if (o == null || o instanceof LinkedHashMap) {
            return (LinkedHashMap)o;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        ArrayUtils.fill(result, o);
        return result;
    }

    public static ArrayList toArrayList(List l) {
        if (l == null || l instanceof ArrayList) {
            return (ArrayList)l;
        }
        return new ArrayList(l);
    }

    public static LinkedList toLinkedList(List l) {
        if (l == null || l instanceof LinkedList) {
            return (LinkedList)l;
        }
        return new LinkedList(l);
    }

    public static Vector toVector(List l) {
        if (l == null || l instanceof Vector) {
            return (Vector)l;
        }
        return new Vector(l);
    }

    public static List toListWET(Object array, Class targetType) throws IllegalAccessException, InstantiationException {
        return ArrayUtils.toListSL(array, targetType, null, -1, -1);
    }

    public static List toList(Object array, Class targetType, Class targetElementType) throws IllegalAccessException, InstantiationException {
        return ArrayUtils.toListSL(array, targetType, targetElementType, -1, -1);
    }

    public static List toListSL(Object array, Class target, Class targetElement, int scale, int length) throws InstantiationException, IllegalAccessException {
        ArrayList<Object> list = null;
        if (array != null) {
            Method converter;
            if (!List.class.isAssignableFrom(target)) {
                throw new IllegalArgumentException(target.getName() + " is not a subtype of java.util.List");
            }
            Class listClass = (Class)Cast.force(target);
            list = listClass.isInterface() ? new ArrayList() : (List)listClass.newInstance();
            Class<?> sourceType = array.getClass();
            Class sourceElementType = sourceType.isArray() ? sourceType.getComponentType() : Object.class;
            Method method = converter = targetElement == null || targetElement == Object.class && sourceElementType == targetElement ? null : Conversion.getMethod(sourceElementType, targetElement.getName(), scale, length);
            if (array instanceof Collection) {
                ArrayUtils.addAllConverting(list, ((Collection)array).iterator(), converter, targetElement, scale, length);
            } else if (array instanceof Iterator) {
                ArrayUtils.addAllConverting(list, (Iterator)array, converter, targetElement, scale, length);
            } else if (array instanceof Object[]) {
                ArrayUtils.addAllConverting(list, Arrays.asList((Object[])array).iterator(), converter, targetElement, scale, length);
            } else if (sourceType.isArray()) {
                int l = Array.getLength(array);
                for (int i = 0; i < l; ++i) {
                    Object elem = Array.get(array, i);
                    if (converter != null) {
                        elem = Conversion.convertTo(elem, targetElement, converter, scale, length);
                    }
                    list.add(elem);
                }
            } else {
                throw new IllegalConversionException(array, listClass);
            }
        }
        return list;
    }

    public static String toString(Object array) {
        if (array == null || !array.getClass().isArray()) {
            return String.valueOf(array);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ArrayUtils.toString(Array.get(array, i)));
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static TreeMap toTreeMap(Object o) {
        if (o == null || o instanceof TreeMap) {
            return (TreeMap)o;
        }
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        ArrayUtils.fill(result, o);
        return result;
    }

    public static <T> T[] trim(T[] array) {
        int nullCount = 0;
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                ++nullCount;
            }
        }
        if (nullCount == 0) {
            return array;
        }
        Object[] result = (Object[])Cast.force(Array.newInstance(array.getClass().getComponentType(), array.length - nullCount));
        int j = 0;
        for (T element : array) {
            if (element == null) continue;
            result[j++] = element;
        }
        return result;
    }

    public static Iterator filteredIterator(Invokeable collection, String filter, Object[] arguments) throws ComponentExecutionException, InvocationTargetException {
        return (Iterator)collection.invoke(FILTERED_IT_FACTORY, filter, arguments);
    }

    public static Class[] typesArray(Object ... objects) {
        int length = objects.length;
        Class[] result = new Class[length];
        for (int i = 0; i < length; ++i) {
            result[i] = objects[i].getClass();
        }
        return result;
    }

    public static String toString(Object[] array, String separator) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(String.valueOf(array[i]));
        }
        return buffer.toString();
    }

    public static boolean isNullOrEmtpy(Object[] array) {
        return array == null || array.length == 0;
    }

    private static <T> void fillMap(Map<T, T> map, T[] objs) {
        for (int i = 0; i < objs.length; i += 2) {
            map.put(objs[i], objs[i + 1]);
        }
    }

    private static void addAllConverting(List<Object> list, Iterator iterator, Method converter, Class targetElement, int scale, int length) {
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            if (converter != null) {
                elem = Conversion.convertTo(elem, targetElement, converter, scale, length);
            }
            list.add(elem);
        }
    }

    private static <T> void fill(Collection list, Object array, Class<T> elementType) {
        boolean init = false;
        Object defaultValue = null;
        int i = 0;
        for (Object value : list) {
            if (value == null) {
                if (!init) {
                    defaultValue = DefaultValue.forClass(elementType);
                    init = true;
                }
                value = defaultValue;
            }
            Array.set(array, i++, value);
        }
    }

    private static <T> void fill(Collection list, Object[] elements, Class<T> elementType) {
        int i = 0;
        for (Object value : list) {
            if (value != null && !elementType.isAssignableFrom(value.getClass())) {
                value = Conversion.convertTo(value, elementType);
            }
            elements[i++] = value;
        }
    }

    private static void fill(Map<Object, Object> result, Object o) {
        block3: {
            block4: {
                block2: {
                    if (!(o instanceof Map)) break block2;
                    result.putAll((Map)o);
                    break block3;
                }
                if (!(o instanceof List)) break block4;
                int i = 0;
                for (Object value : (List)o) {
                    result.put(i++, value);
                }
                break block3;
            }
            if (!o.getClass().isArray()) break block3;
            int length = Array.getLength(o);
            for (int i = 0; i < length; ++i) {
                result.put(i, Array.get(o, i));
            }
        }
    }

    private static <T> T newElement(List<T> list, Class<T> elementType) throws Exception {
        T result;
        if (list instanceof Extendable) {
            Extendable extendable = (Extendable)Cast.force(list);
            result = extendable.createNewElement();
        } else {
            result = DefaultValue.forClass(elementType, true);
        }
        return result;
    }

    public static class ArrayUtilsIterator
    implements Iterator {
        private Iterator iterator;

        public ArrayUtilsIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object obj;
            try {
                obj = this.iterator.next();
            }
            catch (ConcurrentModificationException e) {
                throw new CollectionConcurrentModificationException();
            }
            return obj;
        }
    }

    public static interface Extendable<T> {
        public T createNewElement() throws Exception;
    }
}

