/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.ui;

import java.util.Locale;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontInfo;

public enum FontStyle implements I18nProvider
{
    PLAIN(CoreMsg.PLAIN),
    BOLD(CoreMsg.BOLD),
    ITALIC(CoreMsg.ITALIC),
    BOLD_ITALIC(CoreMsg.BOLD_ITALIC);

    public static FontStyle NORMAL;
    public static FontStyle ITALIC_BOLD;
    private transient Msg msg;

    private FontStyle(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public int intValue() {
        return this.ordinal();
    }

    public static FontStyle valueOf(int fontType) {
        FontStyle[] styles = FontStyle.values();
        return fontType >= 0 && fontType < styles.length ? styles[fontType] : PLAIN;
    }

    public static FontStyle valueOf(FontInfo fontType) {
        int style = fontType.getStyle();
        switch (style) {
            case 0: {
                return PLAIN;
            }
            case 1: {
                return BOLD;
            }
            case 2: {
                return ITALIC;
            }
            case 3: {
                return ITALIC_BOLD;
            }
        }
        return PLAIN;
    }

    public boolean isBold() {
        return this == BOLD || this == BOLD_ITALIC;
    }

    public boolean isItalic() {
        return this == ITALIC || this == BOLD_ITALIC;
    }

    public static FontStyle valueOf(boolean bold, boolean italic) {
        return bold ? (italic ? BOLD_ITALIC : BOLD) : (italic ? ITALIC : PLAIN);
    }

    public boolean contains(FontStyle modifiers) {
        return modifiers != null && (this.ordinal() & modifiers.ordinal()) != 0;
    }

    public FontStyle add(FontStyle modifiers) {
        return modifiers == null ? this : FontStyle.valueOf(this.ordinal() | modifiers.ordinal());
    }

    public FontStyle remove(FontStyle modifiers) {
        return modifiers == null ? this : FontStyle.valueOf(this.ordinal() & ~modifiers.ordinal());
    }

    public static FontStyle fromString(String fontString) {
        FontStyle result = PLAIN;
        if (fontString != null) {
            fontString = fontString.toUpperCase();
            for (FontStyle style : FontStyle.values()) {
                if (!style.toString().equalsIgnoreCase(fontString)) continue;
                result = style;
                break;
            }
        }
        return result;
    }

    static {
        NORMAL = PLAIN;
        ITALIC_BOLD = BOLD_ITALIC;
    }
}

