/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.util.EnumMap;
import oracle.bpm.log.LogComponent;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.InvalidMessageException;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.MsgType;
import oracle.bpm.resources.UIMsg;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TErrorMsg
extends UIMsg {
    private static final long serialVersionUID = 1190498456824219107L;

    protected TErrorMsg(@NotNull EnumMap<MsgType, String> message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.<init> must not be null");
        }
        super(message);
    }

    protected TErrorMsg(@NotNull String description, @NotNull String cause, @NotNull String action) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.<init> must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.<init> must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.<init> must not be null");
        }
        this(MsgType.buildMsgMap(description, cause, action));
    }

    public ErrorMsg args(Object ... arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.args must not be null");
        }
        assert (!"".equals(this.code)) : "Error Message Bundle not initialized";
        arguments = this.completeArgs(arguments);
        ErrorMsg result = new ErrorMsg(this.getMessagesByType(), arguments);
        result.code = this.code;
        result.bundle = this.bundle;
        result.setErrorCode(MsgBundle.getErrorCode(this.bundle, this.code));
        return result;
    }

    protected void init(@NonNls String msgCode, Class<? extends MsgBundle> msgBundle) {
        this.init(msgCode, msgBundle, true, LogComponent.DEFAULT);
        if (this.getArgCount() == 0) {
            throw new InvalidMessageException(msgBundle, msgCode, "No arguments: " + this.getMsgByType(MsgType.DEFAULT));
        }
    }

    private Object[] completeArgs(Object ... arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/TErrorMsg.completeArgs must not be null");
        }
        int count = this.getArgCount();
        if (arguments.length != count) {
            assert (false) : this.code + ": Wrong argument count. Msg: " + count + " vs called: " + arguments.length;
            Object[] a = new Object[count];
            for (int i = 0; i < a.length; ++i) {
                a[i] = i < arguments.length ? arguments[i] : "";
            }
            arguments = a;
        }
        return arguments;
    }
}

