/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.resources;

import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum MsgType {
    DEFAULT(""),
    DETAIL(".DET"),
    IMAGE(".IMG"),
    MNEMONIC(".MN"),
    ERROR_CAUSE(".CAUSE"),
    ERROR_ACTION(".ACTION"),
    ERROR_SEVERITY(".SEVERITY");

    private String extension;
    public static final char NO_MNEMONIC = '\u0000';

    private MsgType(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public static EnumMap<MsgType, String> buildMsgMap(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        EnumMap<MsgType, String> map = new EnumMap<MsgType, String>(MsgType.class);
        map.put(DEFAULT, message);
        return map;
    }

    public static EnumMap<MsgType, String> buildMsgMap(@NotNull String message, @Nullable String detail, @Nullable String image, char mnemonic) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        EnumMap<MsgType, String> map = new EnumMap<MsgType, String>(MsgType.class);
        map.put(DEFAULT, message);
        if (detail != null) {
            map.put(DETAIL, detail);
        }
        if (image != null) {
            map.put(IMAGE, image);
        }
        if (mnemonic != '\u0000') {
            map.put(MNEMONIC, String.valueOf(mnemonic));
        }
        return map;
    }

    public static EnumMap<MsgType, String> buildMsgMap(@NotNull String message, @NotNull String cause, @NotNull String action) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        EnumMap<MsgType, String> map = new EnumMap<MsgType, String>(MsgType.class);
        map.put(DEFAULT, message);
        map.put(ERROR_CAUSE, cause);
        map.put(ERROR_ACTION, action);
        return map;
    }

    public static EnumMap<MsgType, String> buildMsgMap(@NotNull String message, @NotNull String cause, @NotNull String action, @NotNull String severity) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        if (cause == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        if (severity == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of oracle/bpm/resources/MsgType.buildMsgMap must not be null");
        }
        EnumMap<MsgType, String> map = new EnumMap<MsgType, String>(MsgType.class);
        map.put(DEFAULT, message);
        map.put(ERROR_CAUSE, cause);
        map.put(ERROR_ACTION, action);
        map.put(ERROR_SEVERITY, severity);
        return map;
    }
}

