/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.processmodel;

import java.util.Locale;
import oracle.bpm.lang.Str;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Labeled;
import oracle.bpm.resources.Msg;

public enum ActivityType implements I18nProvider,
Labeled
{
    BEGIN(CoreMsg.BEGIN, "begin"),
    END(CoreMsg.END, "end"),
    SPLIT(CoreMsg.SPLIT, "split"),
    OR_SPLIT(CoreMsg.OR_SPLIT, "or_split"),
    JOIN(CoreMsg.JOIN, "join"),
    OR_JOIN(CoreMsg.OR_JOIN, "or_join"),
    GRAB(CoreMsg.GRAB, "grab"),
    GRAB_ALL(CoreMsg.GRAB_ALL, "grab_all"),
    GRAB_GG(CoreMsg.GRAB_GG, "grab_gg"),
    INTERACTIVE(CoreMsg.INTERACTIVE, "interactive"),
    DECISION(CoreMsg.DECISION, "decision"),
    GLOBAL(CoreMsg.GLOBAL, "global"),
    SPLIT_N(CoreMsg.SPLIT_N, "split_n"),
    SPLIT_N_JOIN(CoreMsg.JOIN, "split_n_join"),
    PROCESS_CREATION(CoreMsg.PROCESS_CREATION, "process_creation"),
    PROCESS_NOTIFICATION(CoreMsg.PROCESS_NOTIFICATION, "process_notification"),
    NOTIFICATION_WAIT(CoreMsg.NOTIFICATION_WAIT, "notification_wait"),
    INTERRUPTION(CoreMsg.INTERRUPTION, "interruption"),
    NOTIFICATION_WAIT_MULTI(CoreMsg.NOTIFICATION_WAIT_MULTI, "notification_wait_multi"),
    TERMINATION_WAIT(CoreMsg.TERMINATION_WAIT, "termination_wait"),
    GLOBAL_CREATION(CoreMsg.GLOBAL_CREATION, "global_creation"),
    AUTOMATIC(CoreMsg.AUTOMATIC, "automatic"),
    GLOBAL_AUTOMATIC(CoreMsg.GLOBAL_AUTOMATIC, "global_automatic"),
    SUBFLOW(CoreMsg.SUBFLOW, "subflow"),
    SUBSCREENFLOW(CoreMsg.SUBSCREENFLOW, "subscreenflow"),
    TIMER(CoreMsg.TIMER, "timer"),
    GROUP(CoreMsg.GROUP, "group"),
    MAIN_GROUP(CoreMsg.MAIN_GROUP, "main_group"),
    GROUP_BEGIN(CoreMsg.GROUP_BEGIN, "group_begin"),
    GROUP_END(CoreMsg.GROUP_END, "group_end"),
    COMPENSATE(CoreMsg.COMPENSATE, "compensate"),
    INTERACTIVE_COMPONENT_CALL(CoreMsg.INTERACTIVE_COMPONENT_CALL, "interactive_component_call"),
    THROW(CoreMsg.THROW),
    RETHROW(CoreMsg.RETHROW),
    SPLIT_N_WAIT(CoreMsg.SPLIT_N_WAIT),
    NOP(CoreMsg.NOP, "nop"),
    CONDITIONAL(CoreMsg.CONDITIONAL, "conditional"),
    ABSTRACT_ACTIVITY(CoreMsg.ABSTRACT_ACTIVITY, "abstract_activity"),
    SCRIPT_TASK(CoreMsg.SCRIPT_TASK, "script_task"),
    USER_TASK(CoreMsg.USER_TASK, "user_task"),
    SERVICE_TASK(CoreMsg.SERVICE_TASK, "service_task"),
    RECEIVE_TASK(CoreMsg.RECEIVE_TASK, "receive_task"),
    SEND_TASK(CoreMsg.SEND_TASK, "send_task"),
    BUSINESS_RULE_TASK(CoreMsg.BUSINESS_RULE_TASK, "business_rule_task"),
    SUBPROCESS(CoreMsg.SUBPROCESS, "subprocess"),
    FAULT_HANDLER(CoreMsg.FAULT_HANDLER, "exception"),
    CONNECTOR(CoreMsg.CONNECTOR, "connector"),
    MEASUREMENT(CoreMsg.MEASUREMENT, "measurement"),
    MEASUREMENT_START(CoreMsg.MEASUREMENT_START, "measurement_start"),
    MEASUREMENT_STOP(CoreMsg.MEASUREMENT_STOP, "measurement_stop"),
    PROCESS_ACTIVITY(CoreMsg.PROCESS_ACTIVITY),
    PROCESS_ACTIVITY_START(CoreMsg.PROCESS_ACTIVITY),
    PROCESS_ACTIVITY_END(CoreMsg.PROCESS_ACTIVITY),
    MESSAGE_LISTENER(CoreMsg.MESSAGE_LISTENER),
    THROW_EVENT(CoreMsg.THROW_EVENT),
    CATCH_EVENT(CoreMsg.CATCH_EVENT),
    START_EVENT(CoreMsg.START),
    END_EVENT(CoreMsg.END),
    BOUNDARY_EVENT(CoreMsg.BOUNDARY_EVENT),
    GATEWAY_PARALLEL(CoreMsg.GATEWAY_PARALLEL),
    GATEWAY_EXCLUSIVE(CoreMsg.GATEWAY_EXCLUSIVE),
    GATEWAY_INCLUSIVE(CoreMsg.GATEWAY_INCLUSIVE),
    GATEWAY_EVENT_BASED(CoreMsg.GATEWAY_EVENT_BASED);

    private transient Msg msg;
    private transient String fileName;
    private transient String niceName;

    private ActivityType(Msg msg) {
        this.msg = msg;
        this.niceName = Str.idFromConstantId(this.toString());
    }

    public String getFileName() {
        return this.fileName;
    }

    private ActivityType(Msg msg, String fileName) {
        this(msg);
        this.fileName = fileName;
    }

    public int intValue() {
        return this.ordinal();
    }

    public static ActivityType[] getBPMActivities() {
        return new ActivityType[]{INTERACTIVE, INTERACTIVE_COMPONENT_CALL, DECISION, AUTOMATIC, GROUP, SUBFLOW, SUBSCREENFLOW, PROCESS_CREATION, TERMINATION_WAIT, GRAB};
    }

    public static ActivityType[] getGateways() {
        return new ActivityType[]{CONDITIONAL, SPLIT, OR_SPLIT, SPLIT_N};
    }

    public static ActivityType[] getEvents() {
        return new ActivityType[]{NOTIFICATION_WAIT, PROCESS_NOTIFICATION, TIMER, COMPENSATE};
    }

    public static ActivityType[] getGlobals() {
        return new ActivityType[]{GLOBAL_CREATION, GLOBAL_AUTOMATIC, GLOBAL};
    }

    public static ActivityType[] getToolbarActivities() {
        return new ActivityType[]{GLOBAL_CREATION, GLOBAL_AUTOMATIC, GLOBAL, INTERACTIVE, DECISION, INTERACTIVE_COMPONENT_CALL, AUTOMATIC, SPLIT, OR_SPLIT, SPLIT_N, JOIN, GRAB, SUBFLOW, SUBSCREENFLOW, PROCESS_CREATION, TERMINATION_WAIT, NOTIFICATION_WAIT, PROCESS_NOTIFICATION, TIMER, CONDITIONAL, GROUP, COMPENSATE, CONNECTOR};
    }

    public boolean canEditTasks() {
        return this.isAutomatic() || this.isInteractive() || this.isGrab() || this.isInteractiveComponentCall() || this.isGlobal() || this.isGlobalCreation() || this.isDecision();
    }

    public boolean isAllowedInProcedures() {
        return this == BEGIN || this == END || this == OR_SPLIT || this == SPLIT || this == SPLIT_N || this == JOIN || this == PROCESS_CREATION || this == PROCESS_NOTIFICATION || this == AUTOMATIC || this == GROUP || this == TIMER || this == COMPENSATE || this == CONDITIONAL;
    }

    public boolean isAllowedInProcesses() {
        return this != INTERACTIVE_COMPONENT_CALL && this != SUBSCREENFLOW;
    }

    public boolean isAllowedInScreenFlows() {
        return this == BEGIN || this == END || this == INTERACTIVE_COMPONENT_CALL || this == AUTOMATIC || this == CONDITIONAL || this == SUBSCREENFLOW;
    }

    public boolean isAnyInteractive() {
        return this.isGrab() || this == GLOBAL || this == GLOBAL_CREATION || this == INTERACTIVE || this == INTERACTIVE_COMPONENT_CALL || this == DECISION;
    }

    public boolean isAnyAutomatic() {
        return this == BEGIN || this == END || this == SPLIT || this == OR_SPLIT || this == JOIN || this == SPLIT_N || this == SPLIT_N_WAIT || this == PROCESS_CREATION || this == PROCESS_NOTIFICATION || this == NOTIFICATION_WAIT || this == TERMINATION_WAIT || this == AUTOMATIC || this == GLOBAL_AUTOMATIC || this == SUBFLOW || this == GROUP || this == COMPENSATE || this == NOP || this == CONDITIONAL || this == THROW || this.isMeasurementMark() || this == MESSAGE_LISTENER || this.isAnySplit() || this.isTimer();
    }

    public boolean isBegin() {
        return this == BEGIN || this == START_EVENT;
    }

    public boolean isBeginOrEnd() {
        return this.isBegin() || this.isEnd();
    }

    public boolean isAnyGlobal() {
        return this == GLOBAL || this == GLOBAL_CREATION || this == GLOBAL_AUTOMATIC;
    }

    public boolean isGrab() {
        return this == GRAB || this == GRAB_ALL || this == GRAB_GG;
    }

    public boolean isIpc() {
        return this == BEGIN || this == END || this == PROCESS_CREATION || this == PROCESS_NOTIFICATION || this == NOTIFICATION_WAIT || this == TERMINATION_WAIT || this == SUBFLOW || this == INTERRUPTION;
    }

    public boolean isSubflow() {
        return this == SUBFLOW;
    }

    public boolean isProcessCreation() {
        return this == PROCESS_CREATION;
    }

    public boolean isGlobalCreation() {
        return this == GLOBAL_CREATION;
    }

    public boolean isGlobalAutomatic() {
        return this == GLOBAL_AUTOMATIC;
    }

    public boolean isGlobal() {
        return this == GLOBAL;
    }

    public boolean isTerminationWait() {
        return this == TERMINATION_WAIT;
    }

    public boolean isNotificationWait() {
        return this == NOTIFICATION_WAIT;
    }

    public boolean isProcessNofication() {
        return this == PROCESS_NOTIFICATION;
    }

    public boolean isAnyNop() {
        return this == NOP || this == CONDITIONAL;
    }

    public boolean isPossibleCompensateHandler() {
        return this == INTERACTIVE || this == AUTOMATIC || this == SUBFLOW || this == PROCESS_CREATION || this == SPLIT || this == OR_SPLIT || this == SPLIT_N;
    }

    public boolean isPossibleExceptionHandler() {
        return this == INTERACTIVE || this == AUTOMATIC || this == SUBFLOW || this == PROCESS_CREATION || this == SPLIT || this == OR_SPLIT || this == SPLIT_N || this == NOTIFICATION_WAIT;
    }

    public boolean isPossibleFaultHandler() {
        return this == INTERACTIVE || this == AUTOMATIC || this == SUBFLOW || this == PROCESS_CREATION || this == SPLIT || this == OR_SPLIT || this == SPLIT_N;
    }

    public boolean isSimulationTarget() {
        return this == SPLIT_N || this == SPLIT || this == OR_SPLIT || this == JOIN || this == END || this.isGrab() || this == GLOBAL || this == GLOBAL_CREATION || this == GLOBAL_AUTOMATIC;
    }

    public boolean isAnySplit() {
        return this == SPLIT || this == SPLIT_N || this == OR_SPLIT || this == SPLIT_N_WAIT;
    }

    public boolean isAnySplitOrJoin() {
        return this.isAnySplit() || this == JOIN;
    }

    public boolean isAndSplit() {
        return this == SPLIT;
    }

    public boolean isAndOrSplit() {
        return this == SPLIT || this == OR_SPLIT;
    }

    public boolean isSplitN() {
        return this == SPLIT_N;
    }

    public boolean isJoin() {
        return this == JOIN;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    @Override
    public Msg getLabel() {
        return this.getMsg();
    }

    public static ActivityType valueOf(int val) {
        return ActivityType.values()[val];
    }

    public Msg getDescription() {
        return this.getMsg();
    }

    public static int intValue(String id) {
        ActivityType result = ActivityType.valueOf(id);
        return result == null ? -1 : result.ordinal();
    }

    public String getId(String userId) {
        return this == BEGIN || this == END ? this.niceName : userId;
    }

    public boolean canGrabFrom() {
        return this != BEGIN && !this.isAnyGlobal() && !this.isGrab() && this != GROUP && this != NOP && this != CONDITIONAL && this != END;
    }

    public boolean canBeSimulated() {
        return !this.isEnd() && !this.isAnyGlobal() && !this.isGrab();
    }

    public boolean isConditional() {
        return this == CONDITIONAL;
    }

    public boolean canShareCils() {
        return this == INTERACTIVE || this == AUTOMATIC || this.isGrab();
    }

    public boolean hasRelatedSubprocess() {
        return this == SUBFLOW || this == PROCESS_CREATION || this == PROCESS_NOTIFICATION || this == TERMINATION_WAIT;
    }

    public boolean canAddArgumentVariables() {
        return this.isGrab() || this == INTERACTIVE || this == AUTOMATIC || this == GLOBAL || this == GLOBAL_CREATION;
    }

    public boolean isEnd() {
        return this == END || this == END_EVENT;
    }

    public boolean isGroup() {
        return this == GROUP;
    }

    public boolean isAllowedInAtomicScopes() {
        return this == AUTOMATIC || this.isAnySplitOrJoin() || this == PROCESS_CREATION || this == PROCESS_NOTIFICATION || this == CONDITIONAL || this == GROUP || this == NOTIFICATION_WAIT;
    }

    public boolean canBeStatic() {
        return this != SUBFLOW && this != PROCESS_CREATION && this != TERMINATION_WAIT && this != PROCESS_NOTIFICATION && this != NOTIFICATION_WAIT && this != INTERRUPTION && !this.isAnySplitOrJoin();
    }

    public boolean canEditArguments() {
        return this != GLOBAL_CREATION && this != SUBFLOW && this != PROCESS_CREATION && this != TERMINATION_WAIT && this != PROCESS_NOTIFICATION && !this.isAnySplitOrJoin();
    }

    public boolean isAllowedInScopes() {
        return this != BEGIN && this != END && !this.isAnyGlobal();
    }

    public boolean canReceiveMessages() {
        return this.isBegin() || this == NOTIFICATION_WAIT || this == INTERRUPTION;
    }

    public boolean isMeasurementMark() {
        return this == MEASUREMENT || this == MEASUREMENT_START || this == MEASUREMENT_STOP;
    }

    public boolean isInteractive() {
        return this == INTERACTIVE;
    }

    public boolean isCompensate() {
        return this == COMPENSATE;
    }

    public boolean isTimer() {
        return this == TIMER;
    }

    public boolean isInteractiveComponentCall() {
        return this == INTERACTIVE_COMPONENT_CALL;
    }

    public boolean isAutomatic() {
        return this == AUTOMATIC;
    }

    public boolean isDecision() {
        return this == DECISION;
    }

    public boolean isOrSplit() {
        return this == OR_SPLIT;
    }

    private Object readResolve() {
        return ActivityType.valueOf(this.ordinal());
    }
}

