/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.pool.Cache;
import oracle.bpm.pool.CacheStatistic;
import oracle.bpm.pool.DefaultCacheStatistic;
import oracle.bpm.pool.DummyCacheStatistic;
import oracle.bpm.pool.Factory;
import oracle.bpm.pool.LockOwner;
import oracle.bpm.pool.NoDisposableEntriesException;

public class TimedMultiValuatedCache<K, V>
extends HashMap<K, Integer>
implements Cache<K, V> {
    protected CacheStatistic cacheStatistic_d;
    protected int capacity_d;
    protected int clock_d = 0;
    protected Entry<K, V>[] elements_d;
    protected int entryCapacity_d;
    protected int lockCount_d = 0;
    protected int minNoDisposableEntries_d;
    protected boolean waitForConnections_d;
    private Factory<V> factory_d;
    private HashMap<V, Point> locked_d;
    private int maxRetries_d;
    private boolean multipleLocks_d;
    private LowResolutionTimer timer_d;
    private int timeToLive_d;
    private long waitTimeout_d;
    static final long serialVersionUID = 1150431899968852950L;
    static final long serialCheck = -6014610582699381695L;

    public TimedMultiValuatedCache(Factory<V> f, int c, int ec, int timeToLive, int minNoDisposable, boolean waitForConnections, int maxRetries, long waitTimeout) {
        this(f, c, ec, timeToLive, minNoDisposable, waitForConnections, maxRetries, waitTimeout, true);
    }

    public TimedMultiValuatedCache(Factory<V> f, int c, int ec, int timeToLive, int minNoDisposable, boolean waitForConnections, int maxRetries, long waitTimeout, boolean multipleLocks) {
        this(f, c, ec, timeToLive, minNoDisposable, waitForConnections, maxRetries, waitTimeout, multipleLocks, true);
    }

    public TimedMultiValuatedCache(Factory<V> f, int c, int ec, int timeToLive, int minNoDisposable, boolean waitForConnections, int maxRetries, long waitTimeout, boolean multipleLocks, boolean useStatistics) {
        super(c);
        if (f == null) {
            throw new NullPointerException("Factory");
        }
        this.elements_d = (Entry[])Cast.force(new Entry[c]);
        for (int i = 0; i < c; ++i) {
            this.elements_d[i] = new Entry(ec);
            this.elements_d[i].setIndex(i);
        }
        this.timeToLive_d = timeToLive;
        this.capacity_d = c;
        this.entryCapacity_d = ec;
        this.factory_d = f;
        this.minNoDisposableEntries_d = minNoDisposable;
        this.locked_d = new HashMap();
        this.waitForConnections_d = waitForConnections;
        this.maxRetries_d = maxRetries;
        this.waitTimeout_d = waitTimeout;
        this.multipleLocks_d = multipleLocks;
        this.cacheStatistic_d = useStatistics ? new DefaultCacheStatistic(c, ec, timeToLive, minNoDisposable, this.elements_d) : new DummyCacheStatistic();
        if (this.timeToLive_d > 0) {
            this.timer_d = new LowResolutionTimer(this.timeToLive_d * 60);
            this.timer_d.add(new Disposer());
            this.timer_d.start();
        }
    }

    public int getTimeToLive_d() {
        return this.timeToLive_d;
    }

    @Override
    public int getCapacity() {
        return this.capacity_d;
    }

    public Entry[] getElements() {
        return this.elements_d;
    }

    public int getEntryCapacity() {
        return this.entryCapacity_d;
    }

    public synchronized boolean isInvalid(K key) {
        Entry<K, V> entry = this.getEntry(key, false);
        return entry != null && entry.isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getLocked(K key, Properties connectionProperties, LockOwner owner) {
        assert (key != null) : "The keys in the cache cannot be null";
        assert (owner != null) : "The owner in the cache cannot be null";
        Object result = null;
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            Entry<K, V> entry = this.getEntry(key, true);
            if (entry == null) {
                return null;
            }
            assert (entry.getKey().equals(key)) : "The key the cache returned does not match";
            int freeSlot = -1;
            int lockedSlot = -1;
            int emptySlot = -1;
            Integer temp = (Integer)((Entry)entry).owners_d.get(owner);
            if (temp != null) {
                lockedSlot = temp;
            } else if (!((Entry)entry).free_d.isEmpty()) {
                temp = (Integer)((Entry)entry).free_d.first();
                freeSlot = temp;
            } else if (!((Entry)entry).empty_d.isEmpty()) {
                temp = (Integer)((Entry)entry).empty_d.first();
                emptySlot = temp;
            }
            if (lockedSlot < 0 && freeSlot < 0 && emptySlot < 0) {
                if (!this.waitForConnections_d) {
                    int retries = 0;
                    do {
                        try {
                            this.wait(this.getWaitTimeout());
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (!((Entry)entry).free_d.isEmpty()) {
                            temp = (Integer)((Entry)entry).free_d.first();
                            freeSlot = temp;
                            continue;
                        }
                        if (((Entry)entry).empty_d.isEmpty()) continue;
                        temp = (Integer)((Entry)entry).empty_d.first();
                        emptySlot = temp;
                    } while (++retries < this.getMaxRetries() && freeSlot < 0 && emptySlot < 0);
                    if (lockedSlot < 0 && freeSlot < 0 && emptySlot < 0) {
                        this.cacheStatistic_d.noDisposableEntries();
                        throw new NoDisposableEntriesException();
                    }
                } else {
                    do {
                        try {
                            this.cacheStatistic_d.incrementWaitQueueSize();
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        this.cacheStatistic_d.decrementWaitQueueSize();
                        if (!((Entry)entry).free_d.isEmpty()) {
                            temp = (Integer)((Entry)entry).free_d.first();
                            freeSlot = temp;
                            continue;
                        }
                        if (((Entry)entry).empty_d.isEmpty()) continue;
                        temp = (Integer)((Entry)entry).empty_d.first();
                        emptySlot = temp;
                    } while (freeSlot < 0 && emptySlot < 0);
                }
            }
            if (lockedSlot >= 0) {
                entry.getValues()[lockedSlot].increaseLockCount();
                result = entry.getValues()[lockedSlot].getValue();
                entry.getValues()[lockedSlot].shouldKeepIt(true);
                this.cacheStatistic_d.hit(1, owner);
            } else {
                this.cacheStatistic_d.newLock();
                if (freeSlot >= 0) {
                    entry.getValues()[freeSlot].setLocker(owner);
                    result = entry.getValues()[freeSlot].getValue();
                    this.cacheStatistic_d.hit(0, owner);
                    ((Entry)entry).free_d.remove(temp);
                    ((Entry)entry).owners_d.put(owner, temp);
                } else if (emptySlot >= 0) {
                    int valueCount = entry.getValueCount();
                    entry.getValues()[emptySlot].setValue(this.createEntry(connectionProperties));
                    entry.getValues()[emptySlot].setLocker(owner);
                    result = entry.getValues()[emptySlot].getValue();
                    entry.incrementValueCount();
                    freeSlot = emptySlot;
                    this.cacheStatistic_d.miss(owner);
                    if (valueCount == 0) {
                        this.cacheStatistic_d.addDistinctConnection();
                    }
                    ((Entry)entry).empty_d.remove(temp);
                    ((Entry)entry).owners_d.put(owner, temp);
                }
                entry.getValues()[freeSlot].setLockCount(1);
                entry.getValues()[freeSlot].shouldKeepIt(true);
                if (((Entry)entry).lockCount_d == 0) {
                    ++this.lockCount_d;
                }
                ((Entry)entry).lockCount_d++;
                Point point = new Point(entry.getIndex(), freeSlot);
                this.locked_d.put((Point)result, point);
            }
            if (result != null) {
                this.cacheStatistic_d.lock(result, owner);
            }
        }
        return (V)result;
    }

    @Override
    public synchronized boolean isLocked(K key) {
        Entry<K, V> entry = this.getEntry(key, false);
        return entry != null && ((Entry)entry).lockCount_d > 0;
    }

    @Override
    public synchronized boolean isLocked(K key, LockOwner locker) {
        Entry<K, V> entry = this.getEntry(key, false);
        if (entry != null) {
            for (int i = 0; i < entry.getValues().length; ++i) {
                if (entry.getValues()[i].getLocker() == null || !entry.getValues()[i].getLocker().isEqualTo(locker)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public LockOwner getLocker(K key) {
        throw new UnsupportedOperationException("One key can have more than one locker !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockOwner[] getLockers(K key) {
        ArrayList<LockOwner> list = new ArrayList<LockOwner>();
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            Entry<K, V> entry = this.getEntry(key, false);
            if (entry != null) {
                for (int i = 0; i < entry.getValues().length; ++i) {
                    if (entry.getValues()[i].getLocker() == null) continue;
                    list.add(entry.getValues()[i].getLocker());
                }
            }
        }
        return list.toArray(new LockOwner[list.size()]);
    }

    public int getMaxRetries() {
        return this.maxRetries_d;
    }

    public int getMinNoDisposableEntries() {
        return this.minNoDisposableEntries_d;
    }

    @Override
    public CacheStatistic getStatistics() {
        return this.cacheStatistic_d;
    }

    public long getWaitTimeout() {
        return this.waitTimeout_d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            for (int i = 0; i < this.capacity_d; ++i) {
                if (this.elements_d[i].getLockCount() > 0) {
                    String lockers = "";
                    for (int j = 0; j < this.elements_d[i].getValues().length; ++j) {
                        if (this.elements_d[i].getValues()[j].getLocker() == null) continue;
                        lockers = lockers + "[" + this.elements_d[i].getValues()[j].getLocker().getInfo() + "]\n";
                    }
                    throw new IllegalStateException("Locked entries\n" + lockers);
                }
                this.disposeEntry(this.elements_d[i]);
                this.elements_d[i].setUsageCount(0);
            }
            super.clear();
        }
        this.cacheStatistic_d.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            for (int i = 0; i < this.capacity_d; ++i) {
                for (int j = 0; j < this.entryCapacity_d; ++j) {
                    if (!this.elements_d[i].getValues()[j].getValue().equals(value)) continue;
                    this.elements_d[i].getValues()[j].shouldKeepIt(true);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, Integer>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public Integer get(Object key) {
        throw new UnsupportedOperationException("Locker information is required to get an entry");
    }

    @Override
    public synchronized V get(K key, LockOwner owner) {
        Entry<K, V> entry = this.getEntry(key, false);
        if (entry != null) {
            for (EntryValue aValue : ((Entry)entry).values_d) {
                if (aValue.locker_d == null || !aValue.locker_d.isEqualTo(owner)) continue;
                this.cacheStatistic_d.hit(1, owner);
                return (V)aValue.value_d;
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public synchronized void invalidate(K key) {
        Entry<K, V> entry = this.getEntry(key, false);
        if (entry != null) {
            entry.invalidate();
            for (int i = 0; i < entry.getValues().length; ++i) {
                if (entry.getValues()[i].getValue() == null || entry.getValues()[i].getLocker() != null) continue;
                this.disposeValue(entry.getValues()[i].getValue());
                ((Entry)entry).free_d.remove(i);
                ((Entry)entry).empty_d.add(i);
                entry.getValues()[i].setValue(null);
                entry.decrementValueCount();
                if (entry.getValueCount() != 0) continue;
                this.cacheStatistic_d.subDistinctConnection();
            }
        }
    }

    @Override
    public V putLocked(K key, V value, LockOwner owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer put(K key, Integer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized V putValue(K key, V value) {
        Entry<K, V> entry = this.getEntry(key, true);
        if (entry != null) {
            if (entry.getValueCount() > 0) {
                return null;
            }
            int valueCount = entry.getValueCount();
            for (int i = 0; i < ((Entry)entry).values_d.length; ++i) {
                if (((Entry)entry).values_d[i].getValue() != null) continue;
                ((Entry)entry).values_d[i].setValue(value);
                ((Entry)entry).values_d[i].setLocker(null);
                ((Entry)entry).values_d[i].setLockCount(0);
                entry.incrementValueCount();
                this.cacheStatistic_d.miss();
                this.cacheStatistic_d.create();
                if (valueCount == 0) {
                    this.cacheStatistic_d.addDistinctConnection();
                }
                Integer index = i;
                ((Entry)entry).free_d.add(index);
                ((Entry)entry).empty_d.remove(index);
                return value;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer remove(Object key) {
        Object k = null;
        k = Cast.forceTo(k, key);
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            Object index = super.get(k);
            if (index != null) {
                int n = ((Number)index).intValue();
                if (((Entry)this.elements_d[n]).lockCount_d > 0) {
                    throw new IllegalStateException("Locked entries");
                }
                int size = this.elements_d[n].getValueCount();
                this.disposeEntry(this.elements_d[n]);
                super.remove(k);
                this.cacheStatistic_d.dispose(2, size);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(V value) {
        if (value == null) {
            return;
        }
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            Entry<K, V> entry = null;
            EntryValue<V> entryValue = null;
            boolean j = false;
            int index = -1;
            Point point = this.locked_d.get(value);
            if (point != null) {
                entry = this.elements_d[point.i];
                entryValue = this.elements_d[point.i].getValues()[point.j];
                index = point.j;
            }
            if (entryValue != null && entryValue.getLocker() != null) {
                this.cacheStatistic_d.unlock(value, entryValue.getLocker());
                entryValue.shouldKeepIt(true);
                entryValue.decreaseLockCount();
                if (entryValue.getLockCount() == 0) {
                    ((Entry)entry).owners_d.remove(entryValue.getLocker());
                    ((Entry)entry).free_d.add(index);
                    ((Entry)entry).lockCount_d--;
                    entryValue.setLocker(null);
                    this.cacheStatistic_d.removeLock();
                    if (entry.isInvalid()) {
                        int valueCount = entry.getValueCount();
                        this.disposeValue(entryValue.getValue());
                        ((Entry)entry).free_d.remove(index);
                        ((Entry)entry).empty_d.add(index);
                        entry.getValues()[0].setValue(null);
                        entry.decrementValueCount();
                        if (valueCount > 0 && entry.getValueCount() == 0) {
                            this.cacheStatistic_d.subDistinctConnection();
                        }
                        this.cacheStatistic_d.dispose(2);
                    }
                }
                if (((Entry)entry).lockCount_d == 0) {
                    --this.lockCount_d;
                    if (entry.isInvalid()) {
                        super.remove(entry.getKey());
                        this.disposeEntry(entry);
                    }
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<V> getValues() {
        Vector<V> values = new Vector<V>();
        TimedMultiValuatedCache timedMultiValuatedCache = this;
        synchronized (timedMultiValuatedCache) {
            for (int i = 0; i < this.capacity_d; ++i) {
                for (int j = 0; j < this.entryCapacity_d; ++j) {
                    if (this.elements_d[i].getValues()[j].getValue() == null) continue;
                    values.addElement(this.elements_d[i].getValues()[j].getValue());
                }
            }
        }
        return values;
    }

    @Override
    public Collection<Integer> values() {
        throw new UnsupportedOperationException();
    }

    protected LowResolutionTimer getTimer() {
        return this.timer_d;
    }

    protected synchronized Entry<K, V> getEntry(K key, boolean create) {
        Integer index = (Integer)super.get(key);
        int n = -1;
        if (index != null) {
            n = index;
        } else {
            if (!create) {
                return null;
            }
            int retries = 0;
            do {
                for (int i = 0; i < this.capacity_d; ++i) {
                    if (this.elements_d[i].getValueCount() != 0) continue;
                    n = i;
                    break;
                }
                if (n == -1 && this.lockCount_d < this.capacity_d) {
                    while (this.elements_d[this.clock_d].getUsageCount() > 0 || ((Entry)this.elements_d[this.clock_d]).lockCount_d > 0) {
                        if (((Entry)this.elements_d[this.clock_d]).lockCount_d == 0) {
                            this.elements_d[this.clock_d].decrementUsageCount();
                        }
                        ++this.clock_d;
                        this.clock_d %= this.capacity_d;
                    }
                    this.cacheStatistic_d.dispose(0, this.elements_d[this.clock_d].getValueCount());
                    n = this.clock_d;
                }
                if (n >= 0) {
                    if (this.elements_d[n].getKey() != null) {
                        Object removed = super.remove(this.elements_d[n].getKey());
                        assert (removed != null) : "TRYING TO REMOVE A KEY THAT IS NOT IN THE HASH";
                        this.disposeEntry(this.elements_d[n]);
                    }
                    this.elements_d[n].setKey(key);
                    assert (!super.containsValue(this.elements_d[n].getIndex())) : "The hash already contains the index";
                    Integer old = super.put(key, this.elements_d[n].getIndex());
                    assert (old == null) : "The key is already present in the cache with another index";
                    continue;
                }
                try {
                    this.wait(this.getWaitTimeout());
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                index = (Integer)super.get(key);
                if (index == null) continue;
                n = index;
            } while (n < 0 && ++retries < this.getMaxRetries());
        }
        if (n >= 0) {
            assert (this.elements_d[n].getKey() != null) : "The cache entry must contain the key and it is null";
            assert (this.elements_d[n].getKey().equals(key)) : "The cache entry must contain the seach key and it different";
            this.elements_d[n].incrementUsageCount();
            return this.elements_d[n];
        }
        this.cacheStatistic_d.noDisposableEntries();
        throw new NoDisposableEntriesException();
    }

    private V createEntry(Properties connectionProperties) {
        if (this.factory_d != null) {
            V value = this.factory_d.create(connectionProperties);
            this.cacheStatistic_d.create();
            return value;
        }
        return null;
    }

    private synchronized void disposeEntry(Entry<K, V> entry) {
        int valueCount = entry.getValueCount();
        for (int i = 0; i < entry.getValues().length; ++i) {
            if (entry.getValues()[i].getValue() != null && this.factory_d != null) {
                this.factory_d.dispose(entry.getValues()[i].getValue());
            }
            entry.getValues()[i].setValue(null);
            entry.getValues()[i].setLocker(null);
            entry.getValues()[i].setLockCount(0);
            Integer index = i;
            ((Entry)entry).empty_d.add(index);
            ((Entry)entry).free_d.remove(index);
        }
        entry.setKey(null);
        if (((Entry)entry).lockCount_d > 0) {
            ((Entry)entry).lockCount_d = 0;
            --this.lockCount_d;
        }
        entry.setValueCount(0);
        entry.setUsageCount(0);
        ((Entry)entry).owners_d.clear();
        if (valueCount > 0) {
            this.cacheStatistic_d.subDistinctConnection();
        }
        entry.validate();
    }

    private boolean disposeValue(V value) {
        return this.factory_d == null || this.factory_d.dispose(value);
    }

    private boolean multipleLocks() {
        return this.multipleLocks_d;
    }

    private class Disposer
    implements LowResolutionTimerListener {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timerFired(LowResolutionTimer timer) {
            TimedMultiValuatedCache timedMultiValuatedCache = TimedMultiValuatedCache.this;
            synchronized (timedMultiValuatedCache) {
                for (Entry anElement : TimedMultiValuatedCache.this.elements_d) {
                    boolean canDispose = anElement.getValueCount() > TimedMultiValuatedCache.this.getMinNoDisposableEntries();
                    for (int j = 0; j < anElement.values_d.length && canDispose; ++j) {
                        if (anElement.values_d[j].getValue() == null) continue;
                        if (anElement.values_d[j].getLocker() == null && !anElement.values_d[j].keepIt_d) {
                            TimedMultiValuatedCache.this.disposeValue(anElement.values_d[j].getValue());
                            TimedMultiValuatedCache.this.cacheStatistic_d.dispose(1);
                            anElement.values_d[j].setValue(null);
                            anElement.decrementValueCount();
                            if (anElement.getValueCount() == 0) {
                                TimedMultiValuatedCache.this.cacheStatistic_d.subDistinctConnection();
                            }
                            Integer index = j;
                            anElement.free_d.remove(index);
                            anElement.empty_d.add(index);
                            continue;
                        }
                        if (!anElement.values_d[j].keepIt_d || anElement.values_d[j].getLocker() != null) continue;
                        anElement.values_d[j].shouldKeepIt(false);
                    }
                }
            }
        }
    }

    private static class Point {
        int i;
        int j;

        public Point(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    protected class EntryValue<V> {
        private boolean keepIt_d;
        private int lockCount_d = 0;
        private LockOwner locker_d;
        private V value_d;

        protected EntryValue() {
        }

        protected boolean isEmpty() {
            return this.getValue() == null;
        }

        protected void setLockCount(int count) {
            this.lockCount_d = count;
        }

        protected int getLockCount() {
            return this.lockCount_d;
        }

        protected void setLocker(LockOwner locker) {
            this.locker_d = locker;
        }

        protected LockOwner getLocker() {
            return this.locker_d;
        }

        protected void setValue(V value) {
            this.value_d = value;
        }

        protected V getValue() {
            return this.value_d;
        }

        protected void decreaseLockCount() {
            if (!TimedMultiValuatedCache.this.multipleLocks()) {
                assert (this.lockCount_d == 1) : "Lock count must be 1 in single lock mode";
            } else assert (this.lockCount_d > 0) : "Lock count must be greater than 0 in multi lock mode";
            --this.lockCount_d;
        }

        protected void increaseLockCount() {
            if (this.lockCount_d == 0 || TimedMultiValuatedCache.this.multipleLocks()) {
                ++this.lockCount_d;
            }
        }

        protected boolean shouldKeepIt() {
            return this.keepIt_d;
        }

        protected void shouldKeepIt(boolean keepIt) {
            this.keepIt_d = keepIt;
        }
    }

    protected class Entry<K, V>
    implements Map.Entry<K, V> {
        private TreeSet<Integer> empty_d = new TreeSet();
        private TreeSet<Integer> free_d = new TreeSet();
        private Integer index_d;
        private boolean invalid_d = false;
        private K key_d;
        private int lockCount_d = 0;
        private HashMap<LockOwner, Integer> owners_d = new HashMap();
        private int usageCount_d;
        private int valueCount_d = 0;
        private EntryValue<V>[] values_d;

        public Entry(int c) {
            this.values_d = (EntryValue[])Cast.force(new EntryValue[c]);
            for (int i = 0; i < c; ++i) {
                this.values_d[i] = new EntryValue();
                this.empty_d.add(i);
            }
            this.valueCount_d = 0;
        }

        public void setIndex(Integer index) {
            this.index_d = index;
        }

        public Integer getIndex() {
            return this.index_d;
        }

        public boolean isInvalid() {
            return this.invalid_d;
        }

        public void setKey(K key) {
            this.key_d = key;
        }

        @Override
        public K getKey() {
            return this.key_d;
        }

        public void setLockCount(int lockCount) {
            this.lockCount_d = lockCount;
        }

        public int getLockCount() {
            return this.lockCount_d;
        }

        public void setUsageCount(int usageCount) {
            this.usageCount_d = usageCount;
        }

        public int getUsageCount() {
            return this.usageCount_d;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getValue() {
            throw new UnsupportedOperationException();
        }

        public void setValueCount(int valueCount) {
            this.valueCount_d = valueCount;
        }

        public int getValueCount() {
            return this.valueCount_d;
        }

        public void setValues(EntryValue<V>[] values) {
            this.values_d = values;
        }

        public EntryValue<V>[] getValues() {
            return this.values_d;
        }

        public void invalidate() {
            this.invalid_d = true;
        }

        public int size() {
            int answer = 0;
            for (int i = 0; i < this.getValues().length; ++i) {
                if (this.getValues()[i].isEmpty()) continue;
                ++answer;
            }
            return answer;
        }

        public void validate() {
            this.invalid_d = false;
        }

        protected void decrementLockCount() {
            --this.lockCount_d;
        }

        protected void decrementUsageCount() {
            --this.usageCount_d;
        }

        protected void decrementValueCount() {
            --this.valueCount_d;
        }

        protected void incrementLockCount() {
            ++this.lockCount_d;
        }

        protected void incrementUsageCount() {
            ++this.usageCount_d;
        }

        protected void incrementValueCount() {
            ++this.valueCount_d;
        }
    }
}

