/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.pool;

import java.util.Map;
import java.util.Properties;
import oracle.bpm.pool.CacheStatistic;
import oracle.bpm.pool.LockOwner;
import org.jetbrains.annotations.NonNls;

public interface Cache<K, V>
extends Map<K, Integer> {
    public static final int DEFAULT_TIMEOUT = 5;
    @NonNls
    public static final String INITIAL_KEY = "fuego.cache.initial_key";
    public static final int MAX_DEFAULT_SIZE = 10;
    public static final int MAX_ENTRY_DEFAULT_SIZE = 10;
    @NonNls
    public static final String MAX_ENTRY_SIZE = "fuego.cache.maxentrysize";
    @NonNls
    public static final String MAX_RETRIES = "fuego.cache.maxretries";
    public static final int MAX_RETRIES_DEFAULT = 5;
    @NonNls
    public static final String MAX_SIZE = "fuego.cache.maxsize";
    public static final int MIN_DEFAULT_SIZE = 0;
    @NonNls
    public static final String MIN_NO_DISPOSABLE = "fuego.cache.minnodisposable";
    public static final int MIN_NO_DISPOSABLE_DEFAULT = 0;
    @NonNls
    public static final String MIN_SIZE = "fuego.cache.minsize";
    @NonNls
    public static final String MULTIPLE_LOCKS = "fuego.cache.multiplelocks";
    public static final boolean MULTIPLE_LOCKS_DEFAULT = true;
    @NonNls
    public static final String POLICY = "fuego.cache.policy";
    @NonNls
    public static final String RETRY_TIMEOUT = "fuego.cache.retrytimeout";
    public static final long RETRY_TIMEOUT_DEFAULT = 500L;
    @NonNls
    public static final String STATISTICS_ENABLED = "fuego.cache.statistics";
    @NonNls
    public static final String STATISTICS_ENABLED_DEFAULT = Boolean.TRUE.toString();
    @NonNls
    public static final String TIMEOUT = "fuego.cache.timeout";
    @NonNls
    public static final String WAIT_FOR_LOCK = "fuego.cache.wait";
    public static final boolean WAIT_FOR_LOCK_DEFAULT = false;

    public int getCapacity();

    public V getLocked(K var1, Properties var2, LockOwner var3);

    public boolean isLocked(K var1);

    public boolean isLocked(K var1, LockOwner var2);

    public LockOwner getLocker(K var1);

    public CacheStatistic getStatistics();

    public V get(K var1, LockOwner var2);

    public void invalidate(K var1);

    public V putLocked(K var1, V var2, LockOwner var3);

    public V putValue(K var1, V var2);

    public void unlock(V var1);
}

