/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.oparser;

import oracle.bpm.lang.Cast;
import oracle.bpm.oparser.OptionParser;
import org.jetbrains.annotations.NonNls;

public class Option<T> {
    private String description;
    private char letter;
    private String name;
    private OptionParser optionParser;
    private Class<T> type;
    private T value;
    @NonNls
    static final String HELP = "help";

    Option(OptionParser optionParser, Class<T> type, char letter, String name, String description, T defaultValue) {
        this.optionParser = optionParser;
        this.letter = letter;
        this.name = name;
        this.type = type;
        this.description = description;
        this.value = defaultValue;
    }

    public char getLetter() {
        return this.letter;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public final T getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    void execute(boolean negated) {
        if (!negated && this.name.equals(HELP)) {
            this.optionParser.printHelp();
        }
        if (this.isBoolean()) {
            this.value = Cast.forceTo(this.value, !negated);
        }
    }

    void execute(boolean negated, String str) {
        if (this.isBoolean()) {
            Boolean b = Boolean.valueOf(str);
            if (negated) {
                b = b == false;
            }
            this.value = Cast.forceTo(this.value, b);
        } else {
            this.value = this.isInteger() ? Cast.forceTo(this.value, Integer.valueOf(str)) : Cast.forceTo(this.value, str);
        }
    }

    boolean isString() {
        return this.type == String.class;
    }

    boolean isBoolean() {
        return this.type == Boolean.class;
    }

    boolean isInteger() {
        return this.type == Integer.class;
    }
}

