/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TZTime;
import oracle.bpm.lang.TimeParser;
import oracle.bpm.lang.Week;
import oracle.bpm.msg.CoreMsg;
import org.jetbrains.annotations.NonNls;

@Component(module="Fuego.Lang")
public final class Time
implements Comparable<Time>,
Serializable {
    private final long microSeconds_d;
    private static final long M = 1000000L;
    @NonNls
    private static final String RETRYIN = "retryin:";
    @NonNls
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT+00:00");
    public static final int BC = 0;
    public static final int AD = 1;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int DEFAULT = 2;
    public static final int SHORT = 3;
    public static final int DATE_ONLY = 0;
    public static final int TIME_ONLY = 1;
    public static final int TIMESTAMP = 2;
    public static final int MONTH_DAY = 3;
    public static final int YEAR_MONTH = 4;
    static final long serialVersionUID = 8864100199815180311L;
    public static final Time MAX_VALUE = new Time(Long.MAX_VALUE);
    public static final Time MIN_VALUE = new Time(Long.MIN_VALUE);
    public static final Time EPOCH = new Time(0L);
    private static final ThreadLocal<CurrentTime> current = new ThreadLocal();
    private static final ThreadLocal<Locale> currentLocale = new ThreadLocal();
    private static final int EPOCH_YEAR = EPOCH.getYear();
    private static final int EPOCH_MONTH = EPOCH.getMonth();
    static final long serialCheck = -316977120821252817L;

    public Time() {
        this(System.currentTimeMillis() * 1000L);
    }

    @Deprecated
    @Exclude
    public Time(java.util.Date date) {
        this(date.getTime() * 1000L);
    }

    @Deprecated
    @Exclude
    public Time(Date date) {
        this((java.util.Date)date);
    }

    @Deprecated
    @Exclude
    public Time(java.sql.Time date) {
        this((java.util.Date)date);
    }

    @Deprecated
    @Exclude
    public Time(Timestamp date) {
        this(Time.calcMicroseconds(date));
    }

    public Time(int year, int month, int dayOfMonth) {
        this.microSeconds_d = Time.calcMicroseconds(year, month, dayOfMonth, 0, 0, 0, 0);
    }

    Time(long microseconds) {
        this.microSeconds_d = microseconds;
    }

    public static Time add(Time time, Interval interval) {
        return time == null ? EPOCH : (interval == null ? time : interval.add(time));
    }

    public static int compare(Time a, Time b) {
        long bVal;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        long aVal = a.getMicroSeconds();
        return aVal < (bVal = b.getMicroSeconds()) ? -1 : (aVal == bVal ? 0 : 1);
    }

    public static Time day(Time t, int day) {
        return t.getDay() == day ? t : Time.valueOf(t.getYear(), t.getMonth(), day, t.getHourOfDay(), t.getMinute(), t.getSecond(), t.getMicroSecond());
    }

    @Exclude
    public static boolean equals(Time a, Time b) {
        return a == b || a != null && b != null && a.getMicroSeconds() == b.getMicroSeconds();
    }

    public static String format(Time time) {
        return time == null ? "null" : time.format();
    }

    public static Time fromGMT(Time value) {
        return value == null ? null : value.fromGMT();
    }

    public static DateFormat getDateFormat(int parts, int style) {
        return Time.getDateFormat(parts, style, Locale.getDefault());
    }

    public static DateFormat getDateFormat(int parts, int style, Locale locale) {
        switch (parts) {
            case 1: {
                return DateFormat.getTimeInstance(style, locale);
            }
            case 0: {
                return DateFormat.getDateInstance(style, locale);
            }
        }
        return DateFormat.getDateTimeInstance(style, style, locale);
    }

    public static Time getEaster(int y) {
        int n;
        int g = y % 19 + 1;
        int c = y / 100 + 1;
        int x = 3 * c / 4 - 12;
        int z = (8 * c + 5) / 25 - 5;
        int d = 5 * y / 4 - x - 10;
        int e = (11 * g + 20 + z - x) % 30;
        if (e == 25 && g > 11 || e == 24) {
            ++e;
        }
        if ((n = 44 - e) < 21) {
            n += 30;
        }
        int day = n = n + 7 - (d + n) % 7;
        int month = 3;
        if (n > 31) {
            day = n - 31;
            month = 4;
        }
        return Time.valueOf(y, month, day, 0, 0, 0);
    }

    public static String getMonthName(int monthNum) {
        return MonthNames.values[monthNum - 1];
    }

    public static String getWeekdayName(int dayNum) {
        return WeekdayNames.values[dayNum + 1];
    }

    @Hidden
    public static Time hour(Time t, int hour) {
        if (hour < 0 || hour > 11) {
            throw new IllegalArgumentException("Hour: " + hour);
        }
        boolean am = t.isAm();
        return Time.hourOfDay(t, am ? hour : hour + 12);
    }

    @Hidden
    public static Time hourOfDay(Time t, int hour) {
        return Time.valueOf(t.getYear(), t.getMonth(), t.getDay(), hour, t.getMinute(), t.getSecond(), t.getMicroSecond());
    }

    @Hidden
    public static Time minute(Time t, int minute) {
        return Time.valueOf(t.getYear(), t.getMonth(), t.getDay(), t.getHourOfDay(), minute, t.getSecond(), t.getMicroSecond());
    }

    @Hidden
    public static Time month(Time t, int month) {
        return Time.valueOf(t.getYear(), month, t.getDay(), t.getHourOfDay(), t.getMinute(), t.getSecond(), t.getMicroSecond());
    }

    public static Time now() {
        return Time.valueOf(System.currentTimeMillis() * 1000L);
    }

    @Hidden
    public static Time nowSeconds() {
        return Time.now().roundToSeconds();
    }

    @Hidden
    public static Time parseFrom(String val) {
        return Time.parseFrom(val, "yyyyMMddHHmmssz");
    }

    @Hidden
    public static Time parseFrom(String val, @NonNls String mask) {
        SimpleDateFormat formatter = new SimpleDateFormat(mask, Time.getLocale());
        try {
            java.util.Date dateVal = formatter.parse(val);
            return Time.valueOf(dateVal);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Hidden
    public static Time second(Time t, int second) {
        return Time.valueOf(t.getYear(), t.getMonth(), t.getDay(), t.getHourOfDay(), t.getMinute(), second, t.getMicroSecond());
    }

    public static void setLocale(Locale locale) {
        currentLocale.set(locale);
    }

    public static void setTimeZone(TimeZone tz) {
        Calendar cal = EPOCH.getCalendar();
        cal.setTimeZone(tz);
    }

    public static TimeZone getTimeZone() {
        return EPOCH.getCalendar().getTimeZone();
    }

    public static Interval sub(Time a, Time b) {
        return Interval.valueOf(a, b);
    }

    public static Time sub(Time time, Interval interval) {
        return time == null ? EPOCH : (interval == null ? time : interval.subFrom(time));
    }

    public static Time toGMT(Time value) {
        return value == null ? null : value.toGMT();
    }

    @Method(parameters={"ms"})
    public static Time valueOf(BigDecimal microseconds) {
        return microseconds == null ? null : Time.valueOf(microseconds.longValue());
    }

    @Method(parameters={"ms"})
    public static Time valueOf(double microseconds) {
        return Time.valueOf((long)microseconds);
    }

    @Method(parameters={"ms"})
    public static Time valueOf(long microseconds) {
        if (microseconds == 0L) {
            return EPOCH;
        }
        return new Time(microseconds);
    }

    public static Time valueOf(Calendar calendar) {
        return calendar == null ? null : Time.valueOf(calendar.getTimeInMillis() * 1000L);
    }

    public static Time valueOf(String text) throws FormatException {
        TZTime tzTime = Time.parseTZ(text);
        return tzTime == null ? null : tzTime.getTime();
    }

    @Exclude
    public static Time valueOf(java.util.Date val) {
        return val == null ? null : Time.valueOf(val.getTime() * 1000L);
    }

    @Exclude
    public static Time valueOf(java.sql.Time val) {
        return Time.valueOf((java.util.Date)val);
    }

    @Exclude
    public static Time valueOf(Timestamp val) {
        Time result = val == null ? null : Time.valueOf(Time.calcMicroseconds(val));
        return result;
    }

    public static Time valueOf(Interval when) {
        return new Time(when.getTotalMicroseconds());
    }

    public static Time valueOf(Object value) {
        if (value == null || value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof Timestamp) {
            return Time.valueOf((Timestamp)value);
        }
        if (value instanceof java.util.Date) {
            return Time.valueOf((java.util.Date)value);
        }
        if (value instanceof Number) {
            return Time.valueOf((Number)value);
        }
        if (value instanceof Interval) {
            return Time.valueOf(((Interval)value).getTotalMicroseconds());
        }
        if (value instanceof String) {
            return Time.valueOf((String)value);
        }
        if (value instanceof Calendar) {
            return Time.valueOf((Calendar)value);
        }
        if (value instanceof byte[]) {
            return Time.valueOf(Binary.deserialize((byte[])value));
        }
        throw new IllegalConversionException(value, "Time");
    }

    public static Time valueOf(Number value) {
        return value == null ? null : Time.valueOf(value.longValue());
    }

    public static Time valueOf(int hour, int minute) throws IllegalArgumentException {
        return Time.valueOf(hour, minute, 0, 0);
    }

    public static Time valueOf(int hour, int minute, int second) throws IllegalArgumentException {
        return Time.valueOf(hour, minute, second, 0);
    }

    public static Time valueOf(int year, Month month, int day) {
        return Time.valueOf(year, month.intValue(), day, 0, 0, 0, 0);
    }

    public static Time valueOf(int hour, int minute, int second, int microSecond) throws IllegalArgumentException {
        return Time.valueOf((long)((hour * 60 + minute) * 60 + second) * 1000000L + (long)microSecond).fromGMT();
    }

    public static Time valueOf(Day day, Week week, Month month, int year) {
        GregorianCalendar cal = new GregorianCalendar(year, month.intValue() - 1, 1);
        int dayOfWeek = cal.get(7) - 1;
        int dayOfMonth = 1 + day.intValue() - dayOfWeek;
        if (dayOfMonth <= 0) {
            dayOfMonth += 7;
        }
        dayOfMonth += (week.intValue() - 1) * 7;
        while (dayOfMonth > month.days(year)) {
            dayOfMonth -= 7;
        }
        return new Time(year, month.intValue(), dayOfMonth);
    }

    public static Time valueOf(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second) throws IllegalArgumentException {
        return Time.valueOf(year, month, dayOfMonth, hourOfDay, minute, second, 0);
    }

    public static Time valueOf(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int microSecond) throws IllegalArgumentException {
        return Time.valueOf(Time.calcMicroseconds(year, month, dayOfMonth, hourOfDay, minute, second, microSecond));
    }

    @Hidden
    public static Time year(Time t, int year) {
        return Time.valueOf(year, t.getMonth(), t.getDay(), t.getHourOfDay(), t.getMinute(), t.getSecond(), t.getMicroSecond());
    }

    public Time getDatePart() {
        return Time.valueOf(this.getYear(), Month.valueOf(this.getMonth()), this.getDay());
    }

    public Time add(Interval interval) {
        return interval == null ? this : interval.add(this);
    }

    public Time addDays(int i) {
        Time result;
        Calendar calendar = this.getCalendar();
        int microOffset = (int)(this.microSeconds_d - calendar.getTimeInMillis() * 1000L);
        calendar.add(5, i);
        Time.getCurrentTime().time = result = new Time(calendar.getTimeInMillis() * 1000L + (long)microOffset);
        return result;
    }

    public Time addHours(long i) {
        return Time.valueOf(this.getMicroSeconds() + i * 3600000000L);
    }

    public Time addMicroSeconds(long i) {
        return Time.valueOf(this.getMicroSeconds() + i);
    }

    public Time addMilliSeconds(long i) {
        return Time.valueOf(this.getMicroSeconds() + i * 1000L);
    }

    public Time addMinutes(long i) {
        return Time.valueOf(this.getMicroSeconds() + i * 60L * 1000000L);
    }

    public Time addMonths(int i) {
        Time t;
        int year = this.getYear();
        int month = this.getMonth() - 1;
        int day = this.getDayOfMonth();
        int hour = this.getHourOfDay();
        int minute = this.getMinute();
        int second = this.getSecond();
        int microSecond = this.getMicroSecond();
        year += (month + i) / 12;
        if ((month = (month + i) % 12) < 0) {
            month += 12;
            --year;
        }
        ++month;
        ++day;
        while ((t = Time.valueOf(year, month, --day, hour, minute, second, microSecond)).getDayOfMonth() != day) {
        }
        return t;
    }

    public Time addSeconds(long i) {
        return Time.valueOf(this.getMicroSeconds() + i * 1000000L);
    }

    public Time addWeeks(int weeks) {
        return this.addDays(weeks * 7);
    }

    public Time addYears(int i) {
        return this.addMonths(i * 12);
    }

    public boolean between(Time from, Time to) {
        return Time.compare(this, from) >= 0 && (to == null || Time.compare(to, this) >= 0);
    }

    @Override
    @Hidden
    public int compareTo(Time t) {
        return Time.compare(this, t);
    }

    public java.util.Date dateValue() {
        long us = this.getMicroSeconds();
        return new java.util.Date((us < 0L ? us - 999L : us) / 1000L);
    }

    public int daysSince(Time t) {
        return this.sub(t).getDays();
    }

    public boolean equals(Object o) {
        return o instanceof Time && this.getMicroSeconds() == ((Time)o).getMicroSeconds();
    }

    public String format() {
        return this.format(DateFormat.getDateTimeInstance(2, 2, Time.getLocale()));
    }

    public String format(DateFormat formatter) {
        formatter.setCalendar(this.getCalendar());
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String format(TimeZone timeZone) {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2);
        formatter.setCalendar(Calendar.getInstance(timeZone));
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String format(String mask) {
        SimpleDateFormat formatter = new SimpleDateFormat(mask, Time.getLocale());
        return this.format(formatter);
    }

    public String format(TimeZone timeZone, Locale locale) {
        DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, locale);
        formatter.setTimeZone(timeZone);
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String format(String mask, TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(mask, Time.getLocale());
        formatter.setCalendar(Calendar.getInstance(timeZone, Time.getLocale()));
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String format(int dateStyle, int timeStyle) {
        return this.format(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Time.getLocale()));
    }

    public String format(DateFormat formatter, TimeZone timeZone) {
        formatter.setTimeZone(timeZone);
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String format(String mask, TimeZone timeZone, Locale locale) {
        SimpleDateFormat formatter = new SimpleDateFormat(mask, locale);
        formatter.setCalendar(Calendar.getInstance(timeZone, locale));
        return formatter.format(new java.util.Date(this.dateValue().getTime()));
    }

    public String formatDate() {
        return this.format(DateFormat.getDateInstance(2, Time.getLocale()));
    }

    public String formatDate(int dateStyle) {
        return this.format(DateFormat.getDateInstance(dateStyle, Time.getLocale()));
    }

    @Hidden
    public String formatGMT(DateFormat formatter) {
        return this.format(formatter, GMT);
    }

    @Hidden
    public String formatGMT(String mask) {
        return this.formatGMT(new SimpleDateFormat(mask));
    }

    public String formatTime(int timeStyle) {
        return this.format(DateFormat.getTimeInstance(timeStyle, Time.getLocale()));
    }

    public String formatTimeOnly() {
        return this.formatTimeOnly(2);
    }

    public String formatTimeOnly(int intervalStyle) {
        long tm = this.microSeconds_d < 0L ? -this.microSeconds_d : this.microSeconds_d;
        long s = tm / 1000000L;
        int d = (int)(s / 86400L);
        int h = (int)((s -= (long)(d * 86400)) / 3600L);
        int m = (int)((s -= (long)(h * 3600)) / 60L);
        s -= (long)(m * 60);
        StringBuilder buff = new StringBuilder();
        switch (intervalStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.microSeconds_d < 0L) {
                    buff.append("- ");
                }
                if (d > 0) {
                    buff.append(d);
                    buff.append(CoreMsg.DAY_ABBREVIATION);
                    buff.append(' ');
                }
                Str.append(buff, h, 2, 10, '0');
                buff.append(':');
                Str.append(buff, m, 2, 10, '0');
                switch (intervalStyle) {
                    case 0: 
                    case 1: 
                    case 2: {
                        buff.append(':');
                        Str.append(buff, (int)s, 2, 10, '0');
                        break;
                    }
                }
                return buff.toString();
            }
        }
        return null;
    }

    public Time fromGMT() {
        Calendar cal = this.getCalendar();
        return Time.valueOf(this.microSeconds_d - (long)Time.timeZoneOffset(cal) * 1000L);
    }

    public int getAMPM() {
        return this.getCalendar().get(9);
    }

    public String getDate() {
        return this.formatDate();
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public int getDayOfMonth() {
        return this.getCalendar().get(5);
    }

    public int getDayOfWeek() {
        return this.getCalendar().get(7);
    }

    public int getDays() {
        return (int)(this.getMicroSeconds() / 86400000000L);
    }

    public Time getFirstDayOfMonth() {
        return Time.day(this, 1);
    }

    public int getHour() {
        return this.getCalendar().get(10);
    }

    public int getHourOfDay() {
        return this.getCalendar().get(11);
    }

    public int getHours() throws ArithmeticException {
        return this.safeScaleToInt(3600000000L);
    }

    public Time getLastDayOfMonth() {
        return this.addMonths(1).getFirstDayOfMonth().addDays(-1);
    }

    public int getMicroSecond() {
        int micro = (int)(this.microSeconds_d % 1000000L);
        return micro < 0 ? micro + 1000000 : micro;
    }

    public long getMicroSeconds() {
        return this.microSeconds_d;
    }

    public long getMilliSeconds() {
        return this.microSeconds_d / 1000L;
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getMinutes() throws ArithmeticException {
        return this.safeScaleToInt(60000000L);
    }

    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    public int getMonths() {
        return this.getYears() * 12 + this.getMonth() - EPOCH_MONTH;
    }

    public int getYears() {
        int year = this.getYear();
        if (year < 0) {
            ++year;
        }
        return year - EPOCH_YEAR;
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    @Deprecated
    @Exclude
    @Hidden
    public int getSeconds() throws ArithmeticException {
        return this.safeScaleToInt(1000000L);
    }

    @Method(name="seconds")
    public long getSecondsLong() {
        return this.getMicroSeconds() / 1000000L;
    }

    public String getTime() {
        return this.format(DateFormat.getTimeInstance(2, Time.getLocale()));
    }

    public int getTimeOnlyHour() {
        long s = this.microSeconds_d / 1000000L;
        return (int)(s / 3600L);
    }

    public int getTimeOnlyMicroSecond() {
        return (int)(this.microSeconds_d % 1000000L);
    }

    public int getTimeOnlyMinute() {
        long s = this.microSeconds_d / 1000000L;
        int h = (int)(s / 3600L);
        return (int)((s -= (long)(h * 3600)) / 60L);
    }

    public int getTimeOnlySecond() {
        long s = this.microSeconds_d / 1000000L;
        int h = (int)(s / 3600L);
        int m = (int)((s -= (long)(h * 3600)) / 60L);
        return (int)(s -= (long)(m * 60));
    }

    public int getWeekOfMonth() {
        return this.getCalendar().get(4);
    }

    public int getWeekOfYear() {
        return this.getCalendar().get(3);
    }

    public int getYear() {
        Calendar cal = this.getCalendar();
        int year = cal.get(1);
        return cal.get(0) == 0 ? -year : year;
    }

    public int hashCode() {
        return (int)(this.microSeconds_d ^ this.microSeconds_d >>> 32);
    }

    public int intValue() {
        return this.getSeconds();
    }

    public boolean isAm() {
        return this.getAMPM() == 0;
    }

    public Time max(Time b) {
        return Time.compare(this, b) >= 0 ? this : b;
    }

    public Time min(Time b) {
        return Time.compare(this, b) <= 0 ? this : b;
    }

    public int monthsSince(Time t) {
        return (this.getYear() - t.getYear()) * 12 + this.getMonth() - t.getMonth() - (this.getDay() < t.getDay() ? 1 : 0);
    }

    @Exclude
    public Time next(Day day) {
        int daysToAdd = day.intValue() - (this.getDayOfWeek() - 1);
        if (daysToAdd < 0) {
            daysToAdd += 7;
        }
        return this.addDays(daysToAdd);
    }

    @Deprecated
    public String retryAt() {
        return RETRYIN + this.roundToSeconds().sub(Time.now().roundToSeconds());
    }

    public Time roundDownToSeconds() {
        long us = this.getMicroSeconds();
        long rus = (us < 0L ? us - 999999L : us) / 1000000L * 1000000L;
        return us == rus ? this : Time.valueOf(rus);
    }

    public Time roundToSeconds() {
        long us = this.getMicroSeconds();
        return Time.valueOf((us < 0L ? us - 499999L : us + 500000L) / 1000000L * 1000000L);
    }

    public Date sqlDateValue() {
        return new Date(this.getMilliSeconds());
    }

    public Timestamp sqlTimestampValue() {
        int ms = this.getMicroSecond();
        Timestamp result = new Timestamp((this.getMicroSeconds() - (long)ms) / 1000L);
        result.setNanos(1000 * ms);
        return result;
    }

    public java.sql.Time sqlTimeValue() {
        return new java.sql.Time(this.getMilliSeconds());
    }

    public Interval sub(Time that) {
        return Interval.valueOf(this, that);
    }

    public Time sub(Interval interval) {
        return interval == null ? this : interval.subFrom(this);
    }

    @Exclude
    public String toDateString() {
        StringBuilder buff = new StringBuilder();
        int year = this.getYear();
        if (year < 0) {
            buff.append('-');
            year = -year;
        }
        Str.append(buff, year, 4, 10, '0');
        buff.append('-');
        Str.append(buff, this.getMonth(), 2, 10, '0');
        buff.append('-');
        Str.append(buff, this.getDayOfMonth(), 2, 10, '0');
        return buff.toString();
    }

    public String toGMonthDayString() {
        StringBuilder buff = new StringBuilder();
        buff.append('-');
        buff.append('-');
        Str.append(buff, this.getMonth(), 2, 10, '0');
        buff.append('-');
        Str.append(buff, this.getDayOfMonth(), 2, 10, '0');
        return buff.toString();
    }

    public Time toGMT() {
        Calendar cal = this.getCalendar();
        return Time.valueOf(this.microSeconds_d + (long)Time.timeZoneOffset(cal) * 1000L);
    }

    public String toGYearMonthString() {
        StringBuilder buff = new StringBuilder();
        int year = this.getYear();
        if (year < 0) {
            buff.append('-');
            year = -year;
        }
        Str.append(buff, year, 4, 10, '0');
        buff.append('-');
        Str.append(buff, this.getMonth(), 2, 10, '0');
        return buff.toString();
    }

    public String toString() {
        return this.toIsoString(' ');
    }

    public Time toTime() {
        return this;
    }

    @Exclude
    public String toTimeString() {
        StringBuilder buff = new StringBuilder();
        Str.append(buff, this.getHourOfDay(), 2, 10, '0');
        buff.append(':');
        Str.append(buff, this.getMinute(), 2, 10, '0');
        buff.append(':');
        Str.append(buff, this.getSecond(), 2, 10, '0');
        int timeZoneInMinutes = Time.timeZoneOffset(this.getCalendar()) / 60000;
        if (timeZoneInMinutes == 0) {
            buff.append('Z');
        } else {
            int tzHours = Math.abs(timeZoneInMinutes / 60);
            int tzMinutes = Math.abs(timeZoneInMinutes % 60);
            buff.append(timeZoneInMinutes < 0 ? (char)'-' : '+');
            Str.append(buff, tzHours, 2, 10, '0');
            buff.append(':');
            Str.append(buff, tzMinutes, 2, 10, '0');
        }
        return buff.toString();
    }

    public String toXMLString() {
        return this.toIsoString('T');
    }

    public int yearsSince(Time t) {
        return this.monthsSince(t) / 12;
    }

    public String toXMLString(int scale) {
        switch (scale) {
            case 0: {
                return this.toDateString();
            }
            case 1: {
                return this.toTimeString();
            }
            case 4: {
                return this.toGYearMonthString();
            }
            case 3: {
                return this.toGMonthDayString();
            }
        }
        return this.toXMLString();
    }

    static TZTime parseTZ(String text) throws FormatException {
        TZTime result = null;
        if (text != null) {
            int index = TimeParser.skipWhitespace(0, text);
            if (text.length() != index) {
                result = TimeParser.parseTZ(text.substring(index), Time.getCalendarAndReset());
            }
        }
        return result;
    }

    static int timeZoneOffset(Calendar cal) {
        return cal.get(15) + cal.get(16);
    }

    @Hidden
    Calendar getCalendar() {
        CurrentTime c = Time.getCurrentTime();
        if (!Time.equals(c.time, this)) {
            long tm = this.getMicroSeconds();
            c.calendar.setTimeInMillis((tm < 0L ? tm - 999L : tm) / 1000L);
            c.time = this;
        }
        return c.calendar;
    }

    long getMicroSecondsOfDay() {
        return (long)((this.getHourOfDay() * 60 + this.getMinute()) * 60 + this.getSecond()) * 1000000L + (long)this.getMicroSecond();
    }

    private static Locale getLocale() {
        Locale locale = currentLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private static long calcMicroseconds(Timestamp date) {
        int nanos = date.getNanos();
        return (date.getTime() - (long)(nanos / 1000000)) * 1000L + (long)(nanos / 1000);
    }

    private static Calendar getCalendarAndReset() {
        CurrentTime c = Time.getCurrentTime();
        c.time = null;
        Calendar calendar = c.calendar;
        calendar.clear();
        return calendar;
    }

    private static long calcMicroseconds(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int microSecond) throws IllegalArgumentException {
        if (year < -290000 || year > 290000 || year == 0) {
            throw new IllegalArgumentException("Year: " + year);
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month: " + month);
        }
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            throw new IllegalArgumentException("Day of month: " + dayOfMonth);
        }
        if (hourOfDay < 0 || hourOfDay > 23) {
            throw new IllegalArgumentException("Hour: " + hourOfDay);
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Minute: " + minute);
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Second: " + second);
        }
        if (microSecond < 0 || microSecond > 999999) {
            throw new IllegalArgumentException("Microsecond: " + microSecond);
        }
        Calendar cal = Time.getCalendarAndReset();
        cal.set(0, year < 0 ? 0 : 1);
        cal.set(year < 0 ? -year : year, month - 1, dayOfMonth, hourOfDay, minute, second);
        return cal.getTimeInMillis() * 1000L + (long)microSecond;
    }

    private static CurrentTime getCurrentTime() {
        CurrentTime c = current.get();
        if (c == null) {
            c = new CurrentTime();
            current.set(c);
        }
        return c;
    }

    private int safeScaleToInt(long factor) throws ArithmeticException {
        int result;
        long scaledValue = this.getMicroSeconds() / factor;
        if (scaledValue != (long)(result = (int)scaledValue)) {
            throw new ArithmeticException("Numeric overflow");
        }
        return result;
    }

    private String toIsoString(char separator) {
        int timeZoneInMinutes;
        StringBuilder buff = new StringBuilder();
        int year = this.getYear();
        if (year < 0) {
            buff.append('-');
            year = -year;
        }
        Str.append(buff, year, 4, 10, '0');
        buff.append('-');
        Str.append(buff, this.getMonth(), 2, 10, '0');
        buff.append('-');
        Str.append(buff, this.getDayOfMonth(), 2, 10, '0');
        buff.append(separator);
        Str.append(buff, this.getHourOfDay(), 2, 10, '0');
        buff.append(':');
        Str.append(buff, this.getMinute(), 2, 10, '0');
        buff.append(':');
        Str.append(buff, this.getSecond(), 2, 10, '0');
        int micro = this.getMicroSecond();
        if (micro > 0) {
            buff.append('.');
            Str.append(buff, micro, 6, 10, '0');
        }
        if ((timeZoneInMinutes = Time.timeZoneOffset(this.getCalendar()) / 60000) == 0) {
            buff.append('Z');
        } else {
            int tzHours = Math.abs(timeZoneInMinutes / 60);
            int tzMinutes = Math.abs(timeZoneInMinutes % 60);
            buff.append(timeZoneInMinutes < 0 ? (char)'-' : '+');
            Str.append(buff, tzHours, 2, 10, '0');
            buff.append(':');
            Str.append(buff, tzMinutes, 2, 10, '0');
        }
        return buff.toString();
    }

    static /* synthetic */ Locale access$100() {
        return Time.getLocale();
    }

    private static final class WeekdayNames {
        static final String[] values = new DateFormatSymbols(Time.access$100()).getWeekdays();

        private WeekdayNames() {
        }
    }

    private static final class MonthNames {
        static final String[] values = new DateFormatSymbols().getMonths();

        private MonthNames() {
        }
    }

    private static final class CurrentTime {
        final Calendar calendar = new GregorianCalendar();
        Time time;

        private CurrentTime() {
        }
    }

    public static final class Holder {
        public Time value;

        public Holder() {
        }

        public Holder(Time init) {
            this.value = init;
        }
    }
}

