/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.CharsetEncoder;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Type;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.Time;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Base64;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.StringTokenizer;
import org.jetbrains.annotations.Nullable;

@Component(module="Fuego.Internal", hideInheritance=true)
public final class Str {
    private final String target;
    private static final char CHAR_SPACE = ' ';
    private static final char CHAR_UNDERSCORE = '_';
    private static final char CHAR_EQUALS = '=';
    private static final char CHAR_BACKSLASH = '\\';
    private static final char CHAR_COMMA = ',';
    private static final char CHAR_AMPERSAND = '&';
    private static final char CHAR_GREATER_THAN = '>';
    private static final char CHAR_LESS_THAN = '<';
    private static final String SPECIAL_SAVE_CHARS = "=: \t\r\n\f#!";
    private static final char[] DIGITS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public Str(String target) {
        this.target = target;
    }

    public static boolean contains(String text, String pattern) {
        return text != null && text.contains(pattern);
    }

    public static String encodeURL(String str) {
        String result;
        block2: {
            result = null;
            try {
                result = URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    @Exclude
    public static String expandTabs(String str, int tabSize) {
        assert (tabSize >= 0);
        if (str == null) {
            return null;
        }
        int length = str.length();
        int sbl = length + length / 4 * (tabSize - 1) + tabSize;
        StringBuilder result = new StringBuilder(sbl < 0 ? Integer.MAX_VALUE : sbl);
        int nextTab = tabSize;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\t') {
                while (nextTab > 0) {
                    result.append(' ');
                    --nextTab;
                }
                nextTab = tabSize;
                continue;
            }
            result.append(c);
            if (c != '\n' && c != '\r' && --nextTab > 0) continue;
            nextTab = tabSize;
        }
        return result.toString();
    }

    public static int indexOf(String text, String pattern) {
        return text == null ? -1 : text.indexOf(pattern);
    }

    public static String concat(String str1, String str2) {
        return str1 == null ? str2 : (str2 == null ? str1 : str1.concat(str2));
    }

    @Exclude
    public static int editDistance(String source, String target) {
        int i;
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int rows = sourceLength + 1;
        int columns = targetLength + 1;
        int[] matrix = new int[rows * columns];
        for (i = 0; i <= sourceLength; ++i) {
            matrix[i * columns] = i;
        }
        for (int j = 0; j <= targetLength; ++j) {
            matrix[j] = j;
        }
        for (i = 1; i <= sourceLength; ++i) {
            char sch = source.charAt(i - 1);
            for (int j = 1; j <= targetLength; ++j) {
                int cost = sch == target.charAt(j - 1) ? 0 : 1;
                int above = matrix[(i - 1) * columns + j];
                int left = matrix[i * columns + j - 1];
                int aboveLeft = matrix[(i - 1) * columns + j - 1];
                int n1 = above + 1;
                int n2 = left + 1;
                int n3 = aboveLeft + cost;
                int m1 = n1 <= n2 ? n1 : n2;
                matrix[i * columns + j] = m1 <= n3 ? m1 : aboveLeft + cost;
            }
        }
        return matrix[sourceLength * columns + targetLength];
    }

    public static String field(String str, String delimiter, int n) {
        if (delimiter.length() == 0) {
            return str;
        }
        int begin = 0;
        int end = str.indexOf(delimiter);
        for (int i = 0; i < n; ++i) {
            if (end == -1) {
                return "";
            }
            begin = end + delimiter.length();
            end = str.indexOf(delimiter, begin);
        }
        if (end == -1) {
            end = str.length();
        }
        return str.substring(begin, end);
    }

    @Exclude
    public static String insertNamedAttr(String str, String name, String value) {
        if (value == null) {
            return str;
        }
        return name + '=' + Str.escapeAttr(value) + (str == null || str.length() == 0 ? "" : ',' + str);
    }

    @Exclude
    public static int lastIndexOfWord(String str, String wordToSearch) {
        int wordEnd = str.length();
        for (int i = wordEnd - 1; i >= -1; --i) {
            if (i >= 0 && Character.isJavaIdentifierPart(str.charAt(i))) continue;
            int wordBegin = i + 1;
            if (str.substring(wordBegin, wordEnd).equals(wordToSearch)) {
                return wordBegin;
            }
            wordEnd = i;
        }
        return -1;
    }

    public static String pad(String string, int length) {
        return Str.pad(string, length, ' ');
    }

    public static String pad(String string, int length, char padChar) {
        return string == null ? Str.valueOf(padChar, length) : (string.length() < length ? string + Str.valueOf(padChar, length - string.length()) : string.substring(0, length));
    }

    @Type(value="String(1)")
    public static String valueOfChar(int charCode) {
        return String.valueOf((char)charCode);
    }

    public static String[] fields(String target, String delim) {
        if (target == null || delim == null || delim.length() == 0) {
            String[] stringArray;
            if (target == null) {
                stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = target;
            }
            return stringArray;
        }
        StringTokenizer t = new StringTokenizer(target, delim);
        StringList fields = StringList.create();
        while (t.hasMoreTokens()) {
            fields.add(t.nextToken());
        }
        String[] result = new String[fields.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)fields.get(i);
        }
        return result;
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean isEmpty(String target) {
        return target == null || target.isEmpty() || target.trim().isEmpty();
    }

    @Exclude
    public static boolean isValidJavaIdentifier(String target) {
        boolean result = false;
        if (target != null && target.length() > 0 && Character.isJavaIdentifierStart(target.charAt(0))) {
            int index;
            int length = target.length();
            for (index = 1; index < length && Character.isJavaIdentifierPart(target.charAt(index)); ++index) {
            }
            result = length == index;
        }
        return result;
    }

    public static String null2empty(String string) {
        return string == null ? "" : string;
    }

    @Exclude
    public static NamedAttr[] getNamedAttrList(String name) {
        return Str.getNamedAttrList(name, ",", "=");
    }

    @Exclude
    public static NamedAttr[] getNamedAttrList(String name, String entrySep, String idValueSep) {
        ArrayList<NamedAttr> path = new ArrayList<NamedAttr>();
        String partialName = name;
        while (partialName != null && partialName.length() != 0) {
            int endOfAttrId = partialName.indexOf(idValueSep);
            int endOfAttrValue = partialName.indexOf(entrySep);
            if (endOfAttrId < 0) {
                endOfAttrId = 0;
            }
            if (endOfAttrValue < 0) {
                endOfAttrValue = partialName.length();
            }
            String attrId = partialName.substring(0, endOfAttrId);
            String attrValue = partialName.substring(endOfAttrId + 1, endOfAttrValue);
            path.add(new NamedAttr(attrId, attrValue));
            partialName = Str.removeFirstNamedAttr(partialName);
        }
        return path.toArray(new NamedAttr[path.size()]);
    }

    @Exclude
    public static void append(StringBuilder toAppendTo, int v, int len, int base, char pad) {
        int val = v;
        if (v < 0) {
            val = -v;
        }
        char[] buff = new char[11];
        int cp = buff.length;
        do {
            buff[--cp] = DIGITS[val % base];
        } while ((val /= base) != 0);
        if (v < 0) {
            buff[--cp] = 45;
        }
        int npad = len - (buff.length - cp);
        while (cp > 0 && npad-- > 0) {
            buff[--cp] = pad;
        }
        while (npad-- > 0) {
            toAppendTo.append(pad);
        }
        toAppendTo.append(buff, cp, buff.length - cp);
    }

    @Exclude
    public static String appendNamedAttr(String str, String name, String value) {
        if (value == null) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        if (str != null && !str.isEmpty()) {
            builder.append(str).append(',');
        }
        return builder.append(name).append('=').append(Str.escapeAttr(value)).toString();
    }

    public static String[] chars(@Nullable String str) {
        int size;
        int n = size = str == null ? 0 : str.length();
        if (size == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = str.substring(i++, i);
        }
        return result;
    }

    public static int count(String string, char ch) {
        int count = 0;
        int p = 0;
        while ((p = string.indexOf(ch, p)) != -1) {
            ++count;
            ++p;
        }
        return count;
    }

    public static String escape(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer result = null;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            String replacement = null;
            switch (ch) {
                case '\\': {
                    replacement = "\\\\";
                    break;
                }
                case '\n': {
                    replacement = "\\n";
                    break;
                }
                case '\t': {
                    replacement = "\\t";
                    break;
                }
                case '\r': {
                    replacement = "\\r";
                    break;
                }
                case '\b': {
                    replacement = "\\b";
                    break;
                }
                case '\f': {
                    replacement = "\\f";
                    break;
                }
                case '\"': {
                    replacement = "\\\"";
                }
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(length + 4);
                    result.append(text, 0, i);
                }
                result.append(replacement);
                continue;
            }
            if (result == null) continue;
            result.append(ch);
        }
        return result != null ? result.toString() : text;
    }

    public static String escapeForScripts(String str) {
        String result = Str.replaceString(str, "\\", "\\\\");
        result = Str.replaceString(result, "'", "\\'");
        result = Str.replaceString(result, "\"", "\\\"");
        return result;
    }

    public static String unescapeForScripts(String str) {
        String result = Str.replaceString(str, "\\'", "'");
        result = Str.replaceString(result, "\\\"", "\"");
        return result;
    }

    public static String replace(String target, String pattern, String replacement) {
        if (target == null || pattern == null) {
            return target;
        }
        if (replacement == null) {
            replacement = "";
        }
        int m = pattern.length();
        int n = target.length();
        int[] kmpNext = new int[m + 1];
        int i = 0;
        kmpNext[0] = -1;
        int j = -1;
        while (i < m) {
            while (j > -1 && pattern.charAt(i) != pattern.charAt(j)) {
                j = kmpNext[j];
            }
            if (++i < m && pattern.charAt(i) == pattern.charAt(++j)) {
                kmpNext[i] = kmpNext[j];
                continue;
            }
            kmpNext[i] = j;
        }
        j = 0;
        i = 0;
        int last = 0;
        StringBuffer buffer = null;
        while (j < n) {
            while (i > -1 && pattern.charAt(i) != target.charAt(j)) {
                i = kmpNext[i];
            }
            ++j;
            if (++i < m) continue;
            int where = j - i;
            if (buffer == null) {
                buffer = new StringBuffer(n + m);
            }
            buffer.append(target.substring(last, where));
            buffer.append(replacement);
            last = where + m;
            i = kmpNext[i];
        }
        if (buffer == null) {
            return target;
        }
        if (last < n) {
            buffer.append(target.substring(last, n));
        }
        return buffer.toString();
    }

    @Exclude
    public static String replaceString(String str, String from, String to) {
        return Str.replace(str, from, to);
    }

    public static String removeNamedAttr(String str, String name) {
        char c;
        StringBuilder result = new StringBuilder();
        int lastc = 0;
        int lasti = 0;
        int i = 0;
        boolean firstTime = true;
        do {
            char c2 = c = i < str.length() ? str.charAt(i) : (char)'\u0000';
            if ((c == ',' || c == '\u0000') && lastc != 92) {
                String part = str.substring(lasti, i);
                int eq = part.indexOf(61);
                if (eq != name.length() || !part.regionMatches(true, 0, name, 0, eq)) {
                    if (!firstTime) {
                        result.append(',');
                    }
                    result.append(part);
                    firstTime = false;
                }
                lasti = i + 1;
            }
            lastc = c;
            ++i;
        } while (c != '\u0000');
        return result.toString();
    }

    public static String strip(String string, int length) {
        if (string == null) {
            return "";
        }
        return string.length() > length ? string.substring(0, length) : string;
    }

    public static String valueOf(char c, int repetition) {
        if (repetition == 0) {
            return "";
        }
        char[] chars = new char[repetition];
        Arrays.fill(chars, c);
        return String.valueOf(chars);
    }

    public static String valueOf(char c) {
        return String.valueOf(c);
    }

    public static String valueOf(char[] string) {
        return string != null ? String.valueOf(string) : null;
    }

    @Exclude
    public static String[] concat(String[] strings1, String[] strings2) {
        int length1 = strings1.length;
        int length2 = strings2.length;
        String[] array = new String[length1 + length2];
        System.arraycopy(strings1, 0, array, 0, length1);
        System.arraycopy(strings2, 0, array, length1, length2);
        return array;
    }

    @Exclude
    public static String convertToHTMLString(String text) {
        return Str.convertToHTMLString(text, false);
    }

    @Exclude
    public static String convertToHTMLString(String text, boolean keepHrefs) {
        StringBuilder result = new StringBuilder();
        if (text != null) {
            block9: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\n': {
                        result.append("<br>");
                        continue block9;
                    }
                    case '\t': {
                        result.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                        continue block9;
                    }
                    case '\r': {
                        result.append(' ');
                        continue block9;
                    }
                    case '<': {
                        if (keepHrefs) {
                            result.append(ch);
                            continue block9;
                        }
                        result.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        if (keepHrefs) {
                            result.append(ch);
                            continue block9;
                        }
                        result.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        result.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        result.append("&quot;");
                        continue block9;
                    }
                    default: {
                        result.append(ch);
                    }
                }
            }
        }
        return result.toString();
    }

    public static String toEncodedHTML(String html) {
        return Str.toEncodedHTML(html, null);
    }

    public static String toEncodedHTML(String html, String defaultValue) {
        if (html == null || html.isEmpty()) {
            html = defaultValue == null ? "" : defaultValue;
        }
        int length = html.length();
        StringBuilder result = new StringBuilder((int)((double)length * 1.5));
        for (int i = 0; i < length; ++i) {
            char character = html.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == ' ' || character == ',' || character == '.' || character == ':') {
                result.append(character);
                continue;
            }
            result.append("&#").append((int)character).append(';');
        }
        return result.toString();
    }

    public static String toXMLString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Time) {
            return ((Time)obj).toXMLString();
        }
        if (obj instanceof Interval) {
            return ((Interval)obj).toXMLString();
        }
        if (obj instanceof Date) {
            return Time.valueOf((Date)obj).toXMLString();
        }
        if (obj instanceof Throwable) {
            return Str.toXMLString(ExceptionFormatter.fullTechLevel((Throwable)obj));
        }
        return Str.toXMLString(obj.toString());
    }

    public static String toXMLString(String value) {
        if (value == null) {
            return "null";
        }
        int size = value.length();
        StringBuilder result = new StringBuilder("");
        block8: for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '\u0000': {
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String toXMLString(String value, CharsetEncoder charsetEncoder) {
        if (value == null) {
            return "null";
        }
        int size = value.length();
        StringBuilder result = new StringBuilder();
        block8: for (int i = 0; i < size; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '\u0000': {
                    continue block8;
                }
                default: {
                    if (charsetEncoder.canEncode(c)) {
                        result.append(c);
                        continue block8;
                    }
                    result.append("&#").append((int)c).append(';');
                }
            }
        }
        return result.toString();
    }

    @Exclude
    public static String getNamedAttr(String str, String name) {
        return Str.getNamedAttr(str, name, true);
    }

    @Exclude
    public static String getNamedAttr(String str, String name, boolean unescape) {
        char c;
        int lastc = 0;
        int lasti = 0;
        int i = 0;
        do {
            char c2 = c = i < str.length() ? str.charAt(i) : (char)'\u0000';
            if ((c == ',' || c == '\u0000') && lastc != 92) {
                String part = str.substring(lasti, i);
                int eq = part.indexOf(61);
                if (eq == name.length() && part.regionMatches(true, 0, name, 0, eq)) {
                    if (unescape) {
                        return Str.unescapeAttr(part.substring(eq + 1));
                    }
                    return part.substring(eq + 1);
                }
                lasti = i + 1;
            }
            lastc = c;
            ++i;
        } while (c != '\u0000');
        return null;
    }

    @Exclude
    public static String idFromConstantId(String id) {
        assert (id != null && !id.isEmpty()) : "Null or Empty id";
        StringBuilder result = new StringBuilder();
        boolean nextUpper = true;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c == ' ') {
                nextUpper = true;
                continue;
            }
            c = nextUpper ? Character.toUpperCase(c) : Character.toLowerCase(c);
            nextUpper = false;
            result.append(c);
        }
        return result.toString();
    }

    @Exclude
    public static String join(String[] arr, char delim) {
        if (arr.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        for (String anArr : arr) {
            ret.append(Str.escape(anArr, delim)).append(delim);
        }
        return ret.substring(0, ret.length() - 1);
    }

    @Exclude
    public static String leftJustify(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder sb = new StringBuilder(width);
        sb.append(s);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        return sb.toString();
    }

    @Exclude
    public static String makeConstantId(String name) {
        assert (name != null && !name.isEmpty()) : "Null or Empty name";
        StringBuilder result = new StringBuilder();
        char prevC = name.charAt(0);
        result.append(Character.toUpperCase(prevC));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c) && Character.isLowerCase(prevC)) {
                result.append('_');
            }
            result.append(Character.toUpperCase(c));
            prevC = c;
        }
        return result.toString();
    }

    @Exclude
    public static String nameOfConstantId(String id) {
        assert (id != null && !id.isEmpty()) : "Null or Empty id";
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(id.charAt(0)));
        for (int i = 1; i < id.length(); ++i) {
            char c = id.charAt(i);
            c = c == '_' ? (char)' ' : (char)Character.toLowerCase(c);
            result.append(c);
        }
        return result.toString();
    }

    @Exclude
    public static String removeFirstNamedAttr(String str) {
        char c;
        StringBuffer result = null;
        int lastc = 0;
        int lasti = 0;
        int i = 0;
        boolean firstRemoved = false;
        do {
            char c2 = c = i < str.length() ? str.charAt(i) : (char)'\u0000';
            if ((c == ',' || c == '\u0000') && lastc != 92) {
                String part = str.substring(lasti, i);
                if (firstRemoved) {
                    if (result == null) {
                        result = new StringBuffer();
                    }
                    result.append(part);
                    if (c != '\u0000') {
                        result.append(',');
                    }
                }
                firstRemoved = true;
                lasti = i + 1;
            }
            lastc = c;
            ++i;
        } while (c != '\u0000');
        return result == null ? null : result.toString();
    }

    @Exclude
    public static String rightJustify(String s, int width, char fillChar) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder sb = new StringBuilder(width);
        int i = width - s.length();
        while (--i >= 0) {
            sb.append(fillChar);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String[] split(String str, char delim, boolean quote) {
        StringList tokens = StringList.create();
        int strLength = str.length();
        if (strLength != 0) {
            int from = 0;
            boolean insideQuotes = false;
            for (int i = 0; i < strLength; ++i) {
                char chr = str.charAt(i);
                if (quote && chr == '\"') {
                    insideQuotes = !insideQuotes;
                    continue;
                }
                if (insideQuotes || chr != delim || i != 0 && (i <= 0 || str.charAt(i - 1) == '\\')) continue;
                Str.addToken(str, from, i, quote, tokens);
                from = i + 1;
            }
            Str.addToken(str, from, strLength, quote, tokens);
        }
        return tokens.toArray();
    }

    @Exclude
    public static String[] splitLines(String src) {
        StringList temp;
        block4: {
            if (src == null) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            temp = StringList.create();
            BufferedReader br = new BufferedReader(new StringReader(src));
            try {
                String str;
                while ((str = br.readLine()) != null) {
                    temp.add(str);
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)e);
            }
        }
        return temp.toArray();
    }

    @Exclude
    public static String toString(Object obj, int length) {
        if (obj == null) {
            return null;
        }
        String result = String.valueOf(obj);
        if (result.length() > length) {
            result = result.substring(0, length);
        }
        return result;
    }

    @Exclude
    public static String updateNamedAttr(String str, String name, String value) {
        char c;
        StringBuilder result = new StringBuilder();
        int lastc = 0;
        int lasti = 0;
        int i = 0;
        do {
            char c2 = c = i < str.length() ? str.charAt(i) : (char)'\u0000';
            if ((c == ',' || c == '\u0000') && lastc != 92) {
                String part = str.substring(lasti, i);
                int eq = part.indexOf(61);
                if (eq == name.length() && part.regionMatches(true, 0, name, 0, eq)) {
                    part = name + '=' + Str.escapeAttr(value);
                }
                result.append(part);
                if (c != '\u0000') {
                    result.append(',');
                }
                lasti = i + 1;
            }
            lastc = c;
            ++i;
        } while (c != '\u0000');
        return result.toString();
    }

    public static String valueOf(Object obj, int length) {
        String result;
        if (obj == null) {
            result = null;
        } else {
            if (obj instanceof String) {
                result = (String)obj;
            } else if (obj instanceof byte[]) {
                result = Binary.valueOf((byte[])obj).toString();
            } else if (obj instanceof Clob) {
                Clob clob = (Clob)obj;
                try {
                    result = clob.getSubString(1L, (int)clob.length());
                }
                catch (SQLException e) {
                    throw new IllegalConversionException((Object)clob, "String", e.toString());
                }
            } else {
                if (obj.getClass().isArray()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append('[');
                    int len = Array.getLength(obj);
                    for (int i = 0; i < len; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(Str.valueOf(Array.get(obj, i)));
                    }
                    sb.append(']');
                    return sb.toString();
                }
                result = String.valueOf(obj);
            }
            if (length > 0 && result.length() > length) {
                result = result.substring(0, length);
            }
        }
        return result;
    }

    public static String valueOf(Object o) {
        return Str.valueOf(o, -1);
    }

    public static String capitalize(String string) {
        return string.isEmpty() ? string : Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String encodeUnicodeChars(String str, boolean escapeSpace) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char c = str.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        Str.unicodeAppend(outBuffer, c);
                        continue block8;
                    }
                    if (SPECIAL_SAVE_CHARS.indexOf(c) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                }
            }
        }
        return outBuffer.toString();
    }

    public static String decodeUnicodeChars(String str) {
        int length = str.length();
        StringBuilder buffer = new StringBuilder(length);
        int x = 0;
        while (x < length) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92 && x < length) {
                if ((aChar = str.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = str.charAt(x++);
                        switch (aChar) {
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed unicode encoding: " + str);
                            }
                        }
                    }
                    buffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                buffer.append((char)aChar);
                continue;
            }
            buffer.append((char)aChar);
        }
        return buffer.toString();
    }

    public static String head(String aString, char character) {
        int indexOfChar = aString.indexOf(character);
        return indexOfChar < 0 ? aString : aString.substring(0, indexOfChar);
    }

    public static String headOfLastOccurrence(String string, char character) {
        return string.substring(0, string.lastIndexOf(character));
    }

    public static String tail(String aString, char character) {
        return Str.tailWithDefault(aString, character, "");
    }

    public static String tailOrString(String aString, char character) {
        return Str.tailWithDefault(aString, character, aString);
    }

    public static String tailWithDefault(String aString, char character, String defaultValue) {
        int lastIndexOfChar = aString.lastIndexOf(character);
        return lastIndexOfChar >= 0 ? aString.substring(lastIndexOfChar + 1) : defaultValue;
    }

    @Exclude
    public static String stripFrontBack(String src, String head, String tail) {
        int h = src.indexOf(head);
        int t = src.lastIndexOf(tail);
        if (h == -1 || t == -1) {
            return src;
        }
        return src.substring(h + 1, t);
    }

    @Exclude
    public static String stripFront(String s, String remove) {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i < remove.length(); ++i) {
                char c = remove.charAt(i);
                while (!s.isEmpty() && s.charAt(0) == c) {
                    changed = true;
                    s = s.substring(1);
                }
            }
        } while (changed);
        return s;
    }

    @Exclude
    public static String stripFront(String s, char c) {
        while (!s.isEmpty() && s.charAt(0) == c) {
            s = s.substring(1);
        }
        return s;
    }

    @Exclude
    public static String stripBack(String s, String remove) {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i < remove.length(); ++i) {
                char c = remove.charAt(i);
                while (!s.isEmpty() && s.charAt(s.length() - 1) == c) {
                    changed = true;
                    s = s.substring(0, s.length() - 1);
                }
            }
        } while (changed);
        return s;
    }

    @Exclude
    public static String stripBack(String s, char c) {
        while (!s.isEmpty() && s.charAt(s.length() - 1) == c) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public boolean isMatch(RegExp regexp) {
        return this.target != null && regexp.isMatch(this.target);
    }

    public String charAt(int position) {
        try {
            return this.target.substring(position, position + 1);
        }
        catch (NullPointerException e) {
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public int charValue() {
        return this.target != null && !this.target.isEmpty() ? (int)this.target.charAt(0) : 0;
    }

    public String[] chars() {
        return Str.chars(this.target);
    }

    public boolean contains(RegExp regexp) {
        return this.target != null && regexp.match(this.target) != null;
    }

    public int count(RegExp regexp) {
        return this.target != null ? regexp.count(this.target) : 0;
    }

    public int count(char ch) {
        return Str.count(this.target, ch);
    }

    public String encodeURL() {
        return Str.encodeURL(this.target);
    }

    public byte[] decode() {
        return this.target != null ? Base64.decode(this.target) : null;
    }

    public String encodeHTML() {
        return Str.convertToHTMLString(this.target);
    }

    public boolean equals(Object arg1) {
        return this.target.equals(arg1);
    }

    public String escape() {
        return Str.escape(this.target);
    }

    public String field(String delimiter, int n) {
        return Str.field(this.target, delimiter, n);
    }

    public String fieldFromDN(String selector) {
        return Str.field(Str.field(this.target, selector + '=', 1), ",", 0);
    }

    public String[] fields(String delim) {
        return Str.fields(this.target, delim);
    }

    public int hashCode() {
        return this.target != null ? this.target.hashCode() : 0;
    }

    public int indexOf(RegExp regexp) {
        return this.target != null ? regexp.indexOf(this.target) : -1;
    }

    public int indexOf(String text) {
        return this.target != null ? this.target.indexOf(text) : -1;
    }

    public int lastIndexOf(RegExp regexp) {
        return this.target != null ? regexp.lastIndexOf(this.target) : -1;
    }

    public int lastIndexOf(String text) {
        return this.target != null ? this.target.lastIndexOf(text) : -1;
    }

    public int length() {
        return this.target != null ? this.target.length() : 0;
    }

    public boolean isEmpty() {
        return Str.isEmpty(this.target);
    }

    public String[] match(RegExp regexp) {
        return this.target != null ? regexp.match(this.target) : ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String pad(int len) {
        try {
            return Str.pad(this.target, len);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String replace(RegExp regexp, String replacement) {
        return this.target != null ? regexp.replace(this.target, replacement) : null;
    }

    public String replace(String from, String to) {
        return Str.replace(this.target, from, to);
    }

    public String[] split(RegExp regexp) {
        return this.target != null ? regexp.split(this.target) : ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String[] split(char delim, boolean quote) {
        return Str.split(this.target, delim, quote);
    }

    public String[] split(char delim) {
        return Str.split(this.target, delim, true);
    }

    public String strip(int len) {
        try {
            return Str.strip(this.target, len);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public String toLowerCase() {
        return this.target != null ? this.target.toLowerCase() : "";
    }

    public String toUpperCase() {
        return this.target != null ? this.target.toUpperCase() : "";
    }

    public String trim() {
        return this.target != null ? this.target.trim() : "";
    }

    @Exclude
    public void print() {
        System.out.println(this.target);
    }

    public String substring(int first, int last) {
        String target = this.target;
        try {
            return target.substring(first, last);
        }
        catch (NullPointerException e) {
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            int length;
            if (first < 0) {
                first = 0;
            }
            if (last > (length = target.length())) {
                last = length;
            }
            return first < last ? target.substring(first, last) : "";
        }
    }

    public String substring(int first) {
        try {
            return this.target.substring(first);
        }
        catch (NullPointerException e) {
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private static void addToken(String str, int from, int to, boolean quote, StringList tokens) {
        int length = to - from;
        if (length == 0) {
            tokens.add("");
            return;
        }
        if (quote && to - from > 1 && str.charAt(from) == '\"' && str.charAt(to - 1) == '\"') {
            ++from;
            --to;
        }
        char[] buff = new char[length];
        int j = 0;
        for (int i = from; i < to; ++i) {
            char c = str.charAt(i);
            if (c == '\\' && ++i < to) {
                c = str.charAt(i);
            }
            buff[j++] = c;
        }
        tokens.add(new String(buff, 0, j));
    }

    private static String escape(String str, char delim) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        int slen = str.length();
        int capacity = slen + slen / 4;
        StringBuilder result = new StringBuilder(capacity < 0 ? Integer.MAX_VALUE : capacity);
        for (int i = 0; i < slen; ++i) {
            char c = str.charAt(i);
            if (c == '\\' || c == delim) {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }

    private static String escapeAttr(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(str.length() * 2);
        block5: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '$': {
                    out.append('$');
                    out.append('$');
                    continue block5;
                }
                case '\\': {
                    out.append('$');
                    out.append('_');
                    continue block5;
                }
                case ',': {
                    out.append('\\');
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static String unescapeAttr(String dn) {
        if (dn == null) {
            return null;
        }
        StringBuilder out = new StringBuilder(dn.length());
        boolean escapeComma = false;
        boolean escapeBackslash = false;
        block5: for (int i = 0; i < dn.length(); ++i) {
            char c = dn.charAt(i);
            switch (c) {
                case '_': {
                    if (escapeBackslash) {
                        out.append('\\');
                        escapeBackslash = false;
                        continue block5;
                    }
                    out.append('_');
                    continue block5;
                }
                case '$': {
                    if (escapeBackslash) {
                        out.append('$');
                        escapeBackslash = false;
                        continue block5;
                    }
                    escapeBackslash = true;
                    continue block5;
                }
                case '\\': {
                    if (escapeComma) {
                        out.append('\\');
                        escapeComma = false;
                        continue block5;
                    }
                    escapeComma = true;
                    continue block5;
                }
                default: {
                    escapeComma = false;
                    escapeBackslash = false;
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    private static void unicodeAppend(StringBuffer outBuffer, char c) {
        outBuffer.append('\\');
        outBuffer.append('u');
        outBuffer.append(Str.toHex(c >> 12));
        outBuffer.append(Str.toHex(c >> 8));
        outBuffer.append(Str.toHex(c >> 4));
        outBuffer.append(Str.toHex(c));
    }

    private static char toHex(int nibble) {
        return DIGITS[nibble & 0xF];
    }

    public static final class NamedAttr {
        public final String name;
        public final String value;

        public NamedAttr(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + '=' + this.value;
        }
    }

    public static final class Holder {
        public String value;

        public Holder() {
        }

        public Holder(String init) {
            this.value = init;
        }
    }
}

