/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;

public class RuntimeExceptionShell
extends RuntimeException {
    private String m;
    private String originalClass_d = null;
    private String originalMessage_d = null;
    private String originalStackTrace_d = null;
    private String originalString_d = null;
    static final long serialVersionUID = -4016654497619083368L;
    static final long serialCheck = 97248482570521180L;

    public RuntimeExceptionShell(Throwable t) {
        this.initCause(t);
    }

    public RuntimeExceptionShell(Throwable t, String msg) {
        this.initCause(t);
        this.m = msg;
    }

    public RuntimeExceptionShell(String msg, Throwable t) {
        this.originalClass_d = t.getClass().getName();
        this.originalMessage_d = t.getMessage();
        this.m = msg;
        this.originalString_d = t.toString();
        this.originalStackTrace_d = t.toString();
    }

    private RuntimeExceptionShell() {
    }

    @Override
    public final String getMessage() {
        return this.getCause() != null ? this.getCause().getMessage() : this.originalMessage_d;
    }

    public final String getOwnMessage() {
        return this.m;
    }

    public final Throwable getThrowable() {
        return this.getCause();
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public final void printStackTrace(PrintStream out) {
        this.printStackTrace(new PrintWriter(out));
    }

    @Override
    public final void printStackTrace(PrintWriter out) {
        out.println("\nRuntime exception Shell.");
        if (this.m != null && !this.m.equals("")) {
            out.println("Context details   :\n\t" + this.m + "\n");
        }
        if (this.originalMessage_d != null && !this.originalMessage_d.equals("")) {
            out.println("Apparent cause    :\n\t" + this.originalMessage_d + "\n");
        } else if (this.getCause() != null && this.getCause().getMessage() != null && !this.getCause().getMessage().equals("")) {
            out.println("Apparent cause    :\n\t" + this.getCause().getMessage() + "\n");
        }
        out.println();
        out.println("Original stack trace follows ...");
        out.println();
        if (this.originalStackTrace_d != null) {
            out.println(this.originalStackTrace_d);
        } else if (this.getCause() != null) {
            this.getCause().printStackTrace(out);
        }
        out.println();
        out.flush();
    }

    @Override
    public final String toString() {
        return this.getClass() + " ->> " + (this.getCause() != null ? this.getCause().toString() : this.originalString_d);
    }

    private static String getStackTrace(Throwable exc) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter auxPrintWriter = new PrintWriter((Writer)stringWriter, true);
        auxPrintWriter.print("Trace:");
        exc.printStackTrace(auxPrintWriter);
        return stringWriter.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.originalStackTrace_d == null) {
            String hostName = "";
            try {
                hostName = hostName + "\"" + InetAddress.getLocalHost().getHostName() + "\"";
            }
            catch (Exception e) {
                hostName = hostName + "\"<unavailable>\"";
            }
            try {
                hostName = hostName + "(" + InetAddress.getLocalHost().getHostAddress() + ")";
            }
            catch (Exception e) {
                hostName = hostName + "(<unavailable>)";
            }
            this.originalStackTrace_d = "Exception serialized from host " + hostName + "\n";
            this.originalStackTrace_d = this.originalStackTrace_d + RuntimeExceptionShell.getStackTrace(this.getCause());
        }
        out.defaultWriteObject();
    }
}

