/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.util.NumberFormatter;

@Component(module="Fuego.Internal", hideInheritance=true)
public class Real {
    private Double value;

    public Real(double value) {
        this.value = value;
    }

    public Real(float value) {
        this.value = value;
    }

    public Real(Number value) {
        this.value = value != null ? Double.valueOf(value.doubleValue()) : null;
    }

    public Real(Float value) {
        this((Number)value);
    }

    public Real(Double value) {
        this.value = value;
    }

    public static Double dec(Double op) {
        return op == null ? -1.0 : op - 1.0;
    }

    public static String format(double number) {
        return NumberFormatter.format(number);
    }

    public static Double inc(Double op) {
        return op == null ? 1.0 : op + 1.0;
    }

    public static Double negate(Double op) {
        return op == null ? 0.0 : -op.doubleValue();
    }

    public static Double asDouble(Object value) {
        return value == null ? null : Double.valueOf(Real.doubleValue(value));
    }

    public static Float asFloat(Object value) {
        return value == null ? null : Float.valueOf((float)Real.doubleValue(value));
    }

    public static double doubleValue(Number value) {
        return value == null ? 0.0 : value.doubleValue();
    }

    public static double doubleValue(String value) {
        return value == null ? 0.0 : Double.parseDouble(value);
    }

    public static double doubleValue(Object value) {
        if (value == null || value instanceof Number) {
            return Real.doubleValue((Number)value);
        }
        if (value instanceof String) {
            return Real.doubleValue((String)value);
        }
        if (value instanceof Time) {
            return Int.longValue((Time)value);
        }
        if (value instanceof Interval) {
            return Int.longValue((Interval)value);
        }
        if (value instanceof byte[]) {
            return Real.doubleValue(Binary.deserialize((byte[])value));
        }
        throw new IllegalConversionException(value, "Real");
    }

    @Deprecated
    public static double valueOf(Object value) {
        return Real.doubleValue(value);
    }

    public static float floatValue(Object value) {
        return (float)Real.doubleValue(value);
    }

    public static Double valueOf(double value) {
        return value;
    }

    public static Float valueOf(float value) {
        return Float.valueOf(value);
    }

    public double abs() {
        return this.value() < 0.0 ? -this.value() : this.value();
    }

    public final double acos() {
        return Math.acos(this.value());
    }

    public final double asin() {
        return Math.asin(this.value());
    }

    public final double atan() {
        return Math.atan(this.value());
    }

    public final double ceil() {
        return Math.ceil(this.value());
    }

    public final double cos() {
        return Math.cos(this.value());
    }

    public final double exp() {
        return Math.exp(this.value());
    }

    public final double floor() {
        return Math.floor(this.value());
    }

    public String format() {
        return this.value == null ? null : NumberFormatter.format(this.value);
    }

    public String format(String mask) {
        return this.value == null ? null : new DecimalFormat(mask).format(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Real)) {
            return false;
        }
        Real real = (Real)o;
        return !(this.value != null ? !this.value.equals(real.value) : real.value != null);
    }

    public String formatMoney() {
        return this.value == null ? null : NumberFormatter.formatMoney(this.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public final double log() {
        return Math.log(this.value());
    }

    public double max(long i) {
        return this.value() > (double)i ? this.value() : (double)i;
    }

    public double max(double i) {
        return this.value() > i ? this.value() : i;
    }

    public double max(BigDecimal value) {
        if (value != null) {
            return value.doubleValue() > this.value() ? value.doubleValue() : this.value();
        }
        return this.value();
    }

    public double min(double i) {
        return this.value() < i ? this.value() : i;
    }

    public double min(long i) {
        return this.value() < (double)i ? this.value() : (double)i;
    }

    public double min(BigDecimal i) {
        if (i != null) {
            return i.doubleValue() < this.value() ? i.doubleValue() : this.value();
        }
        return this.value();
    }

    public final double pow(double b) {
        return Math.pow(this.value(), b);
    }

    public final double round() {
        return Math.round(this.value());
    }

    public final double sin() {
        return Math.sin(this.value());
    }

    public final double sqrt() {
        return Math.sqrt(this.value());
    }

    public final double tan() {
        return Math.tan(this.value());
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    private double value() {
        return this.value != null ? this.value : 0.0;
    }

    public static class ObjHolder {
        public Double value;

        public ObjHolder() {
        }

        public ObjHolder(Double init) {
            this.value = init;
        }

        public void put(Number number) {
            this.value = number == null ? 0.0 : number.doubleValue();
        }
    }

    public static class Holder {
        public double value;

        public Holder() {
        }

        public Holder(double init) {
            this.value = init;
        }

        public void put(Number number) {
            this.value = number == null ? 0.0 : number.doubleValue();
        }
    }
}

