/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.FuegoClassLoader;
import oracle.bpm.lang.Holder;
import oracle.bpm.lang.InvalidSignatureException;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaUtils;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.DefaultValue;
import oracle.bpm.util.PrimitiveTypeUtils;
import oracle.bpm.util.StackTrace;
import org.jetbrains.annotations.NonNls;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public final class JavaClass<T>
extends Invocator
implements Serializable {
    private transient Map<String, Constructor<T>> constructorCache;
    private transient Constructor<T> defaultConstructor;
    private transient boolean defaultConstructorInit;
    private transient Map<String, Field> fieldCache;
    private transient Constructor<T> hackConstructor;
    private transient Map<String, HolderConstructors[]> holders;
    private transient Method instantiator;
    private Class<T> jclass;
    private transient Map<String, Method> methodCache;
    private transient Map<String, List<Method>> methodsByName;
    private transient Long serialId;
    private transient ObjectStreamClass streamClass;
    @NonNls
    private static final String VALUE_FIELD = "value";
    @NonNls
    private static final String PARENT_THIS1 = "this_0";
    @NonNls
    private static final String PARENT_THIS0 = "this$0";
    @NonNls
    private static final String HOLDER_CLASS_EXT = "Holder";
    @NonNls
    private static final String NEW_INSTANCE_METHOD = "newInstance";
    public static final String PARENT_FIELD = "this_0";
    @NonNls
    private static final Set<String> DEFAULT_ALLOWED_CLASSES = new HashSet<String>();
    public static final char ATTRIBUTE_SIGNATURE = 'A';
    public static final char CONSTRUCTOR_SIGNATURE = 'K';
    public static final char METHOD_SIGNATURE = 'M';
    public static final char ARRAY_SIGNATURE = '[';
    public static final char CLASS_SIGNATURE = 'L';
    public static final char END_SIGNATURE = ';';
    public static final char FIELD_SEPARATOR = ':';
    public static final char INDEXED_SIGNATURE = '!';
    public static final Long NO_SERIAL_VERSION;
    private static final byte CONSTANT_CLASS = 7;
    private static final byte CONSTANT_FIELDREF = 9;
    private static final byte CONSTANT_METHODREF = 10;
    private static final byte CONSTANT_INTERFACE_METHODREF = 11;
    private static final byte CONSTANT_STRING = 8;
    private static final byte CONSTANT_INTEGER = 3;
    private static final byte CONSTANT_FLOAT = 4;
    private static final byte CONSTANT_LONG = 5;
    private static final byte CONSTANT_DOUBLE = 6;
    private static final byte CONSTANT_NAMEANDTYPE = 12;
    private static final byte CONSTANT_UTF8 = 1;
    private static final short PUBLIC = 1;
    private static final Map<Class, JavaClass> classCache;
    private static Object unsafe;
    static final long serialVersionUID = -6088150032147156708L;
    @NonNls
    private static final String UNSAFE_FIELD = "theUnsafe";
    @NonNls
    private static final String UNSAFE_OPERATIONS_NOT_SUPPORTED = "Unsafe operations not supported in this virtual machine";
    static final long serialCheck = -6114699794024367956L;

    JavaClass(Class<T> cl) {
        this.jclass = cl;
        this.loadInfo();
    }

    public static String buildIndexedSignature(String signature, int index) {
        return '!' + signature + ':' + String.valueOf(index);
    }

    public static boolean isPublic(DataInputStream bytecode) {
        try {
            bytecode.readInt();
            bytecode.readShort();
            bytecode.readShort();
            JavaClass.skipConstants(bytecode);
            boolean isPublic = (bytecode.readShort() & 1) != 0;
            bytecode.close();
            return isPublic;
        }
        catch (IOException e) {
            if (Log.isDebugging()) {
                Log.logDebug(e);
            }
            return false;
        }
    }

    public static String classInfo(Object o) {
        String info = null;
        if (o != null) {
            info = o.getClass().getName();
            info = info + "[" + o.getClass().getClassLoader() + "]";
        }
        return info;
    }

    public static void copyFields(Object source, Object target) {
        Field[] fields;
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        assert (sourceClass == targetClass) : "source " + sourceClass + " != target " + targetClass;
        for (Field field : fields = JavaClass.getAllFields(targetClass)) {
            field.setAccessible(true);
            try {
                if (JavaClass.isFinal(field)) continue;
                Object value = field.get(source);
                field.set(target, value);
            }
            catch (IllegalAccessException e) {
                assert (false) : e.toString();
            }
        }
    }

    public static String createGetAttrSignature(String name, String typeSignature) {
        assert (name != null && name.length() > 0) : "Invalid empty name: " + name;
        StringBuilder getter = new StringBuilder();
        name = JavaClass.nameForGetter(name);
        getter.append('M');
        getter.append(name);
        getter.append("()");
        getter.append(typeSignature);
        return getter.toString();
    }

    public static String createSetAttrSignature(String name, String typeSignature) {
        StringBuilder setter = new StringBuilder();
        name = JavaClass.nameForSetter(name);
        setter.append('M');
        setter.append(name);
        setter.append("(");
        setter.append(typeSignature);
        setter.append(")");
        setter.append('V');
        return setter.toString();
    }

    public static synchronized JavaClass<?> forName(String javaType) throws ClassNotFoundException {
        try {
            Class<?> c = JavaClass.loadByJavaType(javaType);
            return JavaClass.fromClass(c);
        }
        catch (VerifyError e) {
            e.printStackTrace();
            throw new ClassNotFoundException(javaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> JavaClass<T> fromClass(Class<T> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Attempt to create a JavaClass from 'null'");
        }
        ClassLoader loader = cl.getClassLoader();
        if (loader instanceof FuegoClassLoader) {
            FuegoClassLoader fuegoLoader = (FuegoClassLoader)loader;
            return fuegoLoader.getJavaClass(cl);
        }
        Class<JavaClass> clazz = JavaClass.class;
        synchronized (JavaClass.class) {
            JavaClass<T> javaClass = JavaClass.cast(classCache.get(cl), cl);
            if (javaClass != null) return javaClass;
            javaClass = new JavaClass<T>(cl);
            classCache.put(cl, javaClass);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return javaClass;
        }
    }

    public static Field[] getAllFields(Class cl) {
        Field[] flds = null;
        while (cl != null) {
            if (flds == null) {
                flds = cl.getDeclaredFields();
            } else {
                Field[] declFields = cl.getDeclaredFields();
                int len = declFields.length;
                Field[] newfields = new Field[flds.length + len];
                System.arraycopy(flds, 0, newfields, 0, flds.length);
                System.arraycopy(declFields, 0, newfields, flds.length, len);
                flds = newfields;
            }
            cl = cl.getSuperclass();
        }
        return flds;
    }

    public static Map getClassCache() {
        return classCache;
    }

    public static String getClassNameFromSignature(String signature) {
        if (signature == null) {
            return null;
        }
        int length = signature.length();
        if (signature.charAt(0) != 'L' || signature.charAt(length - 1) != ';') {
            throw new InvalidSignatureException(signature);
        }
        return signature.substring(1, length - 1);
    }

    public static Method getDeclaredMethod(Class<?> cl, String methodName, Class[] args) throws NoSuchMethodException {
        Method method = null;
        for (Class<?> current = cl; current != null; current = current.getSuperclass()) {
            try {
                method = current.getDeclaredMethod(methodName, args);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (method == null) {
            throw new NoSuchMethodException(methodName + " not found in class " + cl);
        }
        return method;
    }

    public static String getFieldNameFromSignature(String signature) {
        if (signature == null) {
            return null;
        }
        int index = signature.indexOf(59);
        if (signature.charAt(0) != 'A' || index == -1) {
            throw new InvalidSignatureException(signature);
        }
        return signature.substring(1, index);
    }

    public static Object getFieldValue(Object instance, String fieldName) throws InvocationTargetException {
        try {
            Class<?> cl = instance.getClass();
            String methodName = JavaClass.nameForGetter(fieldName);
            Method method = cl.getMethod(methodName, new Class[0]);
            return method.invoke(instance, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static Class getHolderType(Class holder) {
        Class<Object> type;
        block3: {
            if (holder == null || !JavaClass.isHolder(holder)) {
                return null;
            }
            type = null;
            try {
                type = holder.getField(VALUE_FIELD).getType();
            }
            catch (NoSuchFieldException e) {
                if (!Holder.class.isAssignableFrom(holder)) break block3;
                type = Object.class;
            }
        }
        return type;
    }

    public static Object getHolderValue(Object holder) throws Exception {
        if (holder instanceof Holder) {
            Holder h = (Holder)holder;
            return h.get();
        }
        Class<?> cl = holder.getClass();
        try {
            Field field = cl.getField(VALUE_FIELD);
            return field.get(holder);
        }
        catch (NoSuchFieldException e) {
            Log.logSevere(e);
            throw new NoSuchFieldException(e.getMessage() + ", class: " + cl.getName());
        }
    }

    public static String getJavaType(Class clazz) {
        if (clazz.isArray()) {
            return JavaClass.getJavaType(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getMethodNameFromSignature(String signature) throws InvalidSignatureException {
        int dotIndex;
        if (signature == null) {
            return null;
        }
        int index = signature.indexOf("(");
        if (signature.charAt(0) != 'M' && signature.charAt(0) != 'K' || index == -1) {
            throw new InvalidSignatureException(signature);
        }
        String name = signature.substring(1, index);
        if (signature.charAt(0) == 'K' && (dotIndex = name.lastIndexOf(".") + 1) > 0) {
            name = name.substring(dotIndex);
        }
        return name;
    }

    public static String getResultTypeFromSignature(String signature) {
        if (signature == null) {
            return null;
        }
        int index = signature.indexOf(")");
        if (signature.charAt(0) != 'M' && signature.charAt(0) != 'K' || index == -1) {
            throw new InvalidSignatureException(signature);
        }
        return signature.substring(index + 1);
    }

    public static String getName(Class cl) {
        String name = cl.isArray() ? JavaClass.getName(cl.getComponentType()) + "[]" : cl.getName().replace('$', '.');
        return name;
    }

    public static String getNameFromAccessor(Method accessor) {
        String name = accessor.getName();
        name = JavaClass.isGetter(accessor) ? (name.startsWith("get") ? Character.toLowerCase(name.charAt(3)) + name.substring(4) : Character.toLowerCase(name.charAt(2)) + name.substring(3)) : (JavaClass.isSetter(accessor) ? Character.toLowerCase(name.charAt(3)) + name.substring(4) : null);
        return name;
    }

    public static Field getParentField(Class clazz) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(PARENT_THIS0);
        }
        catch (NoSuchFieldException e) {
            field = clazz.getDeclaredField("this_0");
        }
        return field;
    }

    public static String getSignature(Method method) {
        Class<?>[] params;
        StringBuilder buffer = new StringBuilder();
        buffer.append('M');
        buffer.append(method.getName());
        buffer.append("(");
        for (Class<?> param : params = method.getParameterTypes()) {
            buffer.append(JavaClass.getSignature(param));
        }
        buffer.append(")");
        buffer.append(JavaClass.getSignature(method.getReturnType()));
        return buffer.toString();
    }

    public static String getSignature(Field field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('A');
        buffer.append(field.getName());
        buffer.append(';');
        buffer.append(JavaClass.getSignature(field.getType()));
        return buffer.toString();
    }

    public static String getSignature(Class clazz) {
        char c = PrimitiveTypeUtils.signature(clazz);
        String result = c != '\u0000' ? String.valueOf(c) : (clazz.isArray() ? '[' + JavaClass.getSignature(clazz.getComponentType()) : 'L' + clazz.getName() + ';');
        return result;
    }

    public static String getSignature(AccessibleObject object) {
        if (object instanceof Field) {
            return JavaClass.getSignature((Field)object);
        }
        if (object instanceof Method) {
            return JavaClass.getSignature((Method)object);
        }
        if (object instanceof Constructor) {
            return JavaClass.getSignature((Constructor)object);
        }
        return null;
    }

    public static String getSignature(Constructor constructor) {
        Class<?>[] params;
        StringBuilder buffer = new StringBuilder();
        buffer.append('K');
        buffer.append(constructor.getDeclaringClass().getName());
        buffer.append("(");
        for (Class<?> param : params = constructor.getParameterTypes()) {
            buffer.append(JavaClass.getSignature(param));
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static Object invokeMethodByName(Class<?> cl, Object instance, String name, Object[] args, Class[] argClasses) throws InvocationTargetException, NoSuchMethodException {
        return JavaClass.fromClass(cl).invokeMethodByName(instance, name, args, argClasses);
    }

    public static Object invokeStaticMethod(String signature, Object[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        int sep = signature.indexOf(58);
        if (signature.charAt(0) != 'L' || sep == -1) {
            throw new IllegalArgumentException("Invalid signature: " + signature);
        }
        JavaClass<?> javaClass = JavaClass.forName(signature.substring(1, sep));
        return javaClass.invokeMethod(null, signature.substring(sep + 1), args);
    }

    public static boolean isAttribute(String memberSignature) {
        return memberSignature != null && memberSignature.charAt(0) == 'A';
    }

    public static boolean isCollection(Class cl) {
        return List.class.isAssignableFrom(cl) || Set.class.isAssignableFrom(cl) || Map.class.isAssignableFrom(cl);
    }

    public static boolean isContainer(Class cl) {
        return cl.isArray() || JavaClass.isCollection(cl) || Map.Entry.class.isAssignableFrom(cl) || JavaClass.isReference(cl) || JavaClass.isHolder(cl);
    }

    public static boolean isGetter(Method method) {
        if (method != null) {
            String name = method.getName();
            return JavaUtils.isGetter(name);
        }
        return false;
    }

    public static boolean isHolder(Class<?> cl) {
        if (cl == null || !cl.getName().endsWith(HOLDER_CLASS_EXT)) {
            return false;
        }
        try {
            Field field = cl.getField(VALUE_FIELD);
            cl.getConstructor(new Class[0]);
            cl.getConstructor(field.getType());
            return true;
        }
        catch (NoSuchFieldException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Holder.class.isAssignableFrom(cl);
    }

    public static boolean isMethod(String memberSignature) {
        return memberSignature != null && memberSignature.charAt(0) == 'M';
    }

    public static boolean isPrimitiveType(String javaType) {
        return PrimitiveTypeUtils.isPrimitive(javaType);
    }

    public static boolean isReference(Class cl) {
        return Reference.class.isAssignableFrom(cl);
    }

    public static boolean isSetter(Method method) {
        if (method != null) {
            String name = method.getName();
            return JavaUtils.isSetter(name);
        }
        return false;
    }

    public static Class<?> loadByJavaType(String javaType) throws ClassNotFoundException {
        return JavaClass.loadByJavaType(javaType, Thread.currentThread().getContextClassLoader());
    }

    public static Class loadByJavaType(String javaType, ClassLoader loader) throws ClassNotFoundException {
        return JavaClass.loadByJavaType(javaType, loader, false);
    }

    public static Class<?> loadByJavaType(String javaType, ClassLoader loader, boolean resolve) throws ClassNotFoundException {
        Class<?> result;
        if (javaType.endsWith("[]")) {
            String elementType = javaType.substring(0, javaType.length() - 2);
            result = Array.newInstance(JavaClass.loadByJavaType(elementType, loader, resolve), 0).getClass();
        } else {
            result = PrimitiveTypeUtils.classForName(javaType);
            if (result == null) {
                result = JavaClass.loadClass(javaType, loader, resolve);
            }
        }
        return result;
    }

    public static Class loadClass(String classname) throws ClassNotFoundException {
        return JavaClass.loadClass(classname, Thread.currentThread().getContextClassLoader());
    }

    public static Class loadClass(String classname, ClassLoader loader) throws ClassNotFoundException {
        return JavaClass.loadClass(classname, loader, false);
    }

    public static Class loadClass(String classname, ClassLoader loader, boolean resolve) throws ClassNotFoundException {
        try {
            return Class.forName(classname, resolve, loader);
        }
        catch (ClassNotFoundException e) {
            int lastDot = classname.lastIndexOf(46);
            if (lastDot != -1) {
                String left = classname.substring(0, lastDot);
                String right = classname.substring(lastDot + 1);
                classname = left + "$" + right;
                try {
                    return JavaClass.loadClass(classname, loader, resolve);
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(e.toString());
        }
        catch (NoClassDefFoundError e) {
            Log.logSevere(e);
            String referencedClass = e.getMessage();
            if (referencedClass != null) {
                if (referencedClass.charAt(0) == 'L' && referencedClass.endsWith(";")) {
                    referencedClass = referencedClass.substring(1, referencedClass.length() - 1);
                }
                throw new ClassNotFoundException(CoreMsg.CLASS_DEF_NOT_FOUND(classname, referencedClass).getString());
            }
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            String message = "";
            do {
                String stackTrace = StackTrace.getUserStackTrace(cause);
                message = message + "\n" + cause.toString() + "\n" + stackTrace;
            } while ((cause = cause.getCause()) != null);
            throw new ClassNotFoundException(CoreMsg.EXCEPTION_IN_INITIALIZER(classname, message).getString());
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            String message = "";
            do {
                String stackTrace = StackTrace.getUserStackTrace(cause);
                message = message + "\n" + cause.toString() + "\n" + stackTrace;
            } while ((cause = cause.getCause()) != null);
            Log.logSevere(e);
            throw new ClassNotFoundException(CoreMsg.EXCEPTION_IN_INITIALIZER(classname, message).getString());
        }
    }

    @NonNls
    public static String nameForGetter(String name) {
        return "get" + JavaClass.makeProperName(name);
    }

    @NonNls
    public static String nameForSetter(String name) {
        return "set" + JavaClass.makeProperName(name);
    }

    public static Object replaceReference(Object reference, Object replacement) {
        return JavaClass.replaceReference(reference, reference, replacement, DEFAULT_ALLOWED_CLASSES);
    }

    public static Object replaceReference(Object reference, Object replacement, Set allowedClasses) {
        return JavaClass.replaceReference(reference, reference, replacement, allowedClasses);
    }

    public static Object replaceReference(Object graph, Object reference, Object replacement, Set allowedClasses) {
        return JavaClass.replaceReference(graph, reference, replacement, new IdentityHashMap<Object, Object>(), allowedClasses);
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        block6: {
            boolean primitive = field.getType().isPrimitive();
            if (value == null && primitive) {
                value = DefaultValue.forClass(field.getType());
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (Modifier.isFinal(field.getModifiers()) && unsafe != null) {
                JavaClass.setFinalFieldValue(field, primitive, instance, value);
            } else {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    public static void setHolderValue(Object holder, Object value) throws Exception {
        if (holder instanceof Holder) {
            Holder h = (Holder)Cast.force(holder);
            h.put(value);
        } else {
            Class<?> cl = holder.getClass();
            Field field = cl.getField(VALUE_FIELD);
            if (value == null && field.getType().isPrimitive()) {
                value = DefaultValue.forClass(field.getType());
            }
            field.set(holder, value);
        }
    }

    public boolean containsMethod(String methodSignature) {
        return methodSignature.charAt(0) == 'M' && this.getMethod(methodSignature) != null;
    }

    public Field[] getAllFields() {
        return JavaClass.getAllFields(this.jclass);
    }

    public Object getAttributeValue(String signature, Object target) {
        try {
            this.loadInfo();
            char type = signature.charAt(0);
            switch (type) {
                case 'M': {
                    return this.invokeMethod(target, signature, new Object[0]);
                }
                case 'A': {
                    Field field = this.getRequiredField(signature);
                    if (target == null && !Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalArgumentException("Attempt to get non-static field '" + signature + "' from null target from class '" + this.getName() + "'");
                    }
                    return field.get(target);
                }
                case '!': {
                    int pos = signature.lastIndexOf(58);
                    int index = Integer.parseInt(signature.substring(pos + 1));
                    signature = signature.substring(1, pos);
                    Object array = this.getAttributeValue(signature, target);
                    int length = Array.getLength(array);
                    assert (index >= 0 && index < length) : "Index out of bounds. (index: " + index + ", arrayLength: " + length + ", array: " + signature + ")" + " from '" + this.getName() + "'";
                    return Array.get(array, index);
                }
            }
            throw new IllegalArgumentException("Invalid signature: " + signature);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeExceptionShell(e, this.msg(signature, null, target));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeExceptionShell(e, this.msg(signature, null, target));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeExceptionShell(e, this.msg(signature, null, target));
        }
    }

    public Object getAttributeValue(String signature, String setter, T target) {
        Object result = this.getAttributeValue(signature, target);
        if (setter != null && result == null) {
            try {
                Class<?> type = this.getReturnType(signature);
                result = type.newInstance();
                this.setAttributeValue(setter, result, target);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public Object getAttributeValue(String signature, String setter, int index, T target) {
        Object o = this.getAttributeValue(signature, setter, target);
        if (o != null) {
            if (o instanceof List && index != -1) {
                return ((List)o).get(index);
            }
            if (o.getClass().isArray() && index != -1) {
                return Array.get(o, index);
            }
        }
        return o;
    }

    public Constructor<T> getConstructor(String signature) {
        assert (signature.charAt(0) == 'K') : signature;
        this.loadInfo();
        return this.constructorCache.get(signature);
    }

    public Field getField(String signature) {
        assert (signature.charAt(0) == 'A') : signature;
        this.loadInfo();
        return this.fieldCache.get(signature);
    }

    public HolderConstructors[] getHoldersForMethod(String methodSignature) {
        return this.getHolders().get(methodSignature);
    }

    public Method getMethod(String signature) {
        assert (signature.charAt(0) == 'M') : signature;
        this.loadInfo();
        return this.methodCache.get(signature);
    }

    public Method[] getMethodByNameAndParamQty(String name, int paramQty) throws NoSuchMethodException {
        ArrayList<Method> methodList = new ArrayList<Method>();
        List<Method> methods = this.getMethodsByName().get(name);
        if (methods == null) {
            throw new NoSuchMethodException("'" + name + "' is not a method of '" + this.getName() + "'");
        }
        for (Method method : methods) {
            if (method.getParameterTypes().length != paramQty) continue;
            methodList.add(method);
        }
        if (methodList.isEmpty()) {
            throw new NoSuchMethodException("'" + name + "' with '" + paramQty + "' params is not a method of '" + this.getName() + "'");
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public String getName() {
        return this.jclass.getName();
    }

    public Class getOriginalClass() {
        return this.jclass;
    }

    public Class<?> getReturnType(String signature) {
        switch (signature.charAt(0)) {
            case 'A': {
                Field field = this.getRequiredField(signature);
                return field.getType();
            }
            case 'M': {
                Method method = this.getRequiredMethod(signature);
                return method.getReturnType();
            }
            case 'K': {
                return this.jclass;
            }
        }
        throw new IllegalArgumentException("Illegal signature : " + signature);
    }

    public long getSerialId() {
        if (this.serialId == null) {
            ObjectStreamClass osc = ObjectStreamClass.lookup(this.jclass);
            this.serialId = osc != null ? Long.valueOf(osc.getSerialVersionUID()) : NO_SERIAL_VERSION;
        }
        return this.serialId;
    }

    public boolean hasDefaultConstructor() {
        if (!this.defaultConstructorInit) {
            this.defaultConstructor = JavaClass.getDefaultConstructor(this.jclass);
            if (this.defaultConstructor != null) {
                this.defaultConstructor.setAccessible(true);
            }
            this.defaultConstructorInit = true;
        }
        return this.defaultConstructor != null;
    }

    public T instantiate() throws InstantiationException, IllegalAccessException {
        return this.jclass.newInstance();
    }

    @Override
    public Object invoke(Object target, String memberSignature, Object[] args) throws Exception {
        if (target instanceof Invokeable) {
            Invokeable invokeable = (Invokeable)target;
            return invokeable.invoke(memberSignature, args);
        }
        return this.invokeMethod(this.jclass.cast(target), memberSignature, args);
    }

    public Object invokeMethod(Object target, String methodSignature, Object ... args) throws IllegalAccessException, InvocationTargetException {
        Method method = this.getRequiredMethod(methodSignature);
        try {
            return method.invoke(target, args);
        }
        catch (NullPointerException e) {
            if (target == null && !Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(CoreMsg.NULL_INVOCATION(method.getName(), this.getName()).toString());
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            String msg = "Illegal Arguments: '" + Arrays.asList(args) + "'.\n";
            msg = msg + "For method '" + method + "'.\n";
            msg = msg + "Target Instance: '" + target + "'.\n";
            msg = msg + "Class: '" + JavaClass.classInfo(target) + "'.\n";
            msg = msg + "Original message:\n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
    }

    public Object invokeMethodByName(Object instance, String name, Object[] args) throws InvocationTargetException, NoSuchMethodException {
        int length = args.length;
        Class[] argTypes = new Class[length];
        for (int i = 0; i < length; ++i) {
            argTypes[i] = args[i] != null ? args[i].getClass() : null;
        }
        return this.invokeMethodByName(instance, name, args, argTypes);
    }

    public Object invokeMethodByName(Object instance, String name, Object[] args, Class[] argClasses) throws InvocationTargetException, NoSuchMethodException {
        try {
            JavaClass<T> current = this;
            List<Method> methodObject = null;
            while (current != null && (methodObject = current.getMethodsByName().get(name)) == null) {
                Class<T> javaSuperClass = current.jclass.getSuperclass();
                current = javaSuperClass != null ? JavaClass.fromClass(javaSuperClass) : null;
            }
            if (methodObject == null) {
                throw new NoSuchMethodException("'" + name + "' is not a method of '" + this.getName() + "'");
            }
            Method method = null;
            if (methodObject instanceof List) {
                List<Method> all = methodObject;
                for (Method anAll : all) {
                    Method possibleMethod = anAll;
                    if (!super.canBeCalledWith(possibleMethod, args, argClasses)) continue;
                    method = possibleMethod;
                    break;
                }
            } else {
                Method possibleMethod = (Method)((Object)methodObject);
                if (super.canBeCalledWith(possibleMethod, args, argClasses)) {
                    method = possibleMethod;
                }
            }
            if (method != null) {
                return method.invoke(instance, args);
            }
            throw new NoSuchMethodException("Could not find method '" + name + "' in '" + this.getName() + "' with " + "arguments " + super.getArgumentTypes(args));
        }
        catch (IllegalAccessException e) {
            throw new InvocationTargetException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationTargetException(e);
        }
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.jclass.getModifiers());
    }

    public boolean isClass() {
        return !this.jclass.isInterface();
    }

    public boolean isCloneable() {
        return Cloneable.class.isAssignableFrom(this.jclass);
    }

    public boolean isComparable() {
        return Comparable.class.isAssignableFrom(this.jclass);
    }

    public boolean isExternalizable() {
        return Externalizable.class.isAssignableFrom(this.jclass);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.jclass.getModifiers());
    }

    public boolean isInterface() {
        return this.jclass.isInterface();
    }

    public boolean isPackage() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.jclass.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.jclass.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.jclass.getModifiers());
    }

    public boolean isSerializable() {
        return Serializable.class.isAssignableFrom(this.jclass);
    }

    public T newInstance() throws InstantiationException, InvocationTargetException {
        T result;
        block7: {
            if (this.isInterface() || this.isAbstract()) {
                throw new InstantiationException(this.getName());
            }
            result = null;
            try {
                if (this.hasDefaultConstructor()) {
                    result = this.defaultConstructor.newInstance(new Object[0]);
                }
                if (result == null && this.isSerializable()) {
                    result = this.newSerializableClassInstance();
                }
                if (result == null) {
                    Constructor<T> cons = this.getSerializableConstructor();
                    result = cons.newInstance(new Object[0]);
                }
            }
            catch (LinkageError err) {
                InstantiationException e = new InstantiationException(this.getName());
                e.initCause(err);
                throw e;
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    public T newInstance(String signature, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        try {
            return this.constructorFromSignature(signature).newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal Arguments: '" + Arrays.asList(args) + "' for constructor '" + signature + "'. Original message: " + e.getMessage());
        }
    }

    public void setAttributeValue(String signature, Object value, Object target) {
        block6: {
            try {
                char type = signature.charAt(0);
                if (type == 'M') {
                    this.invokeMethod(target, signature, value);
                    break block6;
                }
                if (type == 'A') {
                    Field field = this.getRequiredField(signature);
                    if (target == null && !Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalArgumentException("Attempt to set non-static field '" + signature + "' to null target from class '" + this.getName() + "'");
                    }
                    field.set(target, value);
                    break block6;
                }
                throw new IllegalArgumentException("Invalid signature: " + signature);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeExceptionShell(e, this.msg(signature, value, target));
            }
            catch (InvocationTargetException e) {
                throw new RuntimeExceptionShell(e.getTargetException(), this.msg(signature, value, target));
            }
        }
    }

    public String toString() {
        return "JavaClass(" + this.getName() + ")";
    }

    public void unwrapOutputArgs(String methodSignature, Object[] outputArgs) throws Exception {
        int length;
        HolderConstructors[] holdersInit = this.getHolderContructorsForMethod(methodSignature);
        int n = length = holdersInit != null ? holdersInit.length : 0;
        if (holdersInit != null) {
            for (int i = 0; i < length; ++i) {
                if (holdersInit[i] == null) continue;
                outputArgs[i] = JavaClass.getHolderValue(outputArgs[i]);
            }
        }
    }

    public void wrapInputArgs(String methodSignature, Object[] inputArgs) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        int length;
        HolderConstructors[] holdersInit = this.getHolderContructorsForMethod(methodSignature);
        int n = length = holdersInit != null ? holdersInit.length : 0;
        if (holdersInit != null) {
            Object[] holderArgs = new Object[1];
            for (int i = 0; i < length; ++i) {
                HolderConstructors init = holdersInit[i];
                if (init == null) continue;
                Object value = inputArgs[i];
                if (value != null) {
                    holderArgs[0] = value;
                    inputArgs[i] = init.withArg.newInstance(holderArgs);
                    continue;
                }
                inputArgs[i] = init.withoutArg.newInstance(null);
            }
        }
    }

    static <T> JavaClass<T> cast(JavaClass<?> javaClass, Class<T> clazz) {
        if (javaClass != null && !javaClass.getName().equals(clazz.getName())) {
            throw new ClassCastException();
        }
        return (JavaClass)Cast.force(javaClass);
    }

    private static void skipConstants(DataInputStream bytecode) throws IOException {
        int constantPoolCount = bytecode.readShort();
        block9: for (int i = 1; i < constantPoolCount; ++i) {
            byte tag = bytecode.readByte();
            switch (tag) {
                case 7: {
                    bytecode.readShort();
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    bytecode.readShort();
                    bytecode.readShort();
                    continue block9;
                }
                case 8: {
                    bytecode.readShort();
                    continue block9;
                }
                case 3: 
                case 4: {
                    bytecode.readInt();
                    continue block9;
                }
                case 5: {
                    bytecode.readInt();
                    bytecode.readInt();
                    ++i;
                    continue block9;
                }
                case 6: {
                    bytecode.readInt();
                    bytecode.readInt();
                    ++i;
                    continue block9;
                }
                case 1: {
                    bytecode.skip(bytecode.readUnsignedShort());
                }
            }
        }
    }

    private static String makeProperName(String name) {
        char first = name.charAt(0);
        char firstUp = Character.toUpperCase(first);
        int nameLen = name.length();
        StringBuilder result = new StringBuilder(nameLen + 2);
        result.append(firstUp).append(name, 1, nameLen);
        if (Character.isUpperCase(first)) {
            result.append("$U");
        }
        return result.toString();
    }

    private static <T> Constructor<T> getDefaultConstructor(Class<T> jclass) {
        for (Constructor<?> constructor : jclass.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return (Constructor)Cast.force(constructor);
        }
        return null;
    }

    private static HolderConstructors[] getHolderContructorsForMethod(Method method) {
        HolderConstructors[] constructors = null;
        Class[] holders = JavaClass.getHoldersForMethod(method);
        if (holders != null) {
            for (int i = 0; i < holders.length; ++i) {
                Class holder = holders[i];
                if (holder == null) continue;
                if (constructors == null) {
                    constructors = new HolderConstructors[holders.length];
                }
                Class holderType = JavaClass.getHolderType(holder);
                try {
                    HolderConstructors hc = new HolderConstructors();
                    hc.withArg = holders[i].getConstructor(holderType);
                    hc.withoutArg = holders[i].getConstructor(new Class[0]);
                    constructors[i] = hc;
                    continue;
                }
                catch (NoSuchMethodException ignore) {
                    // empty catch block
                }
            }
        }
        return constructors;
    }

    private static Class[] getHoldersForMethod(Method method) {
        Class[] holders = null;
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (!JavaClass.isHolder(params[i])) continue;
            if (holders == null) {
                holders = new Class[params.length];
            }
            holders[i] = params[i];
        }
        return holders;
    }

    private static boolean isAllowedClass(Class cl, Set allowedClasses) {
        boolean allowed = allowedClasses == null;
        String name = cl.getName();
        while (!allowed && name != null) {
            allowed = allowedClasses.contains(name);
            if (allowed) continue;
            int dot = name.lastIndexOf(46);
            if (dot != -1) {
                name = name.substring(0, dot);
                continue;
            }
            name = null;
        }
        return allowed;
    }

    private static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    private static Object replaceReference(Object graph, Object reference, Object replacement, IdentityHashMap<Object, Object> references, Set allowedClasses) {
        boolean mustRecurse;
        Class<?> replacementClass;
        Class<?> refClass = reference.getClass();
        if (refClass != (replacementClass = replacement.getClass())) {
            throw new IllegalArgumentException("reference " + refClass + " != replacement " + replacementClass);
        }
        if (graph == null) {
            return null;
        }
        Class<?> graphClass = graph.getClass();
        Object newGraph = references.get(graph);
        if (newGraph != null) {
            return newGraph;
        }
        newGraph = graph != reference ? graph : replacement;
        references.put(graph, newGraph);
        boolean bl = mustRecurse = JavaClass.isContainer(graphClass) || JavaClass.isAllowedClass(graphClass, allowedClasses);
        if (!mustRecurse) {
            return newGraph;
        }
        Class<?> cl = newGraph.getClass();
        for (Field field : JavaClass.getAllFields(cl)) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            boolean isPrimitive = type.isPrimitive() || type == String.class;
            try {
                Object value;
                try {
                    value = field.get(graph);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Could not get value for field '" + field + "' from target class: " + cl + ". Source: " + graph);
                }
                Object newValue = value;
                if (!isPrimitive) {
                    newValue = JavaClass.replaceReference(value, reference, replacement, references, allowedClasses);
                }
                if (newValue == value && newGraph == graph || JavaClass.isFinal(field)) continue;
                field.set(newGraph, newValue);
            }
            catch (IllegalAccessException e) {
                assert (false) : e.toString();
            }
        }
        return newGraph;
    }

    private static void setFinalFieldValue(Field field, boolean primitive, Object instance, Object value) {
        Unsafe unsafe = (Unsafe)JavaClass.unsafe;
        long offset = Modifier.isStatic(field.getModifiers()) ? unsafe.staticFieldOffset(field) : unsafe.objectFieldOffset(field);
        if (primitive) {
            char signature = PrimitiveTypeUtils.signature(field.getType());
            switch (signature) {
                case 'B': {
                    unsafe.putByte(instance, offset, (Byte)value);
                    break;
                }
                case 'S': {
                    unsafe.putShort(instance, offset, (Short)value);
                    break;
                }
                case 'I': {
                    unsafe.putInt(instance, offset, (Integer)value);
                    break;
                }
                case 'J': {
                    unsafe.putLong(instance, offset, (Long)value);
                    break;
                }
                case 'F': {
                    unsafe.putFloat(instance, offset, ((Float)value).floatValue());
                    break;
                }
                case 'D': {
                    unsafe.putDouble(instance, offset, (Double)value);
                    break;
                }
                case 'Z': {
                    unsafe.putBoolean(instance, offset, (Boolean)value);
                    break;
                }
                case 'C': {
                    unsafe.putChar(instance, offset, ((Character)value).charValue());
                    break;
                }
                default: {
                    assert (false) : "Unexpected primitive type: " + signature + ", field: " + field;
                    {
                        break;
                    }
                }
            }
        } else {
            unsafe.putObject(instance, offset, value);
        }
    }

    private Constructor<T> constructorFromSignature(String signature) throws NoSuchMethodException {
        Constructor<T> cons = this.getConstructor(signature);
        if (cons != null) {
            return cons;
        }
        StringBuilder text = new StringBuilder();
        for (String o : this.constructorCache.keySet()) {
            text.append(o.toString());
            text.append("\n");
        }
        throw new NoSuchMethodException("'" + signature + "' in class '" + this.jclass.getName() + "'" + text.toString());
    }

    private Field getRequiredField(String signature) {
        Field field = this.getField(signature);
        if (field == null) {
            throw new IllegalArgumentException("No such field: '" + signature + "' in class '" + this.getName() + "'");
        }
        return field;
    }

    private Method getRequiredMethod(String methodSignature) {
        Method method = this.getMethod(methodSignature);
        if (method == null) {
            throw new IllegalArgumentException("No such method: '" + methodSignature + "' in class '" + this.getName() + "'");
        }
        return method;
    }

    private boolean canBeCalledWith(Method method, Object[] args, Class[] argClasses) {
        Class<?>[] expectedTypes = method.getParameterTypes();
        if (expectedTypes.length != argClasses.length || args.length != argClasses.length) {
            return false;
        }
        for (int i = 0; i < expectedTypes.length; ++i) {
            Class<?> expectedType = expectedTypes[i];
            Class actualType = argClasses[i];
            if (actualType == null || expectedType.isAssignableFrom(actualType)) continue;
            return false;
        }
        return true;
    }

    @NonNls
    private String getArgumentTypes(Object[] args) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(arg != null ? arg.getClass().getName() : "<any>");
        }
        return buffer.toString();
    }

    private HolderConstructors[] getHolderContructorsForMethod(String methodSignature) {
        return this.getHolders().get(methodSignature);
    }

    private Map<String, HolderConstructors[]> getHolders() {
        this.loadInfo();
        return this.holders;
    }

    private Map<String, List<Method>> getMethodsByName() {
        this.loadInfo();
        return this.methodsByName;
    }

    private Constructor<T> getSerializableConstructor() {
        if (this.hackConstructor == null) {
            if (this.hasDefaultConstructor()) {
                this.hackConstructor = this.defaultConstructor;
            } else {
                Constructor<Object> cons = null;
                Class<T> initCl = this.jclass;
                while (cons == null) {
                    initCl = initCl.getSuperclass();
                    cons = JavaClass.getDefaultConstructor(initCl);
                }
                ReflectionFactory reflectionFactory = (ReflectionFactory)new ReflectionFactory.GetReflectionFactoryAction().run();
                cons = reflectionFactory.newConstructorForSerialization(this.jclass, cons);
                cons.setAccessible(true);
                this.hackConstructor = (Constructor)Cast.force(cons);
            }
        }
        return this.hackConstructor;
    }

    private synchronized void loadInfo() {
        if (this.constructorCache != null) {
            return;
        }
        try {
            String signature;
            this.methodCache = new HashMap<String, Method>();
            this.holders = new HashMap<String, HolderConstructors[]>();
            for (Method method : this.jclass.getMethods()) {
                if (Modifier.isPublic(method.getModifiers()) && !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    method.setAccessible(true);
                }
                signature = JavaClass.getSignature(method).intern();
                String signatureWithoutReturnType = signature.substring(0, signature.lastIndexOf(")") + 1).intern();
                this.methodCache.put(signature, method);
                this.methodCache.put(signatureWithoutReturnType, method);
                this.addToMethodsByName(method);
                HolderConstructors[] constructors = JavaClass.getHolderContructorsForMethod(method);
                if (constructors == null) continue;
                this.holders.put(signature, constructors);
            }
            this.fieldCache = new HashMap<String, Field>();
            for (AccessibleObject accessibleObject : JavaClass.getAllFields(this.jclass)) {
                signature = JavaClass.getSignature((Field)accessibleObject);
                if (this.fieldCache.containsKey(signature)) continue;
                this.fieldCache.put(signature, (Field)accessibleObject);
            }
            this.constructorCache = new HashMap<String, Constructor<T>>();
            for (AccessibleObject accessibleObject : this.jclass.getConstructors()) {
                Constructor cons = (Constructor)Cast.force(accessibleObject);
                this.constructorCache.put(JavaClass.getSignature(cons), cons);
            }
        }
        catch (NoClassDefFoundError e) {
            NoClassDefFoundError exc = new NoClassDefFoundError(e.getMessage() + " - Class loader: " + this.jclass.getClassLoader());
            exc.initCause(e);
            throw exc;
        }
    }

    private void addToMethodsByName(Method method) {
        List<Method> methods;
        if (this.methodsByName == null) {
            this.methodsByName = new HashMap<String, List<Method>>();
        }
        if ((methods = this.methodsByName.get(method.getName())) == null) {
            methods = new ArrayList<Method>(1);
            this.methodsByName.put(method.getName(), methods);
        }
        methods.add(method);
    }

    private String msg(String signature, Object value, Object target) {
        StringBuilder msg = new StringBuilder();
        msg.append("signature = ");
        msg.append(signature);
        msg.append(", value = ");
        if (value == null) {
            msg.append("null");
        } else {
            msg.append(value.toString());
            msg.append('(');
            msg.append(value.getClass().getName());
            msg.append(')');
        }
        msg.append(", target = ");
        if (target == null) {
            msg.append("null");
        } else {
            msg.append(target.toString());
            msg.append('(');
            msg.append(target.getClass().getName());
            msg.append(')');
        }
        return msg.toString();
    }

    private T newSerializableClassInstance() throws InvocationTargetException {
        T result;
        block5: {
            result = null;
            try {
                if (this.instantiator == null) {
                    this.streamClass = ObjectStreamClass.lookup(this.jclass);
                    this.instantiator = this.streamClass.getClass().getDeclaredMethod(NEW_INSTANCE_METHOD, new Class[0]);
                    this.instantiator.setAccessible(true);
                }
                result = this.jclass.cast(this.instantiator.invoke((Object)this.streamClass, new Object[0]));
            }
            catch (IllegalAccessException e) {
                assert (false) : e;
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws Exception {
        stream.defaultReadObject();
        JavaClass javaClass = this;
        synchronized (javaClass) {
        }
    }

    static {
        DEFAULT_ALLOWED_CLASSES.add("xobject");
        DEFAULT_ALLOWED_CLASSES.add("oracle.bpm.xobject.runtime.components");
        NO_SERIAL_VERSION = -1L;
        classCache = new HashMap<Class, JavaClass>();
        try {
            Field unsafeField = Unsafe.class.getDeclaredField(UNSAFE_FIELD);
            unsafeField.setAccessible(true);
            unsafe = unsafeField.get(null);
        }
        catch (NoSuchFieldException e) {
            System.err.println(UNSAFE_OPERATIONS_NOT_SUPPORTED);
        }
        catch (IllegalAccessException e) {
            System.err.println(UNSAFE_OPERATIONS_NOT_SUPPORTED);
        }
        catch (LinkageError e) {
            System.err.println(UNSAFE_OPERATIONS_NOT_SUPPORTED);
        }
    }

    static final class HolderConstructors {
        Constructor withArg;
        Constructor withoutArg;

        HolderConstructors() {
        }
    }
}

