/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Str;

public final class IntervalFormat
extends Format {
    private Locale locale_d;
    private transient NumberFormat numberFormat_d;
    private String pattern_d;
    static final long serialVersionUID = -4443338217260832812L;
    static final long serialCheck = -8918333596727082118L;

    public IntervalFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public IntervalFormat(String pattern, Locale locale) {
        this.pattern_d = pattern;
        this.locale_d = locale;
        this.initialize();
    }

    public static IntervalFormat getInstance() {
        return IntervalFormat.getInstance(IntervalUnit.MONTHS, IntervalUnit.SECONDS, Locale.getDefault());
    }

    public static IntervalFormat getInstance(IntervalUnit from, IntervalUnit to) {
        return IntervalFormat.getInstance(from, to, Locale.getDefault());
    }

    public static IntervalFormat getInstance(IntervalUnit from, IntervalUnit to, Locale locale) {
        if (from == null) {
            from = IntervalUnit.YEARS;
        } else if (from.compareTo(IntervalUnit.SECONDS) > 0) {
            from = IntervalUnit.SECONDS;
        }
        if (to.compareTo(IntervalUnit.MICROSECONDS) > 0) {
            to = IntervalUnit.MICROSECONDS;
        }
        StringBuffer format = new StringBuffer();
        for (IntervalUnit field = from; field != null && field.compareTo(to) <= 0; field = field.next()) {
            int len = 1;
            if (field == IntervalUnit.MILLISECONDS) {
                if (field != to) continue;
                len = 3;
            } else if (field == IntervalUnit.MICROSECONDS) {
                len = 6;
            } else if (field == from) {
                len = 3;
            }
            format.append(Str.valueOf(field.patternChar(), len));
            if (field == IntervalUnit.YEARS || field == IntervalUnit.MONTHS || field == IntervalUnit.DAYS) {
                format.append(' ');
                format.append('\'');
                format.append(field.getString(locale));
                format.append('\'');
                if (field == to) continue;
                format.append(' ');
                continue;
            }
            if (field == IntervalUnit.HOURS || field == IntervalUnit.MINUTES) {
                if (field == to) continue;
                format.append(':');
                continue;
            }
            if (field != IntervalUnit.SECONDS || field == to) continue;
            format.append('.');
        }
        return new IntervalFormat(format.toString(), locale);
    }

    public String format(Interval interval) {
        return this.format(interval, new StringBuffer(), new FieldPosition(0)).toString();
    }

    @Override
    public StringBuffer format(Object object, StringBuffer appendTo, FieldPosition position) {
        if (object instanceof Interval) {
            return this.format((Interval)object, appendTo, position);
        }
        throw new IllegalArgumentException("Cannot format something that is not an Interval");
    }

    public StringBuffer format(Interval interval, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        for (int i = 0; i < this.pattern_d.length(); ++i) {
            char ch = this.pattern_d.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo.append(this.subFormat(interval, prevCh, count, toAppendTo.length(), pos));
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < this.pattern_d.length() && this.pattern_d.charAt(i + 1) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                prevCh = ch;
                ++count;
                continue;
            }
            toAppendTo.append(ch);
        }
        if (count > 0) {
            toAppendTo.append(this.subFormat(interval, prevCh, count, toAppendTo.length(), pos));
        }
        return toAppendTo;
    }

    public Interval parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Interval result = this.parse(text, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable interval: \"" + text + "\"", pos.getErrorIndex());
        }
        return result;
    }

    public Interval parse(String text, ParsePosition pos) {
        int start;
        Interval.Holder result = new Interval.Holder(new Interval());
        int oldStart = start = pos.getIndex();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int interQuoteCount = 1;
        for (int i = 0; i < this.pattern_d.length(); ++i) {
            int startOffset;
            char ch = this.pattern_d.charAt(i);
            if (inQuote) {
                if (ch == '\'') {
                    inQuote = false;
                    if (count == 0) {
                        if (start >= text.length() || ch != text.charAt(start)) {
                            pos.setIndex(oldStart);
                            pos.setErrorIndex(start);
                            return null;
                        }
                        ++start;
                    }
                    count = 0;
                    interQuoteCount = 0;
                    continue;
                }
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setIndex(oldStart);
                    pos.setErrorIndex(start);
                    return null;
                }
                ++count;
                ++start;
                continue;
            }
            if (ch == '\'') {
                inQuote = true;
                if (count > 0) {
                    startOffset = start;
                    if ((start = this.subParse(text, result, start, prevCh, count, false)) < 0) {
                        pos.setErrorIndex(startOffset);
                        pos.setIndex(oldStart);
                        return null;
                    }
                    count = 0;
                }
                if (interQuoteCount == 0) {
                    startOffset = start;
                    if (start >= text.length() || ch != text.charAt(start)) {
                        pos.setErrorIndex(startOffset);
                        pos.setIndex(oldStart);
                        return null;
                    }
                    ++start;
                    count = 1;
                }
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                if (ch != prevCh && count > 0) {
                    startOffset = start;
                    if ((start = this.subParse(text, result, start, prevCh, count, true)) < 0) {
                        pos.setErrorIndex(startOffset);
                        pos.setIndex(oldStart);
                        return null;
                    }
                    prevCh = ch;
                    count = 1;
                } else {
                    if (ch != prevCh) {
                        prevCh = ch;
                    }
                    ++count;
                }
            } else if (count > 0) {
                startOffset = start;
                if ((start = this.subParse(text, result, start, prevCh, count, false)) < 0) {
                    pos.setErrorIndex(startOffset);
                    pos.setIndex(oldStart);
                    return null;
                }
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setErrorIndex(start);
                    pos.setIndex(oldStart);
                    return null;
                }
                ++start;
                count = 0;
                prevCh = '\u0000';
            } else {
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setErrorIndex(start);
                    pos.setIndex(oldStart);
                    return null;
                }
                ++start;
            }
            ++interQuoteCount;
        }
        if (count > 0) {
            int startOffset = start;
            if ((start = this.subParse(text, result, start, prevCh, count, false)) < 0) {
                pos.setIndex(oldStart);
                pos.setErrorIndex(startOffset);
                return null;
            }
        }
        pos.setIndex(start);
        return result.value;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public String toPattern() {
        return this.pattern_d;
    }

    private void initialize() {
        this.numberFormat_d = NumberFormat.getInstance(this.locale_d);
        this.numberFormat_d.setGroupingUsed(false);
        if (this.numberFormat_d instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat_d).setDecimalSeparatorAlwaysShown(false);
        }
    }

    private String subFormat(Interval interval, char ch, int count, int beginOffset, FieldPosition pos) throws IllegalArgumentException {
        boolean only;
        int maxIntCount = Integer.MAX_VALUE;
        IntervalUnit field = IntervalUnit.valueOf(ch);
        boolean bl = only = count <= 2;
        if (field == IntervalUnit.MICROSECONDS && count <= 6 || field == IntervalUnit.MILLISECONDS && count <= 3) {
            only = true;
        }
        if (field == null) {
            throw new IllegalArgumentException("Illegal pattern character '" + ch + "'");
        }
        long value = only ? interval.getOnly(field) : interval.get(field);
        String current = this.zeroPaddingNumber(value, field == IntervalUnit.MILLISECONDS || field == IntervalUnit.MICROSECONDS ? count : 1, Integer.MAX_VALUE);
        if (pos.getField() == field.ordinal() && pos.getBeginIndex() == 0 && pos.getEndIndex() == 0) {
            pos.setBeginIndex(beginOffset);
            pos.setEndIndex(beginOffset + current.length());
        }
        return current;
    }

    private int subParse(String text, Interval.Holder interval, int start, char ch, int count, boolean obeyCount) {
        Number number;
        boolean only;
        ParsePosition pos = new ParsePosition(0);
        IntervalUnit field = IntervalUnit.valueOf(ch);
        boolean bl = only = count <= 2;
        if (field == IntervalUnit.MICROSECONDS && count <= 6 || field == IntervalUnit.MILLISECONDS && count <= 3) {
            only = true;
        }
        if (field == null) {
            return -start;
        }
        pos.setIndex(start);
        while (true) {
            if (pos.getIndex() >= text.length()) {
                return -start;
            }
            char c = text.charAt(pos.getIndex());
            if (c != ' ' && c != '\t') break;
            pos.setIndex(pos.getIndex() + 1);
        }
        if (obeyCount) {
            if (start + count > text.length()) {
                return -start;
            }
            number = this.numberFormat_d.parse(text.substring(0, start + count), pos);
        } else {
            number = this.numberFormat_d.parse(text, pos);
        }
        if (number != null) {
            interval.value = only ? interval.value.setOnly(field, number.longValue()) : interval.value.setOnly(field, number.longValue());
            return pos.getIndex();
        }
        return -start;
    }

    private String zeroPaddingNumber(long value, int minDigits, int maxDigits) {
        this.numberFormat_d.setMinimumIntegerDigits(minDigits);
        this.numberFormat_d.setMaximumIntegerDigits(maxDigits);
        return this.numberFormat_d.format(value);
    }
}

