/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.Serializable;
import java.math.BigDecimal;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.ReplacementFor;
import oracle.bpm.lang.Binary;
import oracle.bpm.lang.FormatException;
import oracle.bpm.lang.IntervalFormatException;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TimeoutException;
import oracle.bpm.util.ExecutionContext;
import oracle.bpm.util.ExecutionContextAccessor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@Component(module="Fuego.Lang")
public final class Interval
implements Serializable,
Comparable<Interval> {
    private final int days;
    private final long microSeconds;
    private final int months;
    @NonNls
    private static final String RETRYIN_STR = "retryin:";
    static final long serialVersionUID = 7315830266755257795L;
    private static final long M = 1000000L;
    private static final double DAYS_BY_YEAR = 365.2425;
    private static final double DAYS_BY_MONTH = 30.436875;
    private static final long MICROSECONDS_BY_DAY = 86400000000L;
    public static final Interval ZERO = new Interval(0, 0, 0L);
    public static final Interval ONE_SECOND = new Interval(0, 0, 1000000L);
    public static final Interval ONE_MINUTE = new Interval(0, 0, 60000000L);
    public static final Interval ONE_HOUR = new Interval(0, 0, 3600000000L);
    public static final Interval ONE_DAY = new Interval(0, 1, 0L);
    public static final Interval ONE_WEEK = new Interval(0, 7, 0L);
    public static final Interval ONE_MONTH = new Interval(1, 0, 0L);
    static final long serialCheck = -5190108490938495685L;

    public Interval() {
        this(0, 0, 0L);
    }

    private Interval(int months, int days, long ms) {
        this.months = months;
        this.days = days;
        this.microSeconds = ms;
    }

    public static Interval add(Interval op1, Interval op2) {
        long ms2;
        int m2;
        int d2;
        long ms1;
        int m1;
        int d1;
        if (op1 == null) {
            d1 = 0;
            m1 = 0;
            ms1 = 0;
        } else {
            ms1 = op1.microSeconds;
            m1 = op1.months;
            d1 = op1.days;
        }
        if (op2 == null) {
            d2 = 0;
            m2 = 0;
            ms2 = 0;
        } else {
            ms2 = op2.microSeconds;
            m2 = op2.months;
            d2 = op2.days;
        }
        return Interval.valueOf(m1 + m2, d1 + d2, ms1 + ms2);
    }

    public static int compare(Interval a, Interval b) {
        return a == b ? 0 : (a == null ? -1 : (b == null ? 1 : Interval.doCompare(a.getMonths(), b.getMonths(), a.getDays(), b.getDays(), a.getMicroSeconds(), b.getMicroSeconds())));
    }

    @ReplacementFor(value="day")
    public static Interval daysOnly(Interval i, int day) {
        return i.setOnly(IntervalUnit.DAYS, day);
    }

    public static boolean equals(Interval a, Interval b) {
        return a == b || a != null && b != null && a.microSeconds == b.microSeconds && a.days == b.days && a.months == b.months;
    }

    public static Interval fromMinutes(int minutes) {
        return new Interval(0, 0, (long)(minutes * 60) * 1000000L);
    }

    public static Interval fromSeconds(int seconds) {
        return new Interval(0, 0, (long)seconds * 1000000L);
    }

    @Exclude
    public static String getFieldName(IntervalUnit field) {
        return field == null ? "" : field.toString();
    }

    @ReplacementFor(value="hour")
    public static Interval hoursOnly(Interval i, int hour) {
        return i.setOnly(IntervalUnit.HOURS, hour);
    }

    @ReplacementFor(value="microSecond")
    public static Interval microSecondsOnly(Interval i, long microSecond) {
        return i.setOnly(IntervalUnit.MICROSECONDS, microSecond);
    }

    @ReplacementFor(value="milliSecond")
    public static Interval milliSecondsOnly(Interval i, long milliSecond) {
        return i.setOnly(IntervalUnit.MILLISECONDS, milliSecond);
    }

    @ReplacementFor(value="minute")
    public static Interval minutesOnly(Interval i, int minute) {
        return i.setOnly(IntervalUnit.MINUTES, minute);
    }

    @ReplacementFor(value="month")
    public static Interval monthsOnly(Interval i, int month) {
        return i.setOnly(IntervalUnit.MONTHS, month);
    }

    public static Interval negate(Interval op) {
        return op == null ? ZERO : op.negate();
    }

    @ReplacementFor(value="second")
    public static Interval secondsOnly(Interval i, int second) {
        return i.setOnly(IntervalUnit.SECONDS, second);
    }

    public static Interval sub(Interval op1, Interval op2) {
        long ms2;
        int m2;
        int d2;
        long ms1;
        int m1;
        int d1;
        if (op1 == null) {
            d1 = 0;
            m1 = 0;
            ms1 = 0;
        } else {
            ms1 = op1.microSeconds;
            m1 = op1.months;
            d1 = op1.days;
        }
        if (op2 == null) {
            d2 = 0;
            m2 = 0;
            ms2 = 0;
        } else {
            ms2 = op2.microSeconds;
            m2 = op2.months;
            d2 = op2.days;
        }
        return Interval.valueOf(m1 - m2, d1 - d2, ms1 - ms2);
    }

    public static Interval valueOf(@Nullable Time i) {
        return i == null ? null : Interval.valueOf(i.getMicroSeconds());
    }

    public static Interval valueOf(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Interval) {
            return (Interval)obj;
        }
        if (obj instanceof Time) {
            return Interval.valueOf((Time)obj);
        }
        if (obj instanceof Number) {
            return Interval.valueOf((Number)obj);
        }
        if (obj instanceof String) {
            return Interval.valueOf((String)obj);
        }
        if (obj instanceof byte[]) {
            return Interval.valueOf(Binary.deserialize((byte[])obj));
        }
        throw new ClassCastException(obj.getClass().getName());
    }

    public static Interval valueOf(@Nullable Number obj) {
        return obj == null ? null : Interval.valueOf(obj.longValue());
    }

    public static Interval valueOf(@NonNls @Nullable String t) throws FormatException {
        String str;
        int i;
        if (t == null) {
            return null;
        }
        for (i = 0; i < t.length() && Character.isWhitespace(t.charAt(i)); ++i) {
        }
        if (i == t.length()) {
            return ZERO;
        }
        if (t.charAt(i) == '-') {
            ++i;
        }
        while (i < t.length() && (Character.isWhitespace(t.charAt(i)) || t.charAt(i) == 'P')) {
            if (t.charAt(i) == 'P') {
                return Interval.privateParseInterval(t);
            }
            ++i;
        }
        if ((i += (str = Interval.extractNumber(t, i)).length()) == t.length()) {
            return Interval.privateParseInterval(t);
        }
        switch (t.charAt(i)) {
            case ':': {
                return Interval.parseTimeOnly(t);
            }
            case '.': 
            case 'D': 
            case 'H': 
            case 'M': 
            case 'S': 
            case 'Y': 
            case 'd': 
            case 'h': 
            case 'm': 
            case 's': 
            case 'x': {
                return Interval.privateParseInterval(t);
            }
        }
        throw new IntervalFormatException(t);
    }

    public static Interval valueOf(BigDecimal ms) {
        return Interval.valueOf(ms.longValue());
    }

    public static Interval valueOf(double ms) {
        return Interval.valueOf((long)ms);
    }

    public static Interval valueOf(long microSeconds) {
        if (microSeconds == 1000000L) {
            return ONE_SECOND;
        }
        if (microSeconds == 60000000L) {
            return ONE_MINUTE;
        }
        if (microSeconds == 3600000000L) {
            return ONE_HOUR;
        }
        return new Interval(0, 0, microSeconds);
    }

    public static Interval normalizedValueOf(long microSeconds) {
        long days = microSeconds / 86400000000L;
        return new Interval(0, (int)days, microSeconds - days * 86400000000L);
    }

    public static Interval valueOf(Time op1, Time op2) {
        int cmp;
        if (op1 == null) {
            op1 = Time.EPOCH;
        }
        if (op2 == null) {
            op2 = Time.EPOCH;
        }
        return (cmp = op1.compareTo(op2)) == 0 ? ZERO : (cmp > 0 ? Interval.difference(op1, op2) : Interval.difference(op2, op1).negate());
    }

    public static Interval valueOf(int months, int days, long microSeconds) {
        if (months == 0) {
            if (days == 0) {
                return Interval.valueOf(microSeconds);
            }
            if (days == 1 && microSeconds == 0L) {
                return ONE_DAY;
            }
        } else if (months == 1 && days == 0 && microSeconds == 0L) {
            return ONE_MONTH;
        }
        return new Interval(months, days, microSeconds);
    }

    @ReplacementFor(value="year")
    public static Interval yearsOnly(Interval i, int year) {
        return i.setOnly(IntervalUnit.YEARS, year);
    }

    public static Interval valueOf(IntervalUnit unit, int value) {
        return ZERO.set(unit, value);
    }

    public Interval abs() {
        return Interval.valueOf(Math.abs(this.months), Math.abs(this.days), Math.abs(this.microSeconds));
    }

    public Time add(Time t) {
        return t.addMonths(this.months).addDays(this.days).addMicroSeconds(this.microSeconds);
    }

    public Interval add(Interval t) {
        return Interval.add(this, t);
    }

    public Interval addDays(int i) {
        return Interval.valueOf(this.months, this.days + i, this.microSeconds);
    }

    public Interval addHours(long i) {
        return this.addMinutes(i * 60L);
    }

    public Interval addMicroSeconds(long i) {
        return Interval.valueOf(this.months, this.days, this.microSeconds + i);
    }

    public Interval addMinutes(long i) {
        return this.addSeconds(i * 60L);
    }

    public Interval addMonths(int i) {
        return Interval.valueOf(this.months + i, this.days, this.microSeconds);
    }

    public Interval addSeconds(long i) {
        return this.addMicroSeconds(i * 1000000L);
    }

    public Interval addYears(int i) {
        return this.addMonths(i * 12);
    }

    @Override
    public int compareTo(Interval o) {
        return Interval.compare(this, o);
    }

    public boolean equals(Object b) {
        return b instanceof Interval && Interval.equals(this, (Interval)b);
    }

    public String format() {
        return this.format(IntervalUnit.YEARS, IntervalUnit.MICROSECONDS);
    }

    public String format(IntervalUnit from, IntervalUnit to) {
        long value;
        StringBuilder buff = new StringBuilder();
        boolean negative = false;
        IntervalUnit field = from;
        long years = 0L;
        if (field == IntervalUnit.YEARS) {
            years = to == IntervalUnit.YEARS || to == IntervalUnit.MONTHS ? (long)this.getApproximateTotal(IntervalUnit.YEARS) : this.getOnly(IntervalUnit.YEARS);
            negative = Interval.copyField(buff, IntervalUnit.YEARS, years, negative);
            IntervalUnit intervalUnit = field = to == IntervalUnit.YEARS ? null : IntervalUnit.MONTHS;
        }
        if (field == IntervalUnit.MONTHS) {
            long value2 = to == IntervalUnit.MONTHS ? (long)this.getApproximateTotal(IntervalUnit.MONTHS) - years * 12L : (from == IntervalUnit.MONTHS ? this.get(IntervalUnit.MONTHS) : this.getOnly(IntervalUnit.MONTHS));
            negative = Interval.copyField(buff, IntervalUnit.MONTHS, value2, negative);
            IntervalUnit intervalUnit = field = to == IntervalUnit.MONTHS ? null : IntervalUnit.DAYS;
        }
        if (field == IntervalUnit.DAYS) {
            long value3;
            boolean lastField;
            boolean bl = lastField = to == IntervalUnit.DAYS;
            if (from == IntervalUnit.DAYS) {
                value3 = (long)this.getApproximateTotal(IntervalUnit.DAYS);
                if (!lastField) {
                    value3 -= this.get(IntervalUnit.HOURS) / 24L;
                }
            } else {
                value3 = this.get(IntervalUnit.DAYS);
                if (lastField) {
                    value3 += this.get(IntervalUnit.HOURS) / 24L;
                }
            }
            negative = Interval.copyField(buff, IntervalUnit.DAYS, value3, negative);
            field = lastField ? null : IntervalUnit.HOURS;
        }
        boolean hasSeconds = false;
        IntervalUnit mark = field;
        while (field != null && field != IntervalUnit.MILLISECONDS) {
            value = field == from ? (long)this.getApproximateTotal(field) : (field == mark ? this.get(field) : this.getOnly(field));
            negative = Interval.copyField(buff, field, value, negative);
            hasSeconds = field == IntervalUnit.SECONDS && value != 0L;
            field = field == to ? null : field.next();
        }
        if (field != null) {
            long l = to == from ? (long)this.getApproximateTotal(to) : (value = field == mark ? this.get(to) : this.getOnly(to));
            if (value != 0L) {
                int off = to == IntervalUnit.MILLISECONDS ? 3 : 6;
                Interval.offset(buff, value, off, hasSeconds);
                hasSeconds = true;
            }
        }
        if (hasSeconds) {
            buff.append(IntervalUnit.SECONDS.charId());
        }
        if (buff.length() == 0) {
            buff.append('0');
            buff.append(to.charId());
        }
        return buff.toString();
    }

    @Exclude
    public long get(IntervalUnit field) {
        if (field == IntervalUnit.YEARS) {
            return this.months / 12;
        }
        if (field == IntervalUnit.MONTHS) {
            return this.months;
        }
        if (field == IntervalUnit.DAYS) {
            return this.days;
        }
        return (long)Interval.getFromMicroSeconds(field, this.microSeconds);
    }

    @Exclude
    public double getApproximateTotal(IntervalUnit field) {
        if (field == IntervalUnit.YEARS) {
            return this.getApproximateTotal(IntervalUnit.DAYS) / 365.2425;
        }
        if (field == IntervalUnit.MONTHS) {
            return this.getApproximateTotal(IntervalUnit.DAYS) / 30.436875;
        }
        if (field == IntervalUnit.DAYS) {
            return this.getApproximateTotal(IntervalUnit.HOURS) / 24.0;
        }
        return Interval.getFromMicroSeconds(field, this.getTotalMicroseconds());
    }

    public int getDays() {
        return (int)this.get(IntervalUnit.DAYS);
    }

    @ReplacementFor(value="day")
    public int getDaysOnly() {
        return (int)this.getOnly(IntervalUnit.DAYS);
    }

    public int getHours() {
        return (int)this.get(IntervalUnit.HOURS);
    }

    @ReplacementFor(value="hour")
    public int getHoursOnly() {
        return (int)this.getOnly(IntervalUnit.HOURS);
    }

    public long getMicroSeconds() {
        return this.get(IntervalUnit.MICROSECONDS);
    }

    @ReplacementFor(value="microSecond")
    public int getMicroSecondsOnly() {
        return (int)this.getOnly(IntervalUnit.MICROSECONDS);
    }

    public long getMilliSeconds() {
        return this.get(IntervalUnit.MILLISECONDS);
    }

    @ReplacementFor(value="milliSecond")
    public int getMilliSecondsOnly() {
        return (int)this.getOnly(IntervalUnit.MILLISECONDS);
    }

    public int getMinutes() {
        return (int)this.get(IntervalUnit.MINUTES);
    }

    @ReplacementFor(value="minute")
    public int getMinutesOnly() {
        return (int)this.getOnly(IntervalUnit.MINUTES);
    }

    public int getMonths() {
        return (int)this.get(IntervalUnit.MONTHS);
    }

    @ReplacementFor(value="month")
    public int getMonthsOnly() {
        return (int)this.getOnly(IntervalUnit.MONTHS);
    }

    @Exclude
    public long getOnly(IntervalUnit field) {
        if (field == IntervalUnit.YEARS) {
            return this.months / 12;
        }
        if (field == IntervalUnit.MONTHS) {
            return this.months % 12;
        }
        if (field == IntervalUnit.DAYS) {
            return this.days;
        }
        if (field == IntervalUnit.HOURS) {
            return this.microSeconds / 3600000000L;
        }
        if (field == IntervalUnit.MINUTES) {
            return this.microSeconds / 60000000L - this.get(IntervalUnit.HOURS) * 60L;
        }
        if (field == IntervalUnit.SECONDS) {
            return this.microSeconds / 1000000L - 60L * this.get(IntervalUnit.MINUTES);
        }
        if (field == IntervalUnit.MILLISECONDS) {
            return this.microSeconds / 1000L - 1000L * this.get(IntervalUnit.SECONDS);
        }
        if (field == IntervalUnit.MICROSECONDS) {
            return this.microSeconds - 1000000L * this.get(IntervalUnit.SECONDS);
        }
        return 0L;
    }

    public int getSeconds() {
        return (int)this.get(IntervalUnit.SECONDS);
    }

    @ReplacementFor(value="second")
    public int getSecondsOnly() {
        return (int)this.getOnly(IntervalUnit.SECONDS);
    }

    public long getTotalMicroseconds() {
        double msMonths = (double)this.months * 30.436875;
        double msDays = msMonths + (double)this.days;
        return Math.round(msDays * 8.64E10) + this.microSeconds;
    }

    public int getYears() {
        return (int)this.get(IntervalUnit.YEARS);
    }

    @ReplacementFor(value="year")
    public int getYearsOnly() {
        return (int)this.getOnly(IntervalUnit.YEARS);
    }

    public int hashCode() {
        return (int)(this.microSeconds ^ this.microSeconds >>> 32 ^ (long)this.days ^ (long)(this.months << 16));
    }

    public int intValue() {
        return (int)(this.microSeconds / 1000000L);
    }

    public Interval max(Interval b) {
        return this.compareTo(b) >= 0 ? this : b;
    }

    public Interval min(Interval b) {
        return this.compareTo(b) <= 0 ? this : b;
    }

    public Interval negate() {
        return new Interval(-this.months, -this.days, -this.microSeconds);
    }

    public String retryIn() {
        return RETRYIN_STR + this;
    }

    @Exclude
    public Interval set(IntervalUnit field, long value) {
        if (field == IntervalUnit.YEARS) {
            return new Interval(12 * (int)value, this.days, this.microSeconds);
        }
        if (field == IntervalUnit.MONTHS) {
            return new Interval((int)value, this.days, this.microSeconds);
        }
        if (field == IntervalUnit.DAYS) {
            return new Interval(this.months, (int)value, this.microSeconds);
        }
        if (field == IntervalUnit.HOURS) {
            return new Interval(this.months, this.days, value * 3600L * 1000000L);
        }
        if (field == IntervalUnit.MINUTES) {
            return new Interval(this.months, this.days, value * 60L * 1000000L);
        }
        if (field == IntervalUnit.SECONDS) {
            return new Interval(this.months, this.days, value * 1000000L);
        }
        if (field == IntervalUnit.MILLISECONDS) {
            return new Interval(this.months, this.days, value * 1000L);
        }
        return new Interval(this.months, this.days, value);
    }

    @Exclude
    public Interval setOnly(IntervalUnit field, long value) {
        if (field == IntervalUnit.YEARS) {
            return new Interval(12 * (int)value + this.getMonthsOnly(), this.days, this.microSeconds);
        }
        if (field == IntervalUnit.MONTHS) {
            if ((value %= 12L) < 0L) {
                value = 12L + value;
            }
            return new Interval((int)(value += (long)(this.getYears() * 12)), this.days, this.microSeconds);
        }
        if (field == IntervalUnit.DAYS) {
            return new Interval(this.months, (int)value, this.microSeconds);
        }
        if (field == IntervalUnit.HOURS) {
            if ((value %= 24L) < 0L) {
                value += 24L;
            }
            value -= (long)this.getHoursOnly();
            value = value * 3600L * 1000000L;
        } else if (field == IntervalUnit.MINUTES) {
            if ((value %= 60L) < 0L) {
                value += 60L;
            }
            value -= (long)this.getMinutesOnly();
            value = value * 60L * 1000000L;
        } else if (field == IntervalUnit.SECONDS) {
            if ((value %= 60L) < 0L) {
                value += 60L;
            }
            value -= (long)this.getSecondsOnly();
            value *= 1000000L;
        } else if (field == IntervalUnit.MILLISECONDS) {
            if ((value %= 1000L) < 0L) {
                value += 1000L;
            }
            value -= (long)this.getMilliSecondsOnly();
            value *= 1000L;
        } else {
            if ((value %= 1000000L) < 0L) {
                value += 1000000L;
            }
            value -= (long)this.getMicroSecondsOnly();
        }
        return new Interval(this.months, this.days, value + this.microSeconds);
    }

    public void sleep() throws InterruptedException {
        long timeToLive;
        ExecutionContext ctx = ExecutionContextAccessor.getContext();
        Time now = new Time();
        Time wake = now.add(this);
        long milliSeconds = wake.getMilliSeconds() - now.getMilliSeconds();
        if (ctx != null && (timeToLive = ctx.getTimeToLive()) != 0L && milliSeconds > timeToLive) {
            throw new TimeoutException();
        }
        Thread.sleep(milliSeconds);
    }

    public Interval sub(Interval t) {
        return Interval.sub(this, t);
    }

    public Time subFrom(Time t) {
        return t.addDays(-this.days).addMonths(-this.months).addMicroSeconds(-this.microSeconds);
    }

    public String toString() {
        return this.format();
    }

    public String toXMLString() {
        int months = this.months < 0 ? -this.months : this.months;
        int days = this.days < 0 ? -this.days : this.days;
        long tm = this.microSeconds < 0L ? -this.microSeconds : this.microSeconds;
        int ms = (int)(tm % 1000000L);
        long s = tm / 1000000L;
        int h = (int)(s / 3600L);
        int m = (int)((s -= (long)(h * 3600)) / 60L);
        s -= (long)(m * 60);
        StringBuilder buff = new StringBuilder();
        if (this.microSeconds < 0L || this.days < 0 || this.months < 0) {
            buff.append('-');
        }
        buff.append('P');
        if (months > 0) {
            buff.append(months);
            buff.append('M');
        }
        if (days > 0) {
            buff.append(days);
            buff.append('D');
        }
        buff.append('T');
        if (h > 0) {
            buff.append(h);
            buff.append('H');
        }
        if (m > 0) {
            buff.append(m);
            buff.append('M');
        }
        if (s > 0L || ms > 0) {
            buff.append(s);
            if (ms > 0) {
                buff.append('.');
                int div = 100000;
                while (ms > 0) {
                    buff.append(ms / div);
                    ms %= div;
                    div /= 10;
                }
            }
            buff.append('S');
        }
        return buff.toString();
    }

    private static Interval difference(Time op1, Time op2) {
        int months = op1.getMonths() - op2.getMonths();
        int days = op1.getDay() - op2.getDay();
        long microseconds = op1.getMicroSecondsOfDay() - op2.getMicroSecondsOfDay();
        if (microseconds < 0L) {
            --days;
            microseconds += 86400000000L;
        }
        if (days < 0) {
            --months;
            days += op1.getFirstDayOfMonth().addDays(-1).getDay();
        }
        return Interval.valueOf(months, days, microseconds);
    }

    private static int doCompare(int monthsA, int monthsB, double daysA, double daysB, long msA, long msB) {
        if (monthsA != monthsB) {
            daysA += (double)monthsA * 30.436875;
            daysB += (double)monthsB * 30.436875;
        }
        if (daysA != daysB) {
            msA = (long)((double)msA + daysA * 8.64E10);
            msB = (long)((double)msB + daysB * 8.64E10);
        }
        return msA < msB ? -1 : (msA > msB ? 1 : 0);
    }

    private static String extractNumber(String t, int i) throws IntervalFormatException {
        int start = i;
        while (i < t.length() && Character.isDigit(t.charAt(i))) {
            ++i;
        }
        String strNum = t.substring(start, i);
        if (strNum.length() == 0) {
            throw new IntervalFormatException(t);
        }
        return strNum;
    }

    private static double getFromMicroSeconds(IntervalUnit field, long ms) {
        if (field == IntervalUnit.HOURS) {
            return (double)ms / 3.6E9;
        }
        if (field == IntervalUnit.MINUTES) {
            return (double)ms / 6.0E7;
        }
        if (field == IntervalUnit.SECONDS) {
            return (double)ms / 1000000.0;
        }
        if (field == IntervalUnit.MILLISECONDS) {
            return (double)ms / 1000.0;
        }
        if (field == IntervalUnit.MICROSECONDS) {
            return ms;
        }
        return 0.0;
    }

    private static void offset(StringBuilder sb, long i, int off, boolean stripLeadingZero) {
        boolean negative;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        int charPos = 64;
        char[] buf = new char[65];
        boolean skip = true;
        int count = 0;
        while (i <= -10L) {
            int digit = (int)(-(i % 10L));
            if (skip && digit != 0 || count == off) {
                skip = false;
            }
            if (!skip) {
                buf[charPos--] = (char)(48 + digit);
                if (count + 1 == off) {
                    buf[charPos--] = 46;
                }
            }
            i /= 10L;
            ++count;
        }
        buf[charPos--] = (char)(48L + -i);
        if (!skip || i != 0L) {
            while (count < off) {
                if (count + 1 == off) {
                    buf[charPos] = 46;
                    skip = true;
                } else {
                    buf[charPos] = 48;
                }
                --charPos;
                ++count;
            }
        }
        if (skip && !stripLeadingZero) {
            buf[charPos] = 48;
        } else {
            ++charPos;
        }
        if (negative) {
            buf[--charPos] = 45;
        }
        sb.append(buf, charPos, 65 - charPos);
    }

    private static Interval parseTimeOnly(String t) throws IntervalFormatException {
        String hourStr;
        int i;
        for (i = 0; i < t.length() && Character.isWhitespace(t.charAt(i)); ++i) {
        }
        if (i == t.length()) {
            throw new IntervalFormatException(t);
        }
        boolean neg = false;
        if (t.charAt(i) == '-') {
            neg = true;
            ++i;
        }
        if ((i += (hourStr = Interval.extractNumber(t, i)).length()) == t.length() || t.charAt(i) != ':') {
            throw new IntervalFormatException(t);
        }
        String minuteStr = Interval.extractNumber(t, ++i);
        String microSecondStr = null;
        String secondStr = null;
        if ((i += minuteStr.length()) < t.length() && t.charAt(i) == ':') {
            ++i;
            if ((i += (secondStr = Interval.extractNumber(t, i)).length()) < t.length() && t.charAt(i) == '.') {
                microSecondStr = Interval.extractNumber(t, ++i);
                i += microSecondStr.length();
            }
        }
        while (i < t.length() && Character.isWhitespace(t.charAt(i))) {
            ++i;
        }
        if (i < t.length()) {
            throw new IntervalFormatException(t);
        }
        long hour = Long.parseLong(hourStr);
        long minute = Long.parseLong(minuteStr);
        long second = 0L;
        if (secondStr != null) {
            second = Long.parseLong(secondStr);
        }
        int microSecond = 0;
        if (microSecondStr != null) {
            microSecond = (int)(Double.valueOf('.' + microSecondStr) * 1000000.0);
        }
        if (minute < 0L || minute > 59L || second < 0L || second > 59L || microSecond < 0 || (long)microSecond > 999999L) {
            throw new IntervalFormatException(t);
        }
        long ms = (hour * 3600L + minute * 60L + second) * 1000000L + (long)microSecond;
        return Interval.valueOf(neg ? -ms : ms);
    }

    private static Interval privateParseInterval(String t) {
        int i;
        for (i = 0; i < t.length() && Character.isWhitespace(t.charAt(i)); ++i) {
        }
        if (i == t.length()) {
            throw new IntervalFormatException(t);
        }
        boolean neg = false;
        if (t.charAt(i) == '-') {
            neg = true;
            ++i;
        }
        boolean timePart = false;
        long ms = 0L;
        int months = 0;
        int days = 0;
        boolean negM = false;
        boolean negD = false;
        boolean negH = false;
        while (i < t.length()) {
            while (i < t.length() && Character.isWhitespace(t.charAt(i))) {
                ++i;
            }
            if (i == t.length()) break;
            if (t.charAt(i) == 'P') {
                ++i;
                continue;
            }
            if (t.charAt(i) == 'T') {
                timePart = true;
                ++i;
                continue;
            }
            if (t.charAt(i) == '/') {
                if (i + 1 >= t.length()) {
                    throw new IntervalFormatException(t);
                }
                if (t.charAt(i + 1) == '-') {
                    neg = true;
                    ++i;
                } else {
                    neg = false;
                }
                ++i;
                continue;
            }
            String num = Interval.extractNumber(t, i);
            String decimal = null;
            if ((i += num.length()) < t.length() && t.charAt(i) == '.') {
                decimal = Interval.extractNumber(t, ++i);
                i += decimal.length();
            }
            while (i < t.length() && Character.isWhitespace(t.charAt(i))) {
                ++i;
            }
            int unit = i == t.length() ? 120 : (int)t.charAt(i);
            double magnitude = decimal == null ? Double.parseDouble(num) : Double.parseDouble(num + '.' + decimal);
            switch (unit) {
                case 89: {
                    months += (int)magnitude * 12;
                    negM = neg;
                    break;
                }
                case 77: {
                    if (timePart) {
                        ms += (long)(magnitude * 6.0E7);
                    } else {
                        months += (int)magnitude;
                    }
                    negM = neg;
                    break;
                }
                case 120: {
                    ms += (long)magnitude;
                    break;
                }
                case 68: 
                case 100: {
                    days = (int)((double)days + magnitude);
                    negD = neg;
                    break;
                }
                case 72: 
                case 104: {
                    ms += (long)(magnitude * 3.6E9);
                    negH = neg;
                    break;
                }
                case 109: {
                    ms += (long)(magnitude * 6.0E7);
                    break;
                }
                case 83: 
                case 115: {
                    ms += (long)(magnitude * 1000000.0);
                    break;
                }
                default: {
                    throw new IntervalFormatException(t);
                }
            }
            ++i;
        }
        if (negM) {
            months = -months;
        }
        if (negD) {
            days = -days;
        }
        if (negH) {
            ms = -ms;
        }
        return Interval.valueOf(months, days, ms);
    }

    private static boolean copyField(StringBuilder buff, IntervalUnit field, long value, boolean negative) {
        if (value != 0L) {
            char letterForField;
            if (value < 0L) {
                if (!negative) {
                    if (buff.length() > 0) {
                        buff.append('/');
                    }
                    buff.append('-');
                    negative = true;
                }
            } else if (negative) {
                buff.append('/');
                negative = false;
            }
            buff.append(Math.abs(value));
            if (field != IntervalUnit.SECONDS && (letterForField = field.charId()) != '\u0000') {
                buff.append(letterForField);
            }
        }
        return negative;
    }

    public static final class Holder {
        public Interval value;

        public Holder() {
        }

        public Holder(Interval init) {
            this.value = init;
        }
    }
}

