/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.lang.Literals;
import oracle.bpm.lang.Maturity;
import oracle.bpm.lang.Time;
import org.jetbrains.annotations.NonNls;

public class Id {
    private static final String RELEASE_INTERNAL_PROPERTY = "version.release.internal";
    @NonNls
    private static final String FUEGO_BUILD_PROPERTIES = "/fuego/build.properties";
    @NonNls
    private static final String VERSION_PROPERTIES = "/oracle/bpm/version.properties";
    @NonNls
    private static final String FUEGO_ID_PROPERTIES = "/fuego/id.properties";
    @NonNls
    public static final String PROCESSING_INSTRUCTION_TARGET = "fuego";
    @NonNls
    private static final String FUEGO_PROCESSING_INSTRUCTION_DATA = "version=\"%s\" build=\"%s\"";
    @NonNls
    private static final String FUEGO_PROCESSING_INSTRUCTION_LINE = "<?fuego version=\"%s\" build=\"%s\"?>\n";
    @NonNls
    private static final String XML_PROCESSING_INSTRUCTION_LINE = "<?xml version=\"1.0\" encoding=\"%s\"?>\n";
    public static final String LICENSE_COMPONENT_PROPERTY = "license.component";
    public static final String LICENSE_RELEASE_PROPERTY = "license.version";
    public static final String LICENSE_PRODUCT_PROPERTY = "license.product";
    private static boolean cheetahReaded;
    private static boolean cheetahEnabled;
    public static final int PUMA_FIRST_BUILD = 60000;
    public static final int CHEETAH_FIRST_BUILD = 57000;
    public static final int DNA_FIRST_BUILD = 55000;
    public static final int FITZROY_FIRST_BUILD = 52000;
    public static final int TRONADOR_FIRST_BUILD = 51000;
    public static final int LANIN_FIRST_BUILD = 50000;
    private static Properties propIdFile;
    @NonNls
    private static final String tagName = "$Name$";
    @NonNls
    private static final String SEPARATOR = ", protocol ";
    @NonNls
    private static final String date = "$Date: 2009/09/17 11:36:51 $";
    @NonNls
    private static final String APPLICATION_LABEL_PROPERTY = "application.label";
    @NonNls
    private static final String APPLICATION_ID_PROPERTY = "application.id";
    @NonNls
    private static final String VERSION_MATURITY_PROPERTY = "version.maturity";
    @NonNls
    private static final String VERSION_RELEASE_PROPERTY = "version.release";
    @NonNls
    private static final String VERSION_SERVICE_PACK_PROPERTY = "version.service_pack";
    @NonNls
    private static final String VERSION_TAG = "version.tag";
    @NonNls
    private static final String BUILD_DATE_PROPERTY = "build.date";
    @NonNls
    private static final String BUILD_NUMBER_PROPERTY = "build.number";
    @NonNls
    private static final String BUILD_DATE_DAY_FORMAT = "MMM dd,yyyy hh:mm:ss";
    private static String absoluteVersion;
    private static int absoluteId;
    private static String tag;
    @NonNls
    public static final String ALBPM_STUDIO_APPLICATION_ID = "albpmstudio";
    @NonNls
    public static final String ALBPM_FUEGO_DESIGNER_APPLICATION_ID = "albpmdesigner";
    @NonNls
    public static final String ALBPM_J2EE_APPLICATION_ID = "albpmenterprisej2ee";
    @NonNls
    public static final String ALBPM_ENTERPRISE_APPLICATION_ID = "albpmenterprise";
    @NonNls
    public static final String ALBPM_EXPRESS_APPLICATION_ID = "albpmexpress";

    private Id() {
    }

    public static int getAbsoluteServicePackId() {
        if (absoluteId == -1) {
            String releaseStr = Id.getRelease();
            releaseStr = releaseStr.substring(0, 1) + releaseStr.substring(2, 3);
            absoluteId = Integer.parseInt(releaseStr) * 1000 + Id.getMaturity().ordinal() * 100 + Id.getServicePack();
        }
        return absoluteId;
    }

    public static int getAbsoluteServicePackIdForVersion(String string) {
        try {
            int dot = string.indexOf(".");
            int mayor = Integer.parseInt(string.substring(0, dot));
            int space = string.indexOf(" ", dot) + 1;
            int minor = Integer.parseInt(string.substring(dot + 1, space - 1));
            int space2 = string.indexOf(32, space);
            Maturity maturity = Maturity.valueOf(space2 == -1 ? string.substring(space) : string.substring(space, space2));
            if (maturity == null) {
                return -1;
            }
            int servicePack = space2 == -1 ? 0 : Integer.parseInt(string.substring(space2 + 3));
            return mayor * 10000 + minor * 1000 + maturity.ordinal() * 100 + servicePack;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getAbsoluteVersion() {
        return "11.1.1";
    }

    public static String getApplicationId() {
        return Id.getProperties().getProperty(APPLICATION_ID_PROPERTY);
    }

    public static String getApplicationLabel() {
        return Id.getProperties().getProperty(APPLICATION_LABEL_PROPERTY);
    }

    public static Time getBuildTime() {
        Time result;
        try {
            SimpleDateFormat df = new SimpleDateFormat(BUILD_DATE_DAY_FORMAT, Locale.ENGLISH);
            Date date = df.parse(Id.getProperties().getProperty(BUILD_DATE_PROPERTY));
            result = Time.valueOf(date);
        }
        catch (ParseException e) {
            result = Time.now();
        }
        return result;
    }

    public static String getBuildDate(Locale locale) {
        return Time.valueOf(Id.getBuildTime()).format(Time.getTimeZone(), locale);
    }

    public static String getBuildNumber() {
        String result = null;
        Properties properties = Id.getProperties();
        if (properties != null) {
            result = properties.getProperty(BUILD_NUMBER_PROPERTY);
        }
        return result != null ? result : "0";
    }

    public static int getBuildNumberForTag(@NonNls String versionName) {
        int buildNumber = "CHEETAH".equalsIgnoreCase(versionName) ? 57000 : ("DNA".equalsIgnoreCase(versionName) ? 55000 : ("FITZROY".equalsIgnoreCase(versionName) ? 52000 : ("TRONADOR".equalsIgnoreCase(versionName) ? 51000 : ("LANIN".equalsIgnoreCase(versionName) ? 50000 : 0))));
        return buildNumber;
    }

    public static boolean isCheetahEnabled() {
        if (!cheetahReaded) {
            File enableCheetah = new File(System.getProperty("user.home"), ".cheetah");
            cheetahEnabled = enableCheetah.exists();
            cheetahReaded = true;
        }
        return cheetahEnabled;
    }

    public static Maturity getMaturity() {
        String maturityStr = Id.getProperties().getProperty(VERSION_MATURITY_PROPERTY);
        return Maturity.valueOf(maturityStr);
    }

    public static Maturity getMaturity(int absoluteSPId) {
        return Maturity.values()[(absoluteSPId % 1000 - absoluteSPId % 100) / 100];
    }

    public static String getOEMCompanyRelease() {
        return "BEA Systems Inc.";
    }

    public static String getRelease() {
        return Id.getProperties().getProperty(VERSION_RELEASE_PROPERTY);
    }

    public static String getRelease(int absoluteSPId) {
        String str = Integer.toString(absoluteSPId / 1000);
        return new StringBuffer(str).insert(1, ".").toString();
    }

    public static int getServicePack() {
        String spStr = Id.getProperties().getProperty(VERSION_SERVICE_PACK_PROPERTY);
        return Integer.parseInt(spStr);
    }

    public static int getServicePack(int absoluteSPId) {
        return absoluteSPId % 100;
    }

    public static String getVersion() {
        if (Id.getReleaseInternal() != null) {
            return Id.getRelease() + " " + Id.getReleaseInternal();
        }
        return Id.getRelease() + " " + Id.getMaturity().toString();
    }

    public static String getTypeVersionId() {
        return "Version " + Id.getVersion();
    }

    public static String getVersion(int absoluteSPId) {
        return Id.getRelease(absoluteSPId) + " " + (Object)((Object)Id.getMaturity(absoluteSPId));
    }

    public static String getVersionsString() {
        return Id.getVersion() + SEPARATOR + Id.getProtocolVersion();
    }

    public static String getVersionTag() {
        if (tag == null) {
            tag = Id.getProperties().getProperty(VERSION_TAG);
        }
        return tag;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if ("--setSystemProperties".equals(args[0])) {
                System.out.println("versionId = " + Id.getVersionTag());
                System.out.println("Id.main");
                System.setProperty("oracle.bpm.lang.Id.versionId", Id.getVersionTag());
                System.setProperty("oracle.bpm.lang.Id.versionTag", Id.getVersionTag());
                System.setProperty("oracle.bpm.lang.Id.date", date);
                System.setProperty("oracle.bpm.lang.Id.tagName", tagName);
            }
            if ("--versionId".equals(args[0]) || "--versionTag".equals(args[0])) {
                System.out.println(Id.getVersionTag());
            }
            if ("--versionName".equals(args[0])) {
                System.out.println(Id.getVersion());
            }
            if ("--all".equals(args[0])) {
                System.out.println("Release: <" + Id.getRelease() + ">");
                System.out.println("Maturity: <" + (Object)((Object)Id.getMaturity()) + ">");
                System.out.println("Abosolute Service Pack ID: <" + Id.getAbsoluteServicePackId() + ">");
                System.out.println("Application ID: <" + Id.getApplicationId() + ">");
                System.out.println("Application Label: <" + Id.getApplicationLabel() + ">");
                System.out.println("Version: <" + Id.getVersion() + ">");
                System.out.println("Service Pack Number: <" + Id.getServicePack() + ">");
                System.out.println("Tag: <" + Id.getVersionTag() + ">");
            }
            if ("--build".equals(args[0])) {
                Locale loc = Locale.getDefault();
                System.out.println("getBuildDate(" + loc + ") = " + Id.getBuildDate(loc));
                System.out.println("getBuildNumber() = " + Id.getBuildNumber());
            }
        }
    }

    public static int parseXmlVersion(String data) {
        String versionStr = "version=\"";
        if (data.indexOf("version=\"") == -1) {
            return -1;
        }
        int startIndex = data.indexOf("version=\"") + "version=\"".length();
        int endIndex = data.indexOf(34, startIndex);
        if (endIndex == -1) {
            return -1;
        }
        return Id.getAbsoluteServicePackIdForVersion(data.substring(startIndex, endIndex));
    }

    public static String getLicenseProduct() {
        return Id.getProperties().getProperty(LICENSE_PRODUCT_PROPERTY);
    }

    public static String getLicenseComponent() {
        return Id.getProperties().getProperty(LICENSE_COMPONENT_PROPERTY);
    }

    public static String getLicenseRelease() {
        return Id.getProperties().getProperty(LICENSE_RELEASE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String propertyFile) {
        Properties buildInfo = new Properties();
        InputStream is = Id.class.getResourceAsStream(propertyFile);
        if (is != null) {
            try {
                try {
                    buildInfo.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buildInfo;
    }

    public static String getFuegoProcessingInstructionData() {
        return String.format(FUEGO_PROCESSING_INSTRUCTION_DATA, Id.getAbsoluteVersion(), Id.getBuildNumber());
    }

    public static String getFuegoProcessingInstructionLine() {
        return String.format(FUEGO_PROCESSING_INSTRUCTION_LINE, Id.getAbsoluteVersion(), Id.getBuildNumber());
    }

    public static String getXmlProcessingInstructionLine() {
        return String.format(XML_PROCESSING_INSTRUCTION_LINE, Literals.DEFAULT_ENCODING);
    }

    public static String getXmlProcessingInstructionLine(String encoding) {
        return String.format(XML_PROCESSING_INSTRUCTION_LINE, encoding != null ? encoding : Literals.DEFAULT_ENCODING);
    }

    public static int compareVersionId(String versionId, String referenceVersionId) {
        boolean nullVersion;
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+).*");
        Matcher matcher = pattern.matcher(versionId);
        int vMajorComponent = -1;
        int vMinorComponent = -1;
        if (matcher.matches()) {
            vMajorComponent = Integer.parseInt(matcher.group(1));
            vMinorComponent = Integer.parseInt(matcher.group(2));
        }
        matcher.reset(referenceVersionId);
        int vMinorReference = -1;
        int vMajorReference = -1;
        if (matcher.matches()) {
            vMajorReference = Integer.parseInt(matcher.group(1));
            vMinorReference = Integer.parseInt(matcher.group(2));
        }
        boolean bl = nullVersion = vMajorComponent == -1 && vMajorReference == -1 && vMinorComponent == -1 && vMinorReference == -1;
        int comparation = nullVersion || vMajorComponent == vMajorReference && vMinorComponent == vMinorReference ? 0 : (vMajorComponent > vMajorReference || vMajorComponent == vMajorReference && vMinorComponent > vMinorReference ? 1 : -1);
        return comparation;
    }

    public static String getJDevVersion() {
        return Id.getProperties().get("base.version") + "." + Id.getProperties().get(BUILD_NUMBER_PROPERTY);
    }

    private static String getReleaseInternal() {
        return Id.getProperties().getProperty(RELEASE_INTERNAL_PROPERTY);
    }

    private static Properties getProperties() {
        if (propIdFile == null) {
            propIdFile = Id.loadProperties(FUEGO_ID_PROPERTIES);
            propIdFile.putAll((Map<?, ?>)Id.loadProperties(FUEGO_BUILD_PROPERTIES));
            propIdFile.putAll((Map<?, ?>)Id.loadProperties(VERSION_PROPERTIES));
        }
        return propIdFile;
    }

    private static String getProtocolVersion() {
        return "3.1";
    }

    static {
        propIdFile = null;
        absoluteId = -1;
        tag = null;
    }

    public static final class Product
    extends Enum<Product> {
        public static final /* enum */ Product FUEGO_DESIGNER = new Product();
        public static final /* enum */ Product FUEGO_STUDIO = new Product();
        public static final /* enum */ Product FUEGO_EXPRESS = new Product();
        public static final /* enum */ Product FUEGO_ENTERPRISE = new Product();
        public static final /* enum */ Product FUEGO_J2EE = new Product();
        private static final /* synthetic */ Product[] $VALUES;

        public static Product[] values() {
            return (Product[])$VALUES.clone();
        }

        public static Product valueOf(String name) {
            return Enum.valueOf(Product.class, name);
        }

        public static Product getCurrent() {
            Product ret = null;
            String applicationId = Id.getApplicationId();
            if (Id.ALBPM_STUDIO_APPLICATION_ID.equalsIgnoreCase(applicationId)) {
                ret = FUEGO_STUDIO;
            } else if (Id.ALBPM_FUEGO_DESIGNER_APPLICATION_ID.equalsIgnoreCase(applicationId)) {
                ret = FUEGO_DESIGNER;
            } else if (Id.ALBPM_EXPRESS_APPLICATION_ID.equalsIgnoreCase(applicationId)) {
                ret = FUEGO_EXPRESS;
            } else if (Id.ALBPM_ENTERPRISE_APPLICATION_ID.equalsIgnoreCase(applicationId)) {
                ret = FUEGO_ENTERPRISE;
            } else if (Id.ALBPM_J2EE_APPLICATION_ID.equalsIgnoreCase(applicationId)) {
                ret = FUEGO_J2EE;
            } else assert (false) : "Could not load application id information: '" + applicationId + "'";
            return ret;
        }

        public boolean isDesigner() {
            return this == FUEGO_DESIGNER;
        }

        public boolean isStudio() {
            return this == FUEGO_STUDIO;
        }

        public boolean isEnterprise() {
            return this == FUEGO_ENTERPRISE;
        }

        public boolean isJavaEnterprise() {
            return this == FUEGO_J2EE;
        }

        static {
            $VALUES = new Product[]{FUEGO_DESIGNER, FUEGO_STUDIO, FUEGO_EXPRESS, FUEGO_ENTERPRISE, FUEGO_J2EE};
        }
    }
}

