/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.bpm.lang.JavaClass;

public abstract class FuegoClassLoader
extends ClassLoader {
    protected final Map<Class, JavaClass> classCache = new HashMap<Class, JavaClass>();
    protected final String creationTime = new Date().toString();
    public static final Map<ClassLoader, String> classloaders = Collections.synchronizedMap(new WeakHashMap());

    public FuegoClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static void registerClassLoader(ClassLoader loader) {
        while (loader != null && !classloaders.containsKey(loader)) {
            String text = loader.toString();
            if (text != null && text.startsWith("sun.misc.Launcher$App")) {
                text = "Sun App ClassLoader";
            } else if (text != null && text.startsWith("sun.misc.Launcher$Ext")) {
                text = "Sun Ext ClassLoader";
            }
            classloaders.put(loader, text);
            loader = loader.getParent();
        }
    }

    public static Map<ClassLoader, String> getRegisteredClassLoaders() {
        return classloaders;
    }

    public final synchronized <T> JavaClass<T> getJavaClass(Class<T> cl) {
        assert (cl.getClassLoader() == this) : "This class don't belong to this classloader";
        JavaClass<T> javaClass = JavaClass.cast(this.classCache.get(cl), cl);
        if (javaClass == null) {
            javaClass = new JavaClass<T>(cl);
            this.classCache.put(cl, javaClass);
        }
        return javaClass;
    }

    public String toString() {
        String clname = this.getClass().getName();
        int index = clname.lastIndexOf(46);
        if (index != -1) {
            clname = clname.substring(index + 1);
        }
        return clname + "(" + this.creationTime + ")";
    }
}

