/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import oracle.bpm.lang.Binary;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.util.Conversion;

public class Char {
    private static Character NUL = new Character('\u0000');

    public static char charValue(String str) {
        return str == null || str.length() == 0 ? (char)'\u0000' : str.charAt(0);
    }

    public static char charValue(Object value) {
        char result;
        if (value == null) {
            result = '\u0000';
        } else if (value instanceof Character) {
            result = ((Character)value).charValue();
        } else if (value instanceof String) {
            result = Char.charValue((String)value);
        } else if (value instanceof Interval) {
            result = (char)((Interval)value).getTotalMicroseconds();
        } else if (value instanceof Time) {
            result = (char)((Time)value).getMicroSeconds();
        } else if (value instanceof Number) {
            result = (char)((Number)value).intValue();
        } else if (value instanceof byte[]) {
            result = Conversion.tochar(Binary.deserialize((byte[])value));
        } else {
            throw new IllegalConversionException(value, "String");
        }
        return result;
    }

    public static Character valueOf(char chr) {
        return chr == '\u0000' ? NUL : new Character(chr);
    }

    public static Character valueOf(String str) {
        return str == null ? null : (str.length() == 0 ? NUL : Char.valueOf(str.charAt(0)));
    }

    public static Character valueOf(Object value) {
        return value == null || value instanceof Character ? (Character)value : Char.valueOf(Char.charValue(value));
    }
}

