/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.lang.IllegalConversionException;
import oracle.bpm.util.Base64;

@Component(module="Fuego.Internal", hideInheritance=true)
public final class Binary {
    private byte[] data;
    public static final int BASE64BINARY = 0;
    public static final int HEXBINARY = 1;

    public Binary(byte[] data) {
        this.data = data;
    }

    public static Object deserialize(byte[] data) {
        return Binary.valueOf(data).toObject();
    }

    public static Binary valueOf(byte[] data) {
        return new Binary(data);
    }

    public static byte[] serialize(Object value) {
        byte[] result;
        try {
            if (value == null || value instanceof byte[]) {
                result = (byte[])value;
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                result = blob.getBytes(1L, (int)blob.length());
            } else {
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                if (value instanceof InputStream) {
                    StreamUtils.copy((InputStream)value, bas);
                } else {
                    ObjectOutputStream os = new ObjectOutputStream(bas);
                    os.writeObject(value);
                    os.close();
                }
                result = bas.toByteArray();
            }
        }
        catch (SQLException e) {
            throw new IllegalConversionException(value, "Binary", e.toString());
        }
        catch (IOException e) {
            throw new IllegalConversionException(value, "Binary", e.toString());
        }
        return result;
    }

    public static Binary valueOf(Object value) {
        return Binary.valueOf(Binary.serialize(value));
    }

    public byte[] compress() throws IOException {
        if (this.data == null) {
            return null;
        }
        ByteArrayOutputStream byto = new ByteArrayOutputStream();
        GZIPOutputStream dfin = new GZIPOutputStream(byto);
        dfin.write(this.data, 0, this.data.length);
        dfin.close();
        return byto.toByteArray();
    }

    public byte[] decompress() throws IOException {
        if (this.data == null) {
            return null;
        }
        ByteArrayInputStream byti = new ByteArrayInputStream(this.data);
        GZIPInputStream dfos = new GZIPInputStream(byti);
        return StreamUtils.readBytes(dfos);
    }

    public String encode() {
        return Base64.encode(this.data);
    }

    public long length() {
        return this.data != null ? (long)this.data.length : 0L;
    }

    public Object toObject() {
        try {
            return this.data == null ? null : MyObjectInputStream.deserialize(this.data);
        }
        catch (Exception e) {
            throw IllegalConversionException.createBinaryError(e);
        }
    }

    public String toString() {
        Object obj = this.toObject();
        return obj == null ? null : obj.toString();
    }

    public byte[] getData() {
        return this.data;
    }

    private static class MyObjectInputStream
    extends ObjectInputStream {
        private MyObjectInputStream(ByteArrayInputStream bas) throws IOException {
            super(bas);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class<?> cl = null;
            try {
                cl = Class.forName(desc.getName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return cl != null ? cl : super.resolveClass(desc);
        }

        private static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
            return new MyObjectInputStream(new ByteArrayInputStream(data)).readObject();
        }
    }

    public static class Holder {
        public byte[] value;

        public Holder() {
        }

        public Holder(byte[] init) {
            this.value = init;
        }
    }
}

