/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.io.PersistenceInputStream;
import oracle.bpm.io.ReferenceManager;
import oracle.bpm.io.TransferOutputStream;
import oracle.bpm.lang.Bool;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RuntimeExceptionShell;
import oracle.bpm.lang.ValidationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Component(module="Fuego.Internal", hideInheritance=true)
public class Any
implements Serializable {
    private final Object value;
    static final long serialVersionUID = -6568924969213095585L;
    private static volatile Method cloneMethod;
    static final long serialCheck = -5608589473187621014L;

    public Any(Object value) {
        this.value = value;
    }

    public static void check(Object object) throws ValidationException {
        Any.check(object, null);
    }

    public static void check(Object object, Set<Object> checked) throws ValidationException {
        if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            if (!value.booleanValue()) {
                throw new ValidationException();
            }
        } else if (object != null) {
            try {
                if (checked == null) {
                    checked = new HashSet<Object>();
                }
                if (checked.contains(object)) {
                    return;
                }
                checked.add(object);
                if (object instanceof Invokeable) {
                    Invokeable invokeable = (Invokeable)object;
                    invokeable.invoke("M_check(Ljava.util.Set;)V", checked);
                } else {
                    Class<?> cl = object.getClass();
                    Method check = cl.getMethod("_check", Set.class);
                    check.invoke(object, checked);
                }
            }
            catch (NoSuchMethodException ignore) {
            }
            catch (SecurityException ignore) {
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof ValidationException) {
                    throw (ValidationException)targetException;
                }
                throw new RuntimeExceptionShell(targetException);
            }
            catch (ComponentExecutionException e) {
                throw new RuntimeExceptionShell(e);
            }
        }
    }

    public static <T> T clone(T obj) {
        Object result;
        try {
            if (obj instanceof Cloneable) {
                if (cloneMethod == null) {
                    Method mtd = Object.class.getDeclaredMethod("clone", new Class[0]);
                    mtd.setAccessible(true);
                    cloneMethod = mtd;
                }
                result = cloneMethod.invoke(obj, (Object[])null);
            } else if (obj instanceof Serializable) {
                result = Any.deepCopy(obj);
            } else if (obj != null) {
                DynamicObject dobj = DynamicObject.valueOf(obj);
                result = dobj.convertTo(obj.getClass());
            } else {
                result = obj;
            }
            ReferenceManager.reset(result);
        }
        catch (Exception e) {
            throw new RuntimeExceptionShell(e);
        }
        return Cast.forceTo(obj, result);
    }

    @Hidden
    public static int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Boolean) {
            return Bool.compare((Boolean)o1, (Boolean)o2);
        }
        Comparable comp1 = (Comparable)Cast.force(o1);
        return comp1.compareTo(o2);
    }

    @Exclude
    public static <T> Holder<T> createHolder(T value) {
        return new Holder<T>(value);
    }

    public static Object deepCopy(Object obj) {
        return Any.deepCopy(obj, obj.getClass().getClassLoader());
    }

    public static Object deepCopy(Object obj, final ClassLoader classLoader) {
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TransferImplOutputStream oos = new TransferImplOutputStream(out);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            PersistenceInputStream ois = new PersistenceInputStream(in){

                protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    String name = desc.getName();
                    return JavaClass.loadByJavaType(name, classLoader);
                }
            };
            obj = ois.readObject();
            return obj;
        }
        catch (IOException e) {
            throw new RuntimeExceptionShell(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionShell(e);
        }
    }

    @oracle.bpm.component.metadata.Method(parameters={"obj1 : Any", "obj2 : Any"})
    public static boolean equals(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
        }
        if (obj1 instanceof Number && obj2 instanceof Number) {
            return ((Number)obj1).doubleValue() == ((Number)obj2).doubleValue();
        }
        return obj1.equals(obj2);
    }

    public static boolean isLazyHolder(@NotNull String ht) {
        if (ht == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/lang/Any.isLazyHolder must not be null");
        }
        return ht.equals(LazyHolder.class.getName());
    }

    @oracle.bpm.component.metadata.Method(parameters={"other : Any"})
    public boolean equals(@Nullable Object other) {
        return Any.equals(this.value, other);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    private static class TransferImplOutputStream
    extends ObjectOutputStream
    implements TransferOutputStream {
        TransferImplOutputStream(OutputStream out) throws IOException {
            super(out);
        }
    }

    public static class LazyHolder<V>
    implements oracle.bpm.lang.Holder<V> {
        protected V value;

        public LazyHolder() {
        }

        public LazyHolder(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }

        @Override
        public void put(V value) {
            this.value = value;
        }

        public final V set(V value) {
            this.put(value);
            return value;
        }
    }

    public static class Holder<V>
    implements Serializable {
        public V value;
        static final long serialCheck = -7021375224545538207L;
        static final long serialVersionUID = 1552690921996630079L;

        public Holder() {
        }

        public Holder(V value) {
            this.value = value;
        }
    }
}

