/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class WriterFactory {
    public static final String DEFAULT_ENCODING = "UTF-8";

    private WriterFactory() {
    }

    public static BufferedWriter createFileWriter(File file) throws IOException {
        return WriterFactory.createFileWriter(file, DEFAULT_ENCODING);
    }

    public static BufferedWriter createFileWriter(File file, String encoding) throws IOException {
        return WriterFactory.createFileWriter(file, encoding, false);
    }

    public static BufferedWriter createFileWriter(File file, String encoding, boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, append);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, encoding);
        return new BufferedWriter(osw);
    }

    public static PrintWriter createPrintWriter(File file) throws IOException {
        return WriterFactory.createPrintWriter(file, DEFAULT_ENCODING);
    }

    public static PrintWriter createPrintWriter(File file, String encoding) throws IOException {
        return new PrintWriter(WriterFactory.createFileWriter(file, encoding));
    }
}

