/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.io.ExtensionFileFilter;

public class FileCollector {
    public static StringList listFiles(String dir, String extension) {
        StringList list = StringList.create();
        String[] ret = new File(dir).list(ExtensionFileFilter.create(extension));
        if (ret != null) {
            for (String file : ret) {
                list.add(file);
            }
        }
        return list;
    }

    public static List<File> listFiles(File dir, String extension) {
        File[] files = dir.listFiles(ExtensionFileFilter.create(extension));
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public static List<File> listFilesRecursively(File dir, String extension) {
        ArrayList<File> result = new ArrayList<File>();
        ExtensionFileFilter filter = ExtensionFileFilter.create(extension);
        FileCollector.recurse(dir, filter, result);
        return result;
    }

    private static void recurse(File dir, ExtensionFileFilter filter, List<File> result) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                FileCollector.recurse(file, filter, result);
                continue;
            }
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            result.add(file);
        }
    }
}

