/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.RectangularShape;
import org.jetbrains.annotations.NotNull;

public class Rectangle
extends RectangularShape
implements Serializable {
    public static final Rectangle ZERO = new Rectangle(0, 0, 0, 0);
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    static final long serialVersionUID = 9050382976558765751L;
    static final long serialCheck = -2867184463146837767L;

    public Rectangle() {
        this(Point.ORIGIN, Dimension.ZERO);
    }

    public Rectangle(Rectangle r) {
        this(r.getOrigin(), r.getSize());
    }

    public Rectangle(Point origin) {
        this(origin, Dimension.ZERO);
    }

    public Rectangle(Dimension dimension) {
        this(Point.ORIGIN, dimension);
    }

    public Rectangle(String str) {
        super(str);
    }

    public Rectangle(Rectangle2D rectangle2D) {
        this((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public Rectangle(int width, int height) {
        this(Point.ORIGIN, Dimension.valueOf(width, height));
    }

    public Rectangle(Point origin, Point top) {
        this(origin, top.delta(origin));
    }

    public Rectangle(Point origin, Dimension dimension) {
        super(origin, dimension);
    }

    public Rectangle(int x, int y, int width, int height) {
        this(new Point(x, y), Dimension.valueOf(width, height));
    }

    public static Rectangle createAround(Point center, int width, int height) {
        return Rectangle.createAround(center.getX(), center.getY(), width, height);
    }

    public static Rectangle createAround(Point center, int side) {
        return Rectangle.createAround(center.getX(), center.getY(), side, side);
    }

    public static Rectangle createAround(int x, int y, int side) {
        return Rectangle.createAround(x, y, side, side);
    }

    public static Rectangle createAround(int x, int y, int width, int height) {
        return Rectangle.valueOf(x - width / 2, y - height / 2, width, height);
    }

    public static Rectangle deriveFromPoints(@NotNull Point a, @NotNull Point b) {
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.deriveFromPoints must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/Rectangle.deriveFromPoints must not be null");
        }
        return new Rectangle(a.min(b), a.max(b));
    }

    public static Rectangle valueOf(int x, int y, int width, int height) {
        return new Rectangle(x, y, width, height);
    }

    public static Rectangle valueOf(@NotNull Point origin, int width, int height) {
        if (origin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.valueOf must not be null");
        }
        return Rectangle.valueOf(origin, Dimension.valueOf(width, height));
    }

    public static Rectangle valueOf(int x, int y, Dimension size) {
        return Rectangle.valueOf(new Point(x, y), size);
    }

    public static Rectangle valueOf(@NotNull Point origin, @NotNull Dimension size) {
        if (origin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.valueOf must not be null");
        }
        if (size == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/Rectangle.valueOf must not be null");
        }
        return new Rectangle(origin, size);
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        if (this.isEmpty() || w <= 0 || h <= 0) {
            return false;
        }
        double x0 = this.getX();
        double y0 = this.getY();
        return (double)x >= x0 && (double)y >= y0 && (double)(x + w) <= x0 + (double)this.getWidth() && (double)(y + h) <= y0 + (double)this.getHeight();
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result && (result = o instanceof Rectangle)) {
            Rectangle that = (Rectangle)o;
            result = this.getSize().equals(that.getSize()) && this.getOrigin().equals(that.getOrigin());
        }
        return result;
    }

    public int hashCode() {
        return 29 * this.getSize().hashCode() + this.getOrigin().hashCode();
    }

    public Rectangle intersection(Rectangle r) {
        int tx1 = this.getX();
        int ty1 = this.getY();
        int rx1 = r.getX();
        int ry1 = r.getY();
        long tx2 = tx1;
        tx2 += (long)this.getWidth();
        long ty2 = ty1;
        ty2 += (long)this.getHeight();
        long rx2 = rx1;
        rx2 += (long)r.getWidth();
        long ry2 = ry1;
        ry2 += (long)r.getHeight();
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, (int)tx2, (int)ty2);
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        boolean result;
        int tw = this.getWidth();
        int th = this.getHeight();
        int rw = w;
        int rh = h;
        boolean bl = result = rw > 0 && rh > 0 && tw > 0 && th > 0;
        if (result) {
            int tx = this.getX();
            int ty = this.getY();
            rh += y;
            tw += tx;
            th += ty;
            result = !((rw += x) >= x && rw <= tx || rh >= y && rh <= ty || tw >= tx && tw <= x || th >= ty && th <= y);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.getWidth() <= 0 || this.getHeight() <= 0;
    }

    public String toString() {
        return this.getOrigin() + ":" + this.getSize();
    }

    public Rectangle translate(int x, int y) {
        return new Rectangle(this.getOrigin().translate(x, y), this.getSize());
    }

    public Rectangle translate(Point point) {
        return new Rectangle(point, this.getSize());
    }

    public Rectangle union(Rectangle r) {
        return new Rectangle(this.getOrigin().min(r.getOrigin()), this.getTop().max(r.getTop()));
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        int out1;
        int out2 = this.outcode(x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = this.outcode(x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                int x = this.getX();
                if ((out1 & 4) != 0) {
                    x += this.getWidth();
                }
                y1 += (x - x1) * (y2 - y1) / (x2 - x1);
                x1 = x;
                continue;
            }
            int y = this.getY();
            if ((out1 & 8) != 0) {
                y += this.getHeight();
            }
            x1 += (y - y1) * (x2 - x1) / (y2 - y1);
            y1 = y;
        }
        return true;
    }

    public int outcode(int x, int y) {
        int out = 0;
        if (this.getWidth() <= 0) {
            out |= 5;
        } else if (x < this.getX()) {
            out |= 1;
        } else if ((double)x > (double)this.getX() + (double)this.getWidth()) {
            out |= 4;
        }
        if (this.getHeight() <= 0) {
            out |= 0xA;
        } else if (y < this.getY()) {
            out |= 2;
        } else if ((double)y > (double)this.getY() + (double)this.getHeight()) {
            out |= 8;
        }
        return out;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Point getCenter() {
        Point point = new Point(this.getCenterX(), this.getCenterY());
        if (point == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.getCenter must not return null");
        }
        return point;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle scaled(float scale) {
        Rectangle rectangle = new Rectangle(this.getOrigin().scaled(scale), this.getSize().scale(scale));
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.scaled must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle transposed() {
        Rectangle rectangle = new Rectangle(this.getOrigin().transposed(), this.getSize().transposed());
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.transposed must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle shrink(int i) {
        Rectangle rectangle = this.expand(-i);
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.shrink must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle expand(int i) {
        Rectangle rectangle = Rectangle.valueOf(this.getX() - i, this.getY() - i, this.getWidth() + i * 2, this.getHeight() + i * 2);
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.expand must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle shrink(@NotNull Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.shrink must not be null");
        }
        Rectangle rectangle = new Rectangle(this.getX() + insets.left, this.getY() + insets.top, this.getWidth() - insets.right, this.getHeight() - insets.bottom);
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.shrink must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle expand(@NotNull Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.expand must not be null");
        }
        Rectangle rectangle = new Rectangle(this.getX() - insets.left, this.getY() - insets.top, this.getWidth() + insets.right, this.getHeight() + insets.bottom);
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.expand must not return null");
        }
        return rectangle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Rectangle expandToPoint(@NotNull Point point) {
        if (point == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/Rectangle.expandToPoint must not be null");
        }
        Rectangle rectangle = new Rectangle(this.getOrigin().min(point), this.getTop().max(point));
        if (rectangle == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/geom/Rectangle.expandToPoint must not return null");
        }
        return rectangle;
    }
}

