/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class QuadCurve
extends QuadCurve2D.Double
implements Path {
    private static final long serialVersionUID = 9201430399128057857L;

    public QuadCurve(@NotNull Point p1, @NotNull Point ctrl, @NotNull Point p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/QuadCurve.<init> must not be null");
        }
        if (ctrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/QuadCurve.<init> must not be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/geom/QuadCurve.<init> must not be null");
        }
        super(p1.getX(), p1.getY(), ctrl.getX(), ctrl.getY(), p2.getX(), p2.getY());
    }

    public QuadCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        super(x1, y1, ctrlx, ctrly, x2, y2);
    }

    public static QuadCurve createFromMiddlePoint(Point begin, Point middle, Point end) {
        Point controlPoint = QuadCurve.calculateControlPoint(begin, middle, end);
        return new QuadCurve(begin, controlPoint, end);
    }

    public static Point calculateControlPoint(@NotNull Point begin, @NotNull Point middle, @NotNull Point end) {
        if (begin == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/geom/QuadCurve.calculateControlPoint must not be null");
        }
        if (middle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/geom/QuadCurve.calculateControlPoint must not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/geom/QuadCurve.calculateControlPoint must not be null");
        }
        int x1 = end.getX();
        int y1 = end.getY();
        int xA = 2 * begin.getX() - 4 * middle.getX() + 2 * x1;
        int xB = -3 * begin.getX() + 4 * middle.getX() - x1;
        int yA = 2 * begin.getY() - 4 * middle.getY() + 2 * y1;
        int yB = -3 * begin.getY() + 4 * middle.getY() - y1;
        double ctrlx = x1 - xA - xB / 2;
        double ctrly = y1 - yA - yB / 2;
        return new Point((int)ctrlx, (int)ctrly);
    }

    public static Point calculateControlPoint(Point begin, Point end, int distance) {
        double angle = begin.angle(end);
        long cpx = Math.round((double)(begin.getX() + end.getX()) / 2.0 - (double)distance * Math.sin(angle));
        long cpy = Math.round((double)(begin.getY() + end.getY()) / 2.0 + (double)distance * Math.cos(angle));
        return QuadCurve.calculateControlPoint(end, new Point((int)cpx, (int)cpy), begin);
    }

    @Override
    public Point2D eval(double t) {
        double u = 1.0 - t;
        return new Point2D.Double(this.x1 * u * u + 2.0 * this.ctrlx * t * u + this.x2 * t * t, this.y1 * u * u + 2.0 * this.ctrly * t * u + this.y2 * t * t);
    }

    @Override
    public Point2D findPoint(Point2D point, double distance, double base) {
        return this.findPoint(point, distance, base, 1.0, true);
    }

    @Override
    public Point2D findPointBackwards(Point2D point, double distance, double base) {
        return this.findPoint(point, distance, 0.0, base, false);
    }

    public Point2D findPoint(Point2D point, double distance, double low, double high, boolean fwd) {
        double distanceSq = distance * distance;
        double tolerance = distanceSq / 10000.0;
        Point2D p2 = point;
        while (low < high) {
            double mid = (low + high) / 2.0;
            Point2D p = this.eval(mid);
            if (Math.floor(p.getX()) == Math.floor(p2.getX()) && Math.floor(p.getY()) == Math.floor(p2.getY())) {
                return p;
            }
            double diff = distanceSq - point.distanceSq(p);
            if (diff > tolerance) {
                if (fwd) {
                    low = mid;
                } else {
                    high = mid;
                }
            } else if (diff < -tolerance) {
                if (fwd) {
                    high = mid;
                } else {
                    low = mid;
                }
            } else {
                return p;
            }
            p2 = p;
        }
        return p2;
    }

    @Override
    public boolean intersects(Rectangle r) {
        boolean result;
        boolean bl = result = r.contains((int)this.x1, (int)this.y1) || r.contains((int)this.x2, (int)this.y2);
        if (!result) {
            int rx = r.getX();
            int ry = r.getY();
            int rw = r.getWidth();
            int rh = r.getHeight();
            result = QuadCurve.intersectsLine(this.y1, this.ctrly, this.y2, ry, this.x1, this.ctrlx, this.x2, rx, rx + rw) || QuadCurve.intersectsLine(this.y1, this.ctrly, this.y2, ry + rh, this.x1, this.ctrlx, this.x2, rx, rx + rw) || QuadCurve.intersectsLine(this.x1, this.ctrlx, this.x2, rx, this.y1, this.ctrly, this.y2, ry, ry + rh) || QuadCurve.intersectsLine(this.x1, this.ctrlx, this.x2, rx + rw, this.y1, this.ctrly, this.y2, ry, ry + rh);
        }
        return result;
    }

    @Override
    public Path scaled(float scale) {
        return scale == 1.0f ? this : new QuadCurve(this.getX1() * (double)scale, this.getY1() * (double)scale, this.getCtrlX() * (double)scale, this.getCtrlY() * (double)scale, this.getX2() * (double)scale, this.getY2() * (double)scale);
    }

    public String toString() {
        return "Quad [ from " + this.getP1() + ", ctrl " + this.getCtrlPt() + ", to " + this.getP2() + " ]";
    }

    private static boolean intersectsLine(double p0, double p1, double p2, double c, double pb0, double pb1, double pb2, double from, double to) {
        boolean result;
        double[] eqn = new double[]{p0 - c, 2.0 * p1 - 2.0 * p0, p0 - 2.0 * p1 + p2};
        int nRoots = QuadCurve2D.solveQuadratic(eqn);
        switch (nRoots) {
            case 1: {
                result = QuadCurve.checkRoot(eqn[0], pb0, pb1, pb2, from, to);
                break;
            }
            case 2: {
                result = QuadCurve.checkRoot(eqn[0], pb0, pb1, pb2, from, to);
                if (result) break;
                result = QuadCurve.checkRoot(eqn[1], pb0, pb1, pb2, from, to);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private static boolean checkRoot(double root, double pb0, double pb1, double pb2, double from, double to) {
        boolean result;
        boolean bl = result = root >= 0.0 && root <= 1.0;
        if (result) {
            double u = 1.0 - root;
            double intersection = pb0 * u * u + 2.0 * pb1 * root * u + pb2 * root * root;
            result = intersection >= from && intersection <= to;
        }
        return result;
    }
}

