/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import java.io.Serializable;

public class Insets
implements Serializable,
Cloneable {
    public final int bottom;
    public final int left;
    public final int right;
    public final int top;
    static final long serialCheck = 5421761829654828768L;
    private static final long serialVersionUID = -2272572637695466749L;
    public static final Insets EMPTY = new Insets(0, 0, 0, 0);

    public Insets(int top, int left, int bottom, int right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public Insets clone() {
        try {
            return (Insets)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Insets scaled(float scale) {
        Insets result = scale != 1.0f ? new Insets(Math.round((float)this.top * scale), Math.round((float)this.left * scale), Math.round((float)this.bottom * scale), Math.round((float)this.right * scale)) : this;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Insets) {
            Insets insets = (Insets)obj;
            return this.top == insets.top && this.left == insets.left && this.bottom == insets.bottom && this.right == insets.right;
        }
        return false;
    }

    public int hashCode() {
        int sum1 = this.left + this.bottom;
        int sum2 = this.right + this.top;
        int val1 = sum1 * (sum1 + 1) / 2 + this.left;
        int val2 = sum2 * (sum2 + 1) / 2 + this.top;
        int sum3 = val1 + val2;
        return sum3 * (sum3 + 1) / 2 + val2;
    }

    public String toString() {
        return this.getClass().getName() + "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
    }
}

