/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.geom;

import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.geom.RectangularShape;

public class Arc
extends RectangularShape {
    private int angleExtent;
    private int angleStart;

    public Arc(int x, int y, int w, int h, int start, int extent) {
        super(x, y, w, h);
        this.angleStart = start;
        this.angleExtent = extent;
    }

    public int getAngleStart() {
        return this.angleStart;
    }

    public int getAngleExtent() {
        return this.angleExtent;
    }

    @Override
    public boolean isEmpty() {
        return this.getWidth() <= 0 || this.getHeight() <= 0;
    }

    @Override
    public boolean contains(int x, int y) {
        boolean result;
        int ellw = this.getWidth();
        if (ellw <= 0) {
            result = false;
        } else {
            double normy;
            double distSq;
            double normx = (double)((x - this.getX()) / ellw) - 0.5;
            int ellh = this.getHeight();
            result = ellh <= 0 ? false : (distSq = normx * normx + (normy = (double)((y - this.getY()) / ellh) - 0.5) * normy) < 0.25 && Math.abs(this.getAngleExtent()) >= 360 || this.containsAngle(-Math.toDegrees(Math.atan2(normy, normx)));
        }
        return result;
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        boolean result;
        boolean bl = result = this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
        if (result && Math.abs(this.getAngleExtent()) > 180) {
            int ye;
            double angle;
            int xe;
            int yc;
            Rectangle origrect = new Rectangle(x, y, w, h);
            int halfW = this.getWidth() / 2;
            int halfH = this.getHeight() / 2;
            int xc = this.getX() + halfW;
            result = origrect.intersectsLine(xc, yc = this.getY() + halfH, xe = (int)((double)xc + (double)halfW * Math.cos(angle = Math.toRadians(-this.getAngleStart()))), ye = (int)((double)yc + (double)halfH * Math.sin(angle))) ? false : !origrect.intersectsLine(xc, yc, xe = (int)((double)xc + (double)halfW * Math.cos(angle += Math.toRadians(-this.getAngleExtent()))), ye = (int)((double)yc + (double)halfH * Math.sin(angle)));
        }
        return result;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        int aw = this.getWidth();
        int ah = this.getHeight();
        if (w <= 0 || h <= 0 || aw <= 0 || ah <= 0) {
            return false;
        }
        double ext = this.getAngleExtent();
        if (ext == 0.0) {
            return false;
        }
        double ax = this.getX();
        double ay = this.getY();
        double axw = ax + (double)aw;
        double ayh = ay + (double)ah;
        double xw = x + w;
        double yh = y + h;
        if ((double)x >= axw || (double)y >= ayh || xw <= ax || yh <= ay) {
            return false;
        }
        int axc = this.getCenterX();
        int ayc = this.getCenterY();
        Point sp = this.getStartPoint();
        Point ep = this.getEndPoint();
        int sx = sp.getX();
        int sy = sp.getY();
        int ex = ep.getX();
        int ey = ep.getY();
        if (ayc >= y && (double)ayc <= yh && ((double)sx < xw && (double)ex < xw && (double)axc < xw && axw > (double)x && this.containsAngle(0.0) || sx > x && ex > x && axc > x && ax < xw && this.containsAngle(180.0))) {
            return true;
        }
        if (axc >= x && (double)axc <= xw && (sy > y && ey > y && ayc > y && ay < yh && this.containsAngle(90.0) || (double)sy < yh && (double)ey < yh && (double)ayc < yh && ayh > (double)y && this.containsAngle(270.0))) {
            return true;
        }
        Rectangle rect = new Rectangle(x, y, w, h);
        if (rect.intersectsLine(axc, ayc, sx, sy) || rect.intersectsLine(axc, ayc, ex, ey)) {
            return true;
        }
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    public boolean containsAngle(double angle) {
        boolean backwards;
        int angExt = this.getAngleExtent();
        boolean bl = backwards = angExt < 0;
        if (backwards) {
            angExt = -angExt;
        }
        if (angExt >= 360) {
            return true;
        }
        angle = Arc.normalizeDegrees(angle) - Arc.normalizeDegrees(this.getAngleStart());
        if (backwards) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle >= 0.0 && angle < (double)angExt;
    }

    public Point getStartPoint() {
        double angle = Math.toRadians(-this.getAngleStart());
        return this.pointForAngle(angle);
    }

    public Point getEndPoint() {
        double angle = Math.toRadians(-this.getAngleStart() - this.getAngleExtent());
        return this.pointForAngle(angle);
    }

    private static double normalizeDegrees(double angle) {
        if (angle > 180.0) {
            angle = angle <= 540.0 ? angle - 360.0 : Arc.normalizeBig(angle);
        } else if (angle <= -180.0) {
            angle = angle > -540.0 ? angle + 360.0 : Arc.normalizeBig(angle);
        }
        return angle;
    }

    private static double normalizeBig(double angle) {
        if ((angle = Math.IEEEremainder(angle, 360.0)) == -180.0) {
            angle = 180.0;
        }
        return angle;
    }

    private int yForAngle(double angle) {
        return (int)((double)this.getY() + (Math.sin(angle) * 0.5 + 0.5) * (double)this.getHeight());
    }

    private int xForAngle(double angle) {
        return (int)((double)this.getX() + (Math.cos(angle) * 0.5 + 0.5) * (double)this.getWidth());
    }

    private Point pointForAngle(double angle) {
        return new Point(this.xForAngle(angle), this.yForAngle(angle));
    }
}

