/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.extension;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.extension.Extension;
import oracle.bpm.extension.ExtensionList;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.util.LazyHolder;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractExtensionService
implements ExtensionService {
    private final LazyHolder<Map<String, String>> points = new LazyHolder<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> init() {
            try {
                return AbstractExtensionService.this.loadExtensionPoints();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    };

    @Override
    public ExtensionList getExtensions() {
        return new ExtensionList();
    }

    public <M extends Annotation> List<M> getExtensionsMetadataByPoint(Class<M> pointType) {
        List<Extension<M>> extensions = this.getExtensionsByPoint(pointType);
        ArrayList<M> result = new ArrayList<M>(extensions.size());
        for (Extension<M> extension : extensions) {
            result.add(extension.getMetadata());
        }
        return result;
    }

    protected abstract Map<String, String> loadExtensionPoints() throws IOException;

    protected <T extends Annotation> String getPointId(Class<T> pointType) {
        String pointTypeName = pointType.getName();
        String pointId = this.points.get().get(pointTypeName);
        assert (pointId != null) : "No point for: " + pointTypeName + ". Make sure that there is a file 'plugin.properties' in the module or plugin that contains the class " + pointTypeName;
        return pointId;
    }
}

