/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.execution.ExecutionService;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.execution.InterceptorChain;

public class DefaultExecutionService
implements ExecutionService {
    private Map<Class, ChainImpl> chainCache;
    private final Map<Class, ChainImpl> classChains;
    private ChainImpl defaultChain = new ExecuteChain();
    private ChainImpl globalChain;
    private ThreadLocal<ExecutableStack> stack;

    public DefaultExecutionService() {
        this.classChains = new HashMap<Class, ChainImpl>();
        this.chainCache = new HashMap<Class, ChainImpl>();
        this.stack = new ThreadLocal<ExecutableStack>(){

            @Override
            protected ExecutableStack initialValue() {
                return new ExecutableStack();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptor(Interceptor interceptor) {
        GlobalChain newChain = new GlobalChain(interceptor);
        DefaultExecutionService defaultExecutionService = this;
        synchronized (defaultExecutionService) {
            this.globalChain = this.globalChain == null ? newChain : this.globalChain.copy().add(newChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptor(Interceptor interceptor) {
        DefaultExecutionService defaultExecutionService = this;
        synchronized (defaultExecutionService) {
            ChainImpl newChain = this.globalChain.copy();
            this.globalChain = newChain.remove(interceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterceptorByClass(Interceptor interceptor, Class<? extends Executable> cl) {
        ChainImpl newChain = new ClassChain(interceptor);
        Map<Class, ChainImpl> map = this.classChains;
        synchronized (map) {
            ChainImpl chain = this.classChains.get(cl);
            if (chain != null) {
                newChain = chain.copy().add(newChain);
            }
            this.classChains.put(cl, newChain);
        }
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterceptorByClass(Interceptor interceptor, Class<? extends Executable> cl) {
        Map<Class, ChainImpl> map = this.classChains;
        synchronized (map) {
            ChainImpl chain = this.classChains.get(cl);
            if (chain != null) {
                chain = chain.copy().remove(interceptor);
            }
            this.classChains.put(cl, chain);
        }
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Executable executable) throws ExecutionException {
        ExecutableStack executionStack = this.stack.get();
        try {
            Object object;
            executionStack.push(executable);
            Class<?> cl = executable.getClass();
            ChainImpl chain = this.chainCache.get(cl);
            if (chain == null) {
                chain = this.buildChain(cl);
                object = this;
                synchronized (object) {
                    HashMap<Class, ChainImpl> newMap = new HashMap<Class, ChainImpl>(this.chainCache);
                    newMap.put(cl, chain);
                    this.chainCache = newMap;
                }
            }
            object = chain.proceed(executable);
            return object;
        }
        finally {
            executionStack.pop();
        }
    }

    @Override
    public List<Executable> getStack() {
        return this.stack.get();
    }

    private void clearCache() {
        this.chainCache = new HashMap<Class, ChainImpl>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChainImpl buildChain(Class<? extends Executable> cl) {
        HashSet<Class> processedInterfaces = new HashSet<Class>();
        ChainImpl result = null;
        Map<Class, ChainImpl> map = this.classChains;
        synchronized (map) {
            for (Class<? extends Executable> current = cl; current != null; current = current.getSuperclass()) {
                result = this.addChainForClassTo(current, result);
                result = this.addChainForInterfacesTo(current.getInterfaces(), processedInterfaces, result);
            }
        }
        if (result == null) {
            result = new NullClassChain();
        }
        return result;
    }

    private ChainImpl addChainForInterfacesTo(Class<?>[] interfaces, Set<Class> processedInterfaces, ChainImpl result) {
        for (Class<?> iface : interfaces) {
            if (processedInterfaces.contains(iface)) continue;
            processedInterfaces.add(iface);
            result = this.addChainForClassTo(iface, result);
            result = this.addChainForInterfacesTo(iface.getInterfaces(), processedInterfaces, result);
        }
        return result;
    }

    private ChainImpl addChainForClassTo(Class<?> current, ChainImpl result) {
        ChainImpl chain = this.classChains.get(current);
        if (chain != null) {
            if (result == null) {
                result = chain.copy();
            } else {
                result.add(chain.copy());
            }
        }
        return result;
    }

    class NullClassChain
    extends ClassChain {
        NullClassChain() {
            super(null);
        }

        @Override
        public Object proceed(Executable executable) {
            return this.getNext().proceed(executable);
        }

        @Override
        ChainImpl getNext() {
            ChainImpl next = DefaultExecutionService.this.globalChain;
            return next != null ? next : DefaultExecutionService.this.defaultChain;
        }

        @Override
        ChainImpl copy() {
            return this;
        }

        @Override
        ChainImpl add(ChainImpl chain) {
            return chain;
        }

        @Override
        ChainImpl remove(Interceptor interceptor) {
            return this;
        }
    }

    class GlobalChain
    extends ChainImpl {
        GlobalChain(Interceptor interceptor) {
            super(interceptor);
        }

        @Override
        ChainImpl getNext() {
            return this.next != null ? this.next : DefaultExecutionService.this.defaultChain;
        }

        @Override
        ChainImpl copy() {
            GlobalChain copy = new GlobalChain(this.interceptor);
            copy.next = this.next != null ? this.next.copy() : null;
            return copy;
        }
    }

    class ExecuteChain
    extends ChainImpl {
        ExecuteChain() {
            super(null);
        }

        @Override
        public Object proceed(Executable executable) {
            return executable.execute();
        }

        @Override
        public String toString() {
            return "<default-execute>";
        }

        @Override
        ChainImpl copy() {
            return this;
        }
    }

    class ClassChain
    extends ChainImpl {
        ClassChain(Interceptor interceptor) {
            super(interceptor);
        }

        @Override
        ChainImpl getNext() {
            ChainImpl globalChain = DefaultExecutionService.this.globalChain;
            return this.next != null ? this.next : (globalChain != null ? globalChain : DefaultExecutionService.this.defaultChain);
        }

        @Override
        ChainImpl copy() {
            ClassChain copy = new ClassChain(this.interceptor);
            copy.next = this.next != null ? this.next.copy() : null;
            return copy;
        }
    }

    static class ExecutableStack
    extends ArrayList<Executable> {
        static final long serialVersionUID = -767986453977134723L;
        static final long serialCheck = -2218339544384732428L;

        ExecutableStack() {
        }

        @Override
        public boolean add(Executable o) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public void add(int index, Executable element) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public boolean addAll(Collection<? extends Executable> c) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public boolean addAll(int index, Collection<? extends Executable> c) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public Executable remove(int index) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Read only collection");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Read only collection");
        }

        public void push(Executable executable) {
            super.add(executable);
        }

        public void pop() {
            super.remove(this.size() - 1);
        }
    }

    abstract class ChainImpl
    implements InterceptorChain {
        protected Interceptor interceptor;
        protected ChainImpl next;

        ChainImpl(Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public Object proceed(Executable executable) {
            ChainImpl next = this.getNext();
            return this.interceptor.execute(executable, next);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.interceptor);
            if (this.next != null) {
                builder.append(" -> ").append(this.next);
            } else {
                ChainImpl next = this.getNext();
                if (next != null) {
                    builder.append(" >>> ");
                    builder.append(next);
                }
            }
            return builder.toString();
        }

        abstract ChainImpl copy();

        ChainImpl add(ChainImpl interceptor) {
            if (this.next != null) {
                this.next.add(interceptor);
            } else {
                this.next = interceptor;
            }
            return this;
        }

        ChainImpl remove(Interceptor interceptor) {
            ChainImpl result;
            if (interceptor == this.interceptor) {
                result = this.next;
            } else {
                result = this;
                result.next = this.next != null ? this.next.remove(interceptor) : null;
            }
            return result;
        }

        ChainImpl getNext() {
            return this.next;
        }
    }
}

