/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.event.EventService;
import oracle.bpm.lang.Cast;

public class DefaultEventService
implements EventService {
    private Map<Class, ListenerList> listenersByClass = new HashMap<Class, ListenerList>();

    @Override
    public <L extends EventListener> void addListener(Class<L> listenerClass, L listener) {
        ListenerList<L> listeners = this.getOrCreateListenerList(listenerClass);
        listeners.add(listener);
    }

    @Override
    public <L extends EventListener> void removeListener(Class<L> listenerClass, L listener) {
        ListenerList<L> listeners = this.getOrCreateListenerList(listenerClass);
        listeners.remove(listener);
    }

    @Override
    public <L extends EventListener> L getListeners(Class<L> listenerClass) {
        ListenerList<L> listenerList = this.getOrCreateListenerList(listenerClass);
        return (L)((EventListener)listenerList.newBroadcaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <L> ListenerList<L> getOrCreateListenerList(Class<L> listenerClass) {
        ListenerList<L> listeners;
        Map<Class, ListenerList> map = this.listenersByClass;
        synchronized (map) {
            listeners = (ListenerList<L>)Cast.force(this.listenersByClass.get(listenerClass));
            if (listeners == null) {
                listeners = new ListenerList<L>(listenerClass);
                this.listenersByClass.put(listenerClass, listeners);
            }
        }
        return listeners;
    }

    private final class ListenerList<L> {
        private List<ListenerBroadcaster<L>> broadcasters;
        private Class<L> listenerClass;
        private List<L> listeners;

        ListenerList(Class<L> listenerClass) {
            this.listenerClass = listenerClass;
            this.broadcasters = new ArrayList<ListenerBroadcaster<L>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public L newBroadcaster() {
            L broadcaster = null;
            ListenerList listenerList = this;
            synchronized (listenerList) {
                ClassLoader classLoader = this.listenerClass.getClassLoader();
                Class[] interfaces = new Class[]{this.listenerClass};
                ListenerBroadcaster<L> handler = new ListenerBroadcaster<L>();
                handler.setListeners(this.listeners);
                broadcaster = Cast.forceTo(broadcaster, Proxy.newProxyInstance(classLoader, interfaces, handler));
                this.broadcasters.add(handler);
            }
            return broadcaster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(L listener) {
            ListenerList listenerList = this;
            synchronized (listenerList) {
                List<L> copy = this.getListCopy();
                copy.add(listener);
                this.listeners = copy;
                this.updateBroadcasters();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(L listener) {
            ListenerList listenerList = this;
            synchronized (listenerList) {
                List<L> copy = this.getListCopy();
                copy.remove(listener);
                this.listeners = copy;
                this.updateBroadcasters();
            }
        }

        private List<L> getListCopy() {
            assert (Thread.holdsLock(this)) : "Call not synchronized";
            List<L> listeners = this.listeners;
            listeners = listeners == null ? new ArrayList<L>() : new ArrayList<L>(listeners);
            return listeners;
        }

        private void updateBroadcasters() {
            assert (Thread.holdsLock(this)) : "Call not synchronized";
            List<L> listeners = this.listeners;
            for (ListenerBroadcaster<L> broadcaster : this.broadcasters) {
                broadcaster.setListeners(listeners);
            }
        }
    }

    private final class ListenerBroadcaster<L>
    implements InvocationHandler {
        private List<L> listeners;

        private ListenerBroadcaster() {
        }

        public void setListeners(List<L> listeners) {
            this.listeners = listeners;
        }

        public List<L> getListeners() {
            return this.listeners;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            List<L> listeners = this.getListeners();
            Object lastResult = null;
            if (listeners != null) {
                for (L listener : listeners) {
                    try {
                        lastResult = method.invoke(listener, args);
                    }
                    catch (Exception unexepected) {
                        unexepected.printStackTrace();
                    }
                }
            }
            return lastResult;
        }
    }
}

