/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.collections.sets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class StringSet
extends TreeSet<String> {
    static final long serialVersionUID = 3883709240678604135L;
    static final long serialCheck = -7431155331206763321L;

    public StringSet(Comparator<String> comparator) {
        super(comparator);
    }

    private StringSet() {
    }

    private StringSet(Collection<String> strings) {
        super(strings);
    }

    public static StringSet create() {
        return new StringSet();
    }

    public static StringSet create(String ... values) {
        return StringSet.valueOf(values);
    }

    public static StringSet valueOf(String[] values) {
        return new StringSet((Collection<String>)Arrays.asList(values));
    }

    public static StringSet create(StringTokenizer tokenizer) {
        StringSet result = StringSet.create();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static StringSet createTokenizing(String string, String separators) {
        return string == null || string.isEmpty() ? StringSet.create() : StringSet.create(new StringTokenizer(string, separators));
    }

    public static StringSet create(Collection<String> values) {
        return new StringSet(values);
    }

    public static StringSet convert(Collection<?> objects) {
        StringSet result = StringSet.create();
        for (Object value : objects) {
            result.add(String.valueOf(value));
        }
        return result;
    }

    public static StringSet createCaseInsensitive() {
        return new StringSet(String.CASE_INSENSITIVE_ORDER);
    }

    public String[] toArray() {
        return this.toArray(new String[this.size()]);
    }

    @Override
    public StringSet clone() {
        return StringSet.create(this);
    }

    public StringSet add(String ... values) {
        this.addAll(Arrays.asList(values));
        return this;
    }
}

